/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cloudfront.CustomOriginCloudFrontDistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.Command;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.ftp.FTPClient;
import ch.cyberduck.core.ftp.FTPCommandFeature;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.ftp.FTPDeleteFeature;
import ch.cyberduck.core.ftp.FTPDirectoryFeature;
import ch.cyberduck.core.ftp.FTPException;
import ch.cyberduck.core.ftp.FTPExceptionMappingService;
import ch.cyberduck.core.ftp.FTPMFMTTimestampFeature;
import ch.cyberduck.core.ftp.FTPMoveFeature;
import ch.cyberduck.core.ftp.FTPParserFactory;
import ch.cyberduck.core.ftp.FTPReadFeature;
import ch.cyberduck.core.ftp.FTPSymlinkFeature;
import ch.cyberduck.core.ftp.FTPTouchFeature;
import ch.cyberduck.core.ftp.FTPUTIMETimestampFeature;
import ch.cyberduck.core.ftp.FTPUnixPermissionFeature;
import ch.cyberduck.core.ftp.FTPWorkdirService;
import ch.cyberduck.core.ftp.FTPWriteFeature;
import ch.cyberduck.core.ftp.LoggingProtocolCommandListener;
import ch.cyberduck.core.ftp.list.FTPListService;
import ch.cyberduck.core.idna.PunycodeConverter;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxySocketFactory;
import ch.cyberduck.core.shared.DefaultCopyFeature;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.SSLSession;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class FTPSession
extends SSLSession<FTPClient> {
    private static final Logger log = Logger.getLogger(FTPSession.class);
    private final Preferences preferences = PreferencesFactory.get();
    private Timestamp timestamp;
    private UnixPermission permission;
    private Symlink symlink;
    private FTPListService listService;
    private Protocol.Case casesensitivity = Protocol.Case.sensitive;

    public FTPSession(Host h) {
        this(h, (X509TrustManager)new DisabledX509TrustManager(), (X509KeyManager)new DefaultX509KeyManager());
    }

    public FTPSession(Host h, X509TrustManager trust, X509KeyManager key) {
        super(h, trust, key);
    }

    public boolean isConnected() {
        if (super.isConnected()) {
            return ((FTPClient)((Object)this.client)).isConnected();
        }
        return false;
    }

    protected void logout() throws BackgroundException {
        try {
            ((FTPClient)((Object)this.client)).logout();
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map(e);
        }
    }

    protected void disconnect() {
        try {
            ((FTPClient)((Object)this.client)).disconnect();
        }
        catch (IOException e) {
            log.warn((Object)String.format("Ignore disconnect failure %s", e.getMessage()));
        }
        super.disconnect();
    }

    public void interrupt() throws BackgroundException {
        if (this.host.getProtocol().isSecure()) {
            log.warn((Object)String.format("Skip disconnect for %s connection to workaround hang in closing socket", this.host.getProtocol()));
            super.disconnect();
        } else {
            super.interrupt();
        }
    }

    protected void configure(FTPClient client) throws IOException {
        client.setProtocol(this.host.getProtocol());
        client.setSocketFactory((SocketFactory)new ProxySocketFactory(this.host.getProtocol(), (TrustManagerHostnameCallback)new DefaultTrustManagerHostnameCallback(this.host)));
        client.setControlEncoding(this.host.getEncoding());
        int timeout = this.preferences.getInteger("connection.timeout.seconds") * 1000;
        client.setConnectTimeout(timeout);
        client.setDefaultTimeout(timeout);
        client.setDataTimeout(timeout);
        client.setDefaultPort(this.host.getProtocol().getDefaultPort());
        client.setParserFactory(new FTPParserFactory());
        client.setRemoteVerificationEnabled(this.preferences.getBoolean("ftp.datachannel.verify"));
        int buffer = this.preferences.getInteger("ftp.socket.buffer");
        client.setBufferSize(buffer);
        if (this.preferences.getInteger("connection.buffer.receive") > 0) {
            client.setReceiveBufferSize(this.preferences.getInteger("connection.buffer.receive"));
        }
        if (this.preferences.getInteger("connection.buffer.send") > 0) {
            client.setSendBufferSize(this.preferences.getInteger("connection.buffer.send"));
        }
        if (this.preferences.getInteger("connection.buffer.receive") > 0) {
            client.setReceieveDataSocketBufferSize(this.preferences.getInteger("connection.buffer.receive"));
        }
        if (this.preferences.getInteger("connection.buffer.send") > 0) {
            client.setSendDataSocketBufferSize(this.preferences.getInteger("connection.buffer.send"));
        }
        client.setStrictMultilineParsing(this.preferences.getBoolean("ftp.parser.multiline.strict"));
        client.setStrictReplyParsing(this.preferences.getBoolean("ftp.parser.reply.strict"));
    }

    public FTPClient connect(Proxy proxy, HostKeyCallback callback, LoginCallback prompt) throws BackgroundException {
        try {
            CustomTrustSSLProtocolSocketFactory f = new CustomTrustSSLProtocolSocketFactory(this.trust, this.key);
            final LoggingProtocolCommandListener listener = new LoggingProtocolCommandListener((TranscriptListener)this);
            FTPClient client = new FTPClient(this.host.getProtocol(), (SSLSocketFactory)f, f.getSSLContext()){

                public void disconnect() throws IOException {
                    try {
                        super.disconnect();
                    }
                    finally {
                        this.removeProtocolCommandListener(listener);
                    }
                }
            };
            client.addProtocolCommandListener(listener);
            this.configure(client);
            client.connect(new PunycodeConverter().convert(this.host.getHostname()), this.host.getPort());
            client.setTcpNoDelay(false);
            return client;
        }
        catch (IOException e) {
            throw new FTPExceptionMappingService().map(e);
        }
    }

    protected FTPConnectMode getConnectMode() {
        if (FTPConnectMode.unknown == this.host.getFTPConnectMode()) {
            return FTPConnectMode.passive;
        }
        return this.host.getFTPConnectMode();
    }

    public Protocol.Case getCaseSensitivity() {
        return this.casesensitivity;
    }

    public boolean alert(ConnectionCallback callback) throws BackgroundException {
        block6: {
            if (super.alert(callback)) {
                try {
                    if (((FTPClient)((Object)this.client)).hasFeature("AUTH", "TLS") && ((FTPClient)((Object)this.client)).hasFeature("PBSZ") && ((FTPClient)((Object)this.client)).hasFeature("PROT")) {
                        try {
                            callback.warn(this.host, MessageFormat.format(LocaleFactory.localizedString((String)"Unsecured {0} connection", (String)"Credentials"), this.host.getProtocol().getName()), MessageFormat.format("{0} {1}.", MessageFormat.format(LocaleFactory.localizedString((String)"The server supports encrypted connections. Do you want to switch to {0}?", (String)"Credentials"), ProtocolFactory.get().forScheme(Scheme.ftps).getName()), LocaleFactory.localizedString((String)"Please contact your web hosting service provider for assistance", (String)"Support")), LocaleFactory.localizedString((String)"Continue", (String)"Credentials"), LocaleFactory.localizedString((String)"Change", (String)"Credentials"), String.format("connection.unsecure.%s", this.host.getHostname()));
                        }
                        catch (LoginCanceledException e) {
                            this.host.setProtocol(ProtocolFactory.get().forScheme(Scheme.ftps));
                            this.configure((FTPClient)((Object)this.client));
                            ((FTPClient)((Object)this.client)).execAUTH();
                            ((FTPClient)((Object)this.client)).sslNegotiation();
                        }
                        break block6;
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new FTPExceptionMappingService().map(e);
                }
            }
        }
        return false;
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        block10: {
            try {
                if (((FTPClient)((Object)this.client)).login(this.host.getCredentials().getUsername(), this.host.getCredentials().getPassword())) {
                    if (this.host.getProtocol().isSecure()) {
                        ((FTPClient)((Object)this.client)).execPBSZ(0L);
                        ((FTPClient)((Object)this.client)).execPROT(this.preferences.getProperty("ftp.tls.datachannel"));
                    }
                    if (StandardCharsets.UTF_8.name().equals(this.host.getEncoding()) && ((FTPClient)((Object)this.client)).hasFeature("UTF8") && !FTPReply.isPositiveCompletion((int)((FTPClient)((Object)this.client)).sendCommand("OPTS UTF8 ON"))) {
                        log.warn((Object)String.format("Failed to negotiate UTF-8 charset %s", ((FTPClient)((Object)this.client)).getReplyString()));
                    }
                    TimeZone zone = this.host.getTimezone();
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Reset parser to timezone %s", zone));
                    }
                    String system = "";
                    try {
                        system = ((FTPClient)((Object)this.client)).getSystemType();
                        if (system.toUpperCase(Locale.ROOT).contains("WINDOWS")) {
                            this.casesensitivity = Protocol.Case.insensitive;
                        }
                    }
                    catch (IOException e) {
                        log.warn((Object)String.format("SYST command failed %s", e.getMessage()));
                    }
                    this.listService = new FTPListService(this, system, zone);
                    this.timestamp = ((FTPClient)((Object)this.client)).hasFeature(FTPCmd.MFMT.getCommand()) ? new FTPMFMTTimestampFeature(this) : new FTPUTIMETimestampFeature(this);
                    this.permission = system.toUpperCase(Locale.ROOT).contains("WINDOWS") ? null : new FTPUnixPermissionFeature(this);
                    if (((FTPClient)((Object)this.client)).hasFeature("SITE", "SYMLINK")) {
                        this.symlink = new FTPSymlinkFeature(this);
                    }
                    break block10;
                }
                throw new FTPExceptionMappingService().map(new FTPException(((FTPClient)((Object)this.getClient())).getReplyCode(), ((FTPClient)((Object)this.getClient())).getReplyString()));
            }
            catch (IOException e) {
                throw new FTPExceptionMappingService().map(e);
            }
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)this.listService;
        }
        if (type == Directory.class) {
            return (T)new FTPDirectoryFeature(this);
        }
        if (type == Delete.class) {
            return (T)new FTPDeleteFeature(this);
        }
        if (type == Read.class) {
            return (T)new FTPReadFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new FTPWriteFeature(this));
        }
        if (type == Move.class) {
            return (T)new FTPMoveFeature(this);
        }
        if (type == UnixPermission.class) {
            return (T)this.permission;
        }
        if (type == Timestamp.class) {
            return (T)this.timestamp;
        }
        if (type == Symlink.class) {
            return (T)this.symlink;
        }
        if (type == Command.class) {
            return (T)new FTPCommandFeature(this);
        }
        if (type == DistributionConfiguration.class) {
            return (T)new CustomOriginCloudFrontDistributionConfiguration(this.host);
        }
        if (type == Home.class) {
            return (T)((Object)new FTPWorkdirService(this));
        }
        if (type == Touch.class) {
            return (T)((Object)new FTPTouchFeature(this));
        }
        if (type == Copy.class) {
            return (T)new DefaultCopyFeature((Session)this);
        }
        return (T)super._getFeature(type);
    }
}

