/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;
import java.util.Objects;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveItemIterator
implements Iterator<OneDriveItem.Metadata> {
    private final OneDriveAPI api;
    private final JsonObjectIterator jsonObjectIterator;

    public OneDriveItemIterator(OneDriveAPI api, URL url) {
        this.api = Objects.requireNonNull(api);
        this.jsonObjectIterator = new JsonObjectIterator(api, url){

            @Override
            protected void onResponse(JsonObject response) {
                OneDriveItemIterator.this.onResponse(response);
            }
        };
    }

    @Override
    public boolean hasNext() throws OneDriveRuntimeException {
        return this.jsonObjectIterator.hasNext();
    }

    @Override
    public OneDriveItem.Metadata next() throws OneDriveRuntimeException {
        return OneDriveItem.parseJson(this.api, this.jsonObjectIterator.next());
    }

    protected void onResponse(JsonObject response) {
    }
}

