/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.util.Iterator;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.resources.GroupItem;

public class GroupDrivesIterator
implements Iterator<OneDriveDrive.Metadata> {
    private static final URLTemplate GROUP_DRIVELIST_URL = new URLTemplate("/groups/%s/drives");
    private final OneDriveAPI api;
    private final JsonObjectIterator jsonObjectIterator;

    public GroupDrivesIterator(OneDriveAPI api, GroupItem group) {
        this.api = api;
        this.jsonObjectIterator = new JsonObjectIterator(api, GROUP_DRIVELIST_URL.build(api.getBaseURL(), group.getId()));
    }

    @Override
    public boolean hasNext() throws OneDriveRuntimeException {
        return this.jsonObjectIterator.hasNext();
    }

    @Override
    public OneDriveDrive.Metadata next() {
        OneDriveDrive drive;
        JsonObject nextObject = this.jsonObjectIterator.next();
        String id = nextObject.get("id").asString();
        OneDriveDrive oneDriveDrive = drive = new OneDriveDrive(this.api, id);
        oneDriveDrive.getClass();
        return oneDriveDrive.new OneDriveDrive.Metadata(nextObject);
    }
}

