/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import org.irods.jargon.core.connection.AbstractConnection;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.JargonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IRODSBasicTCPConnection
extends AbstractConnection {
    static final Logger log = LoggerFactory.getLogger(IRODSBasicTCPConnection.class);

    IRODSBasicTCPConnection(IRODSAccount irodsAccount, PipelineConfiguration pipelineConfiguration, IRODSProtocolManager irodsProtocolManager, IRODSSession irodsSession) throws JargonException {
        super(irodsAccount, pipelineConfiguration, irodsProtocolManager, irodsSession);
    }

    IRODSBasicTCPConnection(IRODSAccount irodsAccount, PipelineConfiguration pipelineConfiguration, IRODSProtocolManager irodsProtocolManager, Socket socket, IRODSSession irodsSession) throws JargonException {
        super(irodsAccount, pipelineConfiguration, irodsProtocolManager, socket, irodsSession);
        this.setUpSocketAndStreamsAfterConnection(irodsAccount);
        if (socket instanceof SSLSocket) {
            this.setEncryptionType(AbstractConnection.EncryptionType.SSL_WRAPPED);
        }
        log.debug("socket opened successfully");
    }

    @Override
    protected void connect(IRODSAccount irodsAccount) throws JargonException {
        log.debug("connect()");
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (this.connected) {
            log.warn("doing connect when already connected!, will bypass connect and proceed");
            return;
        }
        int attemptCount = 3;
        for (int i = 0; i < attemptCount; ++i) {
            log.debug("connecting socket to agent");
            try {
                log.debug("normal iRODS connection");
                this.connection = new Socket();
                this.connection.setSoTimeout(this.getPipelineConfiguration().getIrodsSocketTimeout() * 1000);
                if (this.getPipelineConfiguration().getPrimaryTcpSendWindowSize() > 0) {
                    this.connection.setSendBufferSize(this.getPipelineConfiguration().getPrimaryTcpSendWindowSize() * 1024);
                }
                if (this.getPipelineConfiguration().getPrimaryTcpReceiveWindowSize() > 0) {
                    this.connection.setReceiveBufferSize(this.getPipelineConfiguration().getPrimaryTcpReceiveWindowSize() * 1024);
                }
                this.connection.setPerformancePreferences(this.getPipelineConfiguration().getPrimaryTcpPerformancePrefsConnectionTime(), this.getPipelineConfiguration().getPrimaryTcpPerformancePrefsLatency(), this.getPipelineConfiguration().getPrimaryTcpPerformancePrefsBandwidth());
                InetSocketAddress address = new InetSocketAddress(irodsAccount.getHost(), irodsAccount.getPort());
                this.connection.setKeepAlive(this.getPipelineConfiguration().isPrimaryTcpKeepAlive());
                this.connection.setReuseAddress(true);
                this.connection.setTcpNoDelay(false);
                this.connection.connect(address);
                log.debug("connection to socket made...");
                break;
            }
            catch (UnknownHostException e) {
                log.error("exception opening socket to:" + irodsAccount.getHost() + " port:" + irodsAccount.getPort(), (Throwable)e);
                throw new JargonException(e);
            }
            catch (IOException ioe) {
                if (i < attemptCount - 1) {
                    log.error("IOExeption, sleep and attempt a reconnect", (Throwable)ioe);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                log.error("io exception opening socket to:" + irodsAccount.getHost() + " port:" + irodsAccount.getPort(), (Throwable)ioe);
                throw new JargonException(ioe);
            }
        }
        this.setUpSocketAndStreamsAfterConnection(irodsAccount);
        this.connected = true;
        log.debug("socket opened successfully");
    }

    void setUpSocketAndStreamsAfterConnection(IRODSAccount irodsAccount) throws JargonException {
        try {
            int socketTimeout = this.pipelineConfiguration.getIrodsSocketTimeout();
            if (socketTimeout > 0) {
                log.debug("setting a connection timeout of:{} seconds", (Object)socketTimeout);
                this.connection.setSoTimeout(socketTimeout * 1000);
            }
            if (this.pipelineConfiguration.getInternalInputStreamBufferSize() <= -1) {
                log.debug("no buffer on input stream");
                this.irodsInputStream = this.connection.getInputStream();
            } else if (this.pipelineConfiguration.getInternalInputStreamBufferSize() == 0) {
                log.debug("default buffer on input stream");
                this.irodsInputStream = new BufferedInputStream(this.connection.getInputStream());
            } else {
                log.debug("buffer of size:{} on input stream", (Object)this.pipelineConfiguration.getInternalInputStreamBufferSize());
                this.irodsInputStream = new BufferedInputStream(this.connection.getInputStream(), this.pipelineConfiguration.getInternalInputStreamBufferSize());
            }
            if (this.pipelineConfiguration.getInternalOutputStreamBufferSize() <= -1) {
                log.debug("no buffer on output stream");
                this.irodsOutputStream = this.connection.getOutputStream();
            } else if (this.pipelineConfiguration.getInternalOutputStreamBufferSize() == 0) {
                log.debug("default buffer on input stream");
                this.irodsOutputStream = new BufferedOutputStream(this.connection.getOutputStream());
            } else {
                log.debug("buffer of size:{} on output stream", (Object)this.pipelineConfiguration.getInternalOutputStreamBufferSize());
                this.irodsOutputStream = new BufferedOutputStream(this.connection.getOutputStream(), this.pipelineConfiguration.getInternalOutputStreamBufferSize());
            }
        }
        catch (UnknownHostException e) {
            log.error("exception opening socket to:" + irodsAccount.getHost() + " port:" + irodsAccount.getPort(), (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException ioe) {
            log.error("io exception opening socket to:" + irodsAccount.getHost() + " port:" + irodsAccount.getPort(), (Throwable)ioe);
            throw new JargonException(ioe);
        }
    }

    void closeDownSocketAndEatAnyExceptions() {
        if (this.isConnected()) {
            log.debug("is connected for : {}", (Object)this.toString());
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connected = false;
            log.debug("now disconnected");
        }
    }

    @Override
    public void shutdown() throws JargonException {
        log.debug("shutting down connection: {}", (Object)this.connected);
        this.closeDownSocketAndEatAnyExceptions();
    }

    @Override
    public void obliterateConnectionAndDiscardErrors() {
        this.closeDownSocketAndEatAnyExceptions();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IRODSBasicTCPConnection []");
        return builder.toString();
    }
}

