/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveredServerPropertiesCache {
    private ConcurrentHashMap<String, ConcurrentHashMap<String, String>> discoveredServerPropertiesCache = new ConcurrentHashMap(8, 0.9f, 1);
    private ConcurrentHashMap<String, IRODSServerProperties> cacheOfIRODSServerProperties = new ConcurrentHashMap(8, 0.9f, 1);
    public static final Logger log = LoggerFactory.getLogger(DiscoveredServerPropertiesCache.class);
    public static final String JARGON_SPECIFIC_QUERIES_SUPPORTED = "jargonSpecificQueriesSupported";
    public static final String STRICT_ACLS = "strictACLs";
    public static final String EIRODS = "eirods";
    public static final String RULE_BASE = "loadedRules";
    public static final String CHECKSUM_TYPE = "checksumType";
    public static final String IS_TRUE = "true";
    public static final String IS_FALSE = "false";

    public IRODSServerProperties retrieveIRODSServerProperties(String host, String zoneName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        log.info("now retriving server properties from cache with zone:{}", (Object)myZone);
        return this.getIRODSServerPropertiesForHostAndZone(host, myZone);
    }

    private IRODSServerProperties getIRODSServerPropertiesForHostAndZone(String host, String zoneName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        String cacheKey = this.buildHostPlusZone(host, myZone);
        return this.cacheOfIRODSServerProperties.get(cacheKey);
    }

    public String retrieveValue(String host, String zoneName, String propertyName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("null or empty property name");
        }
        Map<String, String> zoneCache = this.getCacheForHostAndZone(host, myZone);
        if (zoneCache == null) {
            return null;
        }
        return zoneCache.get(propertyName);
    }

    public void deleteCachedIRODSServerProperties(String host, String zoneName, String propertyName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        String cacheKey = this.buildHostPlusZone(host, myZone);
        this.cacheOfIRODSServerProperties.remove(cacheKey);
    }

    public void deleteCachedProperty(String host, String zoneName, String propertyName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("null or empty property name");
        }
        Map<String, String> zoneCache = this.getCacheForHostAndZone(host, myZone);
        if (zoneCache != null) {
            zoneCache.remove(propertyName);
        }
    }

    public void deleteCache(String host, String zoneName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        String cacheKey = this.buildHostPlusZone(host, myZone);
        this.discoveredServerPropertiesCache.remove(cacheKey);
    }

    public void cacheIRODSServerProperties(String host, String zoneName, IRODSServerProperties irodsServerProperties) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        if (irodsServerProperties == null) {
            throw new IllegalArgumentException("null irodsServerProperties");
        }
        String cacheKey = this.buildHostPlusZone(host, myZone);
        this.cacheOfIRODSServerProperties.put(cacheKey, irodsServerProperties);
    }

    public void cacheAProperty(String host, String zoneName, String propertyName, String value) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        if (propertyName == null || propertyName.isEmpty()) {
            throw new IllegalArgumentException("null or empty property name");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        this.getCacheForHostAndZoneAndAddIfNotThere(host, myZone).put(propertyName, value);
    }

    private Map<String, String> getCacheForHostAndZoneAndAddIfNotThere(String host, String zoneName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        String cacheKey = this.buildHostPlusZone(host, myZone);
        this.discoveredServerPropertiesCache.putIfAbsent(cacheKey, new ConcurrentHashMap(8, 0.9f, 1));
        return this.discoveredServerPropertiesCache.get(cacheKey);
    }

    private Map<String, String> getCacheForHostAndZone(String host, String zoneName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        String cacheKey = this.buildHostPlusZone(host, myZone);
        return this.discoveredServerPropertiesCache.get(cacheKey);
    }

    private String buildHostPlusZone(String host, String zoneName) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("null or empty host");
        }
        String myZone = zoneName;
        if (zoneName == null) {
            myZone = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(host.trim());
        sb.append(myZone);
        return sb.toString();
    }
}

