/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.AuthMechanism;
import org.irods.jargon.core.connection.AuthScheme;
import org.irods.jargon.core.connection.AuthenticationFactory;
import org.irods.jargon.core.connection.GSIAuth;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.PAMAuth;
import org.irods.jargon.core.connection.StandardIRODSAuth;
import org.irods.jargon.core.connection.auth.AuthUnavailableException;
import org.irods.jargon.core.exception.JargonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFactoryImpl
implements AuthenticationFactory {
    private Logger log = LoggerFactory.getLogger(AuthenticationFactoryImpl.class);

    @Override
    public AuthMechanism instanceAuthMechanism(IRODSAccount irodsAccount) throws AuthUnavailableException, JargonException {
        AuthScheme authScheme;
        this.log.info("instanceAuthMechanism()");
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null or blank irodsAccount");
        }
        if (irodsAccount.getUserName().equals("anonymous")) {
            this.log.info("account is anonymous, use default auth scheme");
            authScheme = AuthScheme.STANDARD;
        } else {
            authScheme = irodsAccount.getAuthenticationScheme();
        }
        this.log.info("authScheme:{}", (Object)authScheme);
        if (authScheme.equals((Object)AuthScheme.STANDARD)) {
            this.log.info("using standard auth");
            return new StandardIRODSAuth();
        }
        if (authScheme.equals((Object)AuthScheme.PAM)) {
            this.log.info("using PAM auth");
            return new PAMAuth();
        }
        if (authScheme.equals((Object)AuthScheme.GSI)) {
            this.log.info("using standard auth");
            return new GSIAuth();
        }
        throw new AuthUnavailableException("auth method not avaialble for:" + (Object)((Object)authScheme));
    }
}

