/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.ClosedChannelException;
import org.irods.jargon.core.connection.AbstractConnection;
import org.irods.jargon.core.connection.ConnectionProgressStatusListener;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSErrorScanner;
import org.irods.jargon.core.connection.IRODSProtocolManager;
import org.irods.jargon.core.connection.IRODSServerProperties;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.connection.StartupResponseData;
import org.irods.jargon.core.connection.auth.AuthResponse;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.IRodsPI;
import org.irods.jargon.core.packinstr.Tag;
import org.irods.jargon.core.protovalues.ErrorEnum;
import org.irods.jargon.core.protovalues.RequestTypes;
import org.irods.jargon.core.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIRODSMidLevelProtocol {
    private AbstractConnection irodsConnection;
    private AbstractConnection irodsConnectionNonEncryptedRef = null;
    private IRODSProtocolManager irodsProtocolManager;
    private IRODSServerProperties irodsServerProperties;
    private IRODSSession irodsSession = null;
    private StartupResponseData startupResponseData;
    private boolean forceSslFlush = false;
    public static final int EIRODS_MIN = 301;
    public static final int EIRODS_MAX = 301;
    private Logger log = LoggerFactory.getLogger(AbstractIRODSMidLevelProtocol.class);
    private AuthResponse authResponse = null;
    private IRODSAccount irodsAccount;

    protected AbstractIRODSMidLevelProtocol(AbstractConnection irodsConnection, IRODSProtocolManager irodsProtocolManager) {
        if (irodsConnection == null) {
            throw new IllegalArgumentException("null irodsConnection");
        }
        if (irodsProtocolManager == null) {
            throw new IllegalArgumentException("null irodsProtocolManager");
        }
        this.irodsConnection = irodsConnection;
        this.irodsProtocolManager = irodsProtocolManager;
        this.irodsSession = irodsConnection.getIrodsSession();
    }

    synchronized boolean isForceSslFlush() {
        return this.forceSslFlush;
    }

    synchronized void setForceSslFlush(boolean forceSslFlush) {
        this.forceSslFlush = forceSslFlush;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractIRODSMidLevelProtocol [");
        if (this.irodsConnection != null) {
            builder.append("irodsConnection=");
            builder.append(this.irodsConnection);
            builder.append(", ");
        }
        if (this.irodsProtocolManager != null) {
            builder.append("irodsProtocolManager=");
            builder.append(this.irodsProtocolManager);
            builder.append(", ");
        }
        if (this.irodsServerProperties != null) {
            builder.append("irodsServerProperties=");
            builder.append(this.irodsServerProperties);
            builder.append(", ");
        }
        if (this.irodsSession != null) {
            builder.append("irodsSession=");
            builder.append(this.irodsSession);
            builder.append(", ");
        }
        if (this.startupResponseData != null) {
            builder.append("startupResponseData=");
            builder.append(this.startupResponseData);
            builder.append(", ");
        }
        builder.append("forceSslFlush=");
        builder.append(this.forceSslFlush);
        builder.append(", ");
        if (this.log != null) {
            builder.append("log=");
            builder.append(this.log);
            builder.append(", ");
        }
        if (this.authResponse != null) {
            builder.append("authResponse=");
            builder.append(this.authResponse);
            builder.append(", ");
        }
        if (this.irodsAccount != null) {
            builder.append("irodsAccount=");
            builder.append(this.irodsAccount);
        }
        builder.append("]");
        return builder.toString();
    }

    public synchronized Tag irodsFunction(String type, String message, int intInfo) throws JargonException {
        return this.irodsFunction(type, message, null, 0, 0, null, 0, 0, intInfo);
    }

    public abstract Tag irodsFunction(String var1, String var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws JargonException;

    public synchronized long irodsFunctionForStreamingToIRODSInFrames(IRodsPI irodsPI, int byteStreamLength, InputStream byteStream, ConnectionProgressStatusListener connectionProgressStatusListener) throws JargonException {
        if (irodsPI == null) {
            throw new IllegalArgumentException("null irodsPI");
        }
        if (byteStream == null) {
            throw new IllegalArgumentException("null byteStream");
        }
        this.log.debug("calling irodsFunctionForStreamingToIRODSInFrames");
        this.log.debug("calling irods function with:{}", (Object)irodsPI);
        this.log.debug("api number is:{}", (Object)irodsPI.getApiNumber());
        long dataSent = 0L;
        try {
            int length = 0;
            String message = irodsPI.getParsedTags();
            if (message != null) {
                length = message.getBytes(this.irodsConnection.getPipelineConfiguration().getDefaultEncoding()).length;
            }
            this.sendHeader("RODS_API_REQ", length, 0, byteStreamLength, irodsPI.getApiNumber());
            this.irodsConnection.send(message);
            if (byteStreamLength > 0) {
                dataSent += this.irodsConnection.send(byteStream, (long)byteStreamLength, connectionProgressStatusListener);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("ioexception", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        this.log.debug("reading message from frame send...");
        this.log.debug("read commented out");
        this.readMessage();
        this.log.debug("message read");
        return dataSent;
    }

    public StartupResponseData getStartupResponseData() {
        return this.startupResponseData;
    }

    public void setStartupResponseData(StartupResponseData startupResponseData) {
        this.startupResponseData = startupResponseData;
    }

    public synchronized Tag irodsFunctionIncludingAllDataInStream(IRodsPI irodsPI, long byteStreamLength, InputStream byteStream, ConnectionProgressStatusListener connectionProgressStatusListener) throws JargonException {
        if (irodsPI == null) {
            throw new IllegalArgumentException("null irodsPI");
        }
        if (byteStream == null) {
            throw new IllegalArgumentException("null byteStream");
        }
        this.log.debug("calling irods function with streams");
        this.log.debug("calling irods function with:{}", (Object)irodsPI);
        this.log.debug("api number is:{}", (Object)irodsPI.getApiNumber());
        try {
            int length = 0;
            String message = irodsPI.getParsedTags();
            if (message != null) {
                length = message.getBytes(this.getEncoding()).length;
            }
            this.log.debug("message:{}", (Object)message);
            this.sendHeader("RODS_API_REQ", length, 0, byteStreamLength, irodsPI.getApiNumber());
            this.irodsConnection.send(message);
            if (byteStreamLength > 0L) {
                this.irodsConnection.send(byteStream, byteStreamLength, connectionProgressStatusListener);
                byteStream.close();
            } else {
                this.log.debug("no byte stream data, so flush output");
                this.irodsConnection.flush();
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("ioexception", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        this.log.debug("data sent, getting response");
        return this.readMessage();
    }

    public synchronized Tag irodsFunction(IRodsPI irodsPI, byte[] errorStream, int errorOffset, int errorLength, byte[] bytes, int byteOffset, int byteStreamLength) throws JargonException {
        if (irodsPI == null) {
            String err = "null irodsPI";
            this.log.error(err);
            throw new IllegalArgumentException(err);
        }
        String out = irodsPI.getParsedTags();
        if (out == null || out.length() == 0) {
            String err = "null or missing message returned from parse";
            this.log.error(err);
            throw new IllegalArgumentException(err);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(out);
        }
        try {
            this.sendHeader("RODS_API_REQ", out.getBytes(this.getEncoding()).length, errorLength, byteStreamLength, irodsPI.getApiNumber());
            this.irodsConnection.send(out);
            if (byteStreamLength > 0) {
                this.irodsConnection.send(bytes, byteOffset, byteStreamLength);
            }
            this.irodsConnection.flush();
            return this.readMessage();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception sending irods command", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
    }

    public synchronized int read(byte[] value, int offset, int length) throws JargonException {
        if (value == null || value.length == 0) {
            throw new JargonException("null or empty value");
        }
        if (offset < 0 || offset > value.length) {
            throw new JargonException("offset out of range");
        }
        if (length <= 0 || length > value.length) {
            throw new JargonException("length out of range");
        }
        try {
            return this.irodsConnection.read(value, offset, length);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception sending irods command", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
    }

    public synchronized void read(OutputStream destination, long length) throws JargonException {
        this.read(destination, length, null);
    }

    public synchronized void read(OutputStream destination, long length, ConnectionProgressStatusListener intraFileStatusListener) throws JargonException {
        if (length <= 0L) {
            throw new JargonException("length out of range");
        }
        if (destination == null) {
            throw new JargonException("destination is null");
        }
        try {
            this.irodsConnection.read(destination, length, intraFileStatusListener);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("unsupported encoding", (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception sending irods command", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
    }

    public synchronized Tag irodsFunction(IRodsPI irodsPI) throws JargonException {
        if (irodsPI == null) {
            String err = "null irodsPI";
            this.log.error(err);
            throw new IllegalArgumentException(err);
        }
        return this.irodsFunction("RODS_API_REQ", irodsPI.getParsedTags(), irodsPI.getApiNumber());
    }

    public synchronized Tag irodsFunctionForNegotiation(IRodsPI irodsPI) throws JargonException {
        if (irodsPI == null) {
            String err = "null irodsPI";
            this.log.error(err);
            throw new IllegalArgumentException(err);
        }
        return this.irodsFunction("RODS_CS_NEG_T", irodsPI.getParsedTags(), irodsPI.getApiNumber());
    }

    public byte[] createHeader(String type, int messageLength, int errorLength, long byteStringLength, int intInfo) throws JargonException {
        return AbstractIRODSMidLevelProtocol.createHeaderBytesFromData(type, messageLength, errorLength, byteStringLength, intInfo, this.getEncoding());
    }

    public abstract void sendHeader(String var1, int var2, int var3, long var4, int var6) throws JargonException, IOException;

    public static byte[] createHeaderBytesFromData(String type, int messageLength, int errorLength, long byteStringLength, int intInfo, String encoding) throws JargonException {
        StringBuilder headerBuilder = new StringBuilder();
        headerBuilder.append("<MsgHeader_PI>");
        headerBuilder.append("<type>");
        headerBuilder.append(type);
        headerBuilder.append("</type>");
        headerBuilder.append("<msgLen>");
        headerBuilder.append(messageLength);
        headerBuilder.append("</msgLen>");
        headerBuilder.append("<errorLen>");
        headerBuilder.append(errorLength);
        headerBuilder.append("</errorLen>");
        headerBuilder.append("<bsLen>");
        headerBuilder.append(byteStringLength);
        headerBuilder.append("</bsLen>");
        headerBuilder.append("<intInfo>");
        headerBuilder.append(intInfo);
        headerBuilder.append("</intInfo>");
        headerBuilder.append("</MsgHeader_PI>");
        String header = headerBuilder.toString();
        try {
            byte[] temp = header.getBytes(encoding);
            return temp;
        }
        catch (UnsupportedEncodingException e) {
            throw new JargonException(e);
        }
    }

    public synchronized Tag readMessage() throws JargonException {
        return this.readMessage(true);
    }

    public synchronized Tag readMessage(boolean decode) throws JargonException {
        this.log.debug("reading message from irods");
        Tag header = this.readHeader();
        Tag message = null;
        int messageLength = header.getTags()[1].getIntValue();
        int errorLength = header.getTags()[2].getIntValue();
        int bytesLength = header.getTags()[3].getIntValue();
        int info = header.getTags()[4].getIntValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("message length:{}", (Object)messageLength);
            this.log.debug("error length:{}", (Object)errorLength);
            this.log.debug("bytesLength:{}", (Object)bytesLength);
            this.log.debug("info value:{}", (Object)info);
        }
        if (info < 0) {
            this.processMessageInfoLessThanZero(messageLength, errorLength, info);
            this.log.debug("returning null, no results");
            return null;
        }
        if (messageLength > 0) {
            String messageAsString;
            int idx;
            this.log.debug("message length greater than zero");
            message = this.readMessageBody(messageLength, decode);
            if (this.log.isDebugEnabled() && (idx = (messageAsString = message.parseTag()).indexOf("GenQueryOut")) == -1) {
                this.log.debug("message from IRODS read back:{}", (Object)messageAsString);
            }
        }
        if (errorLength != 0) {
            this.processMessageErrorNotEqualZero(errorLength);
        }
        if (bytesLength != 0 || info > 0) {
            this.log.debug("bytes length is not zero");
            if (message == null) {
                message = new Tag("MsgHeader_PI");
            }
            message.addTag(header);
        }
        return message;
    }

    public synchronized boolean isConnected() {
        return this.irodsConnection.isConnected();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void shutdown() throws JargonException {
        this.log.debug("shutting down, need to send disconnect to irods");
        if (this.isConnected()) {
            this.preDisconnectAction();
            this.log.debug("sending disconnect message");
            try {
                this.sendHeader(RequestTypes.RODS_DISCONNECT.getRequestType(), 0, 0, 0L, 0);
                this.irodsConnection.flush();
                this.log.debug("finally, shutdown is being called on the given connection");
                this.irodsConnection.shutdown();
                if (this.getIrodsConnectionNonEncryptedRef() == null) return;
                this.getIrodsConnectionNonEncryptedRef().shutdown();
                return;
            }
            catch (ClosedChannelException e) {
                this.log.error("closed channel", (Throwable)e);
                this.disconnectWithForce();
                throw new JargonException(e);
            }
            catch (InterruptedIOException e) {
                this.log.error("interrupted io", (Throwable)e);
                this.disconnectWithForce();
                throw new JargonException(e);
            }
            catch (IOException e) {
                this.log.error("io exception", (Throwable)e);
                this.disconnectWithForce();
                throw new JargonException(e);
            }
        } else {
            this.log.warn("disconnect called, but isConnected() is false, this is an unexpected condition that is logged and ignored");
        }
    }

    abstract void preDisconnectAction() throws JargonException;

    public synchronized void disconnect() throws JargonException {
        this.log.debug("closing connection");
        this.getIrodsSession().closeSession(this.getIrodsAccount());
    }

    public synchronized void disconnectWithForce() throws JargonException {
        if (this.getIrodsAccount() != null) {
            this.getIrodsSession().discardSessionForErrors(this.getIrodsAccount());
        }
        if (this.getIrodsConnection().isConnected()) {
            this.log.warn("partial connection, not authenticated, forcefully shut down the socket");
            this.getIrodsConnection().obliterateConnectionAndDiscardErrors();
        }
    }

    public synchronized IRODSServerProperties getIRODSServerProperties() {
        return this.irodsServerProperties;
    }

    public synchronized IRODSAccount getIrodsAccount() {
        return this.irodsAccount;
    }

    public synchronized void operationComplete(int status) throws JargonException {
        Tag message = new Tag("INT_PI", new Tag[]{new Tag("myInt", status)});
        this.irodsFunction("RODS_API_REQ", message.parseTag(), 626);
    }

    public synchronized void sendInNetworkOrder(int value) throws JargonException {
        try {
            this.irodsConnection.sendInNetworkOrder(value);
        }
        catch (IOException e) {
            this.disconnectWithForce();
            throw new JargonException(e);
        }
    }

    public synchronized IRODSSession getIrodsSession() {
        return this.irodsSession;
    }

    public synchronized void setIrodsSession(IRODSSession irodsSession) {
        if (irodsSession == null) {
            throw new IllegalArgumentException("null irodsSession");
        }
        this.irodsConnection.setIrodsSession(irodsSession);
        this.irodsSession = irodsSession;
    }

    public synchronized IRODSProtocolManager getIrodsProtocolManager() {
        return this.irodsProtocolManager;
    }

    public AbstractConnection getIrodsConnection() {
        return this.irodsConnection;
    }

    public synchronized void processClientStatusMessages(Tag reply) throws JargonException {
        boolean done = false;
        Tag ackResult = reply;
        while (!done) {
            if (ackResult.getLength() <= 0 || !ackResult.getName().equals("CollOprStat_PI")) continue;
            Tag fileCountTag = ackResult.getTag("filesCnt");
            int fileCount = Integer.parseInt((String)fileCountTag.getValue());
            if (fileCount < 10) {
                done = true;
                continue;
            }
            this.sendInNetworkOrder(99999997);
            ackResult = this.readMessage();
        }
    }

    public synchronized AuthResponse getAuthResponse() {
        return this.authResponse;
    }

    synchronized IRODSServerProperties getIrodsServerProperties() {
        return this.irodsServerProperties;
    }

    synchronized void setIrodsServerProperties(IRODSServerProperties irodsServerProperties) {
        this.irodsServerProperties = irodsServerProperties;
    }

    synchronized void setIrodsAccount(IRODSAccount irodsAccount) {
        this.irodsAccount = irodsAccount;
    }

    protected synchronized void setAuthResponse(AuthResponse authResponse) {
        this.authResponse = authResponse;
    }

    Tag readHeader() throws JargonException {
        int length = this.readHeaderLength();
        if (length < 0) {
            this.log.error("protocol error< header length is:" + length);
            throw new JargonException("Protocol error, read header and got header length less than zero");
        }
        if (length > 10000000) {
            this.irodsSession.discardSessionForErrors(this.irodsAccount);
            throw new JargonException("Server connection lost, due to error");
        }
        byte[] header = new byte[length];
        try {
            this.irodsConnection.read(header, 0, length);
        }
        catch (IOException e) {
            this.log.error("io exception", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        try {
            return Tag.readNextTag(header, this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unsupported encoding for:{}", (Object)this.getEncoding());
            throw new JargonException("Unsupported encoding for:" + this.getEncoding());
        }
    }

    int readHeaderLength() throws JargonException {
        byte[] headerInt = new byte[4];
        try {
            this.irodsConnection.read(headerInt, 0, 4);
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", (Throwable)e);
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        return Host.castToInt(headerInt);
    }

    Tag readMessageBody(int length, boolean decode) throws JargonException {
        byte[] body = new byte[length];
        try {
            this.irodsConnection.read(body, 0, length);
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        try {
            return Tag.readNextTag(body, decode, this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unsupported encoding for:{}", (Object)this.getEncoding());
            throw new JargonException("Unsupported encoding for:" + this.getEncoding());
        }
    }

    void processMessageErrorNotEqualZero(int errorLength) throws JargonException {
        Tag errorTag;
        this.log.debug("error length is not zero, process error");
        byte[] errorMessage = new byte[errorLength];
        try {
            this.irodsConnection.read(errorMessage, 0, errorLength);
        }
        catch (ClosedChannelException e) {
            this.log.error("closed channel", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (InterruptedIOException e) {
            this.log.error("interrupted io", (Throwable)e);
            e.printStackTrace();
            throw new JargonException(e);
        }
        catch (IOException e) {
            this.log.error("io exception", (Throwable)e);
            this.disconnectWithForce();
            throw new JargonException(e);
        }
        try {
            errorTag = Tag.readNextTag(errorMessage, this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("Unsupported encoding for:{}", (Object)this.getEncoding());
            throw new JargonException("Unsupported encoding for:" + this.getEncoding());
        }
        Tag errorPITag = errorTag.getTag("RErrMsg_PI");
        if (errorPITag == null) {
            throw new JargonException("errorPITag missing when processing an error in response from iRODS");
        }
        Tag status = errorPITag.getTag("status");
        if (status == null) {
            throw new JargonException("no status tag in error PI tag when processing error in response from iRODS");
        }
        int statusVal = status.getIntValue();
        if (statusVal == 0) {
            this.log.debug("error status of 0 indicates normal operation, ignored");
            return;
        }
        String errorText = errorTag.getTag("RErrMsg_PI").getTag("msg").getStringValue();
        this.log.error("IRODS error encountered:{}", (Object)errorText);
        this.log.error("status from error is:{}", (Object)statusVal);
        throw new JargonException("error returned from iRODS, status = " + statusVal + " message:" + errorText);
    }

    public synchronized void obliterateConnectionAndDiscardErrors() {
        this.log.warn("obliterateConnectionAndDiscardErrors() will forcefully close the connection");
        this.irodsConnection.obliterateConnectionAndDiscardErrors();
    }

    void processMessageInfoLessThanZero(int messageLength, int errorLength, int info) throws JargonException {
        this.log.debug("info is < 0");
        byte[] messageByte = new byte[messageLength];
        if (messageLength > 0) {
            this.log.debug("throwing away bytes");
            try {
                this.irodsConnection.read(new byte[messageLength], 0, messageLength);
                Tag.readNextTag(messageByte, this.getEncoding());
            }
            catch (ClosedChannelException e) {
                this.log.error("closed channel", (Throwable)e);
                throw new JargonException(e);
            }
            catch (InterruptedIOException e) {
                this.log.error("interrupted io", (Throwable)e);
                throw new JargonException(e);
            }
            catch (IOException e) {
                this.log.error("io exception", (Throwable)e);
                this.disconnectWithForce();
                throw new JargonException(e);
            }
        }
        String addlMessage = this.readAndLogErrorMessage(errorLength, info);
        if (info == ErrorEnum.CAT_SUCCESS_BUT_WITH_NO_INFO.getInt()) {
            this.log.debug("success but no info returned from irods");
        } else {
            IRODSErrorScanner.inspectAndThrowIfNeeded(info, addlMessage);
        }
    }

    private String readAndLogErrorMessage(int errorLength, int info) throws JargonException {
        String additionalMessage = "";
        if (errorLength != 0) {
            byte[] errorMessage = new byte[errorLength];
            try {
                this.irodsConnection.read(errorMessage, 0, errorLength);
            }
            catch (ClosedChannelException e) {
                this.log.error("closed channel", (Throwable)e);
                throw new JargonException(e);
            }
            catch (InterruptedIOException e) {
                this.log.error("interrupted io", (Throwable)e);
                throw new JargonException(e);
            }
            catch (IOException e) {
                this.log.error("io exception", (Throwable)e);
                this.disconnectWithForce();
                throw new JargonException(e);
            }
            try {
                Tag errorTag = Tag.readNextTag(errorMessage, this.getEncoding());
                if (errorTag != null) {
                    this.log.error("IRODS error occured " + errorTag.getTag("RErrMsg_PI").getTag("msg") + " : " + info);
                    additionalMessage = errorTag.getTag("RErrMsg_PI").getTag("msg").getStringValue();
                }
            }
            catch (UnsupportedEncodingException e) {
                this.log.error("Unsupported encoding for: {}", (Object)this.getEncoding());
                throw new JargonException("Unsupported encoding for: " + this.getEncoding());
            }
        }
        return additionalMessage;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.irodsConnection.getPipelineConfiguration();
    }

    public String getEncoding() {
        return this.irodsConnection.getPipelineConfiguration().getDefaultEncoding();
    }

    public void setIrodsProtocolManager(IRODSProtocolManager irodsProtocolManager) {
        this.irodsProtocolManager = irodsProtocolManager;
    }

    public long getConnectTimeInMillis() {
        return this.getIrodsConnection().getConnectTimeInMillis();
    }

    protected void setIrodsConnection(AbstractConnection irodsConnection) {
        this.irodsConnection = irodsConnection;
    }

    public abstract void irodsFunctionUnidirectional(String var1, byte[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws JargonException;

    abstract void closeOutSocketAndSetAsDisconnected() throws IOException;

    public AbstractConnection getIrodsConnectionNonEncryptedRef() {
        return this.irodsConnectionNonEncryptedRef;
    }

    public void setIrodsConnectionNonEncryptedRef(AbstractConnection irodsConnectionNonEncryptedRef) {
        this.irodsConnectionNonEncryptedRef = irodsConnectionNonEncryptedRef;
    }
}

