/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.toolbar;

import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.TransferController;
import ch.cyberduck.ui.cocoa.toolbar.AbstractToolbarFactory;
import ch.cyberduck.ui.cocoa.toolbar.ToolbarFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;

public class TransferToolbarFactory
extends AbstractToolbarFactory
implements ToolbarFactory {
    private final TransferController controller;
    public Preferences preferences = PreferencesFactory.get();
    private final Map<String, NSToolbarItem> toolbarItems = new HashMap<String, NSToolbarItem>();

    public TransferToolbarFactory(TransferController controller) {
        this.controller = controller;
    }

    @Override
    public NSToolbarItem create(String identifier) {
        if (!this.toolbarItems.containsKey(identifier)) {
            this.toolbarItems.put(identifier, AbstractToolbarFactory.CDToolbarItem.itemWithIdentifier(identifier));
        }
        NSToolbarItem item = this.toolbarItems.get(identifier);
        try {
            TransferToolbarItem type = TransferToolbarItem.valueOf(identifier);
            switch (type) {
                case search: {
                    item.setLabel(TransferToolbarItem.search.label());
                    item.setPaletteLabel(TransferToolbarItem.search.label());
                    item.setView((NSView)this.controller.getFilterField());
                    return item;
                }
                case bandwidth: {
                    item.setLabel(TransferToolbarItem.bandwidth.label());
                    item.setPaletteLabel(TransferToolbarItem.bandwidth.label());
                    item.setToolTip(TransferToolbarItem.bandwidth.tooltip());
                    NSMenuItem toolbarMenu = NSMenuItem.itemWithTitle((String)TransferToolbarItem.bandwidth.label(), (Selector)TransferToolbarItem.bandwidth.action(), (String)"");
                    NSMenu bandwidthMenu = NSMenu.menu();
                    bandwidthMenu.setAutoenablesItems(true);
                    bandwidthMenu.setDelegate(this.controller.getBandwidthMenuDelegate().id());
                    NSMenuItem unlimited = bandwidthMenu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Unlimited Bandwidth", (String)"Transfer"), TransferToolbarItem.bandwidth.action(), "");
                    unlimited.setImage(TransferToolbarItem.bandwidth.image());
                    unlimited.setRepresentedObject(String.valueOf(-1));
                    bandwidthMenu.addItem(NSMenuItem.separatorItem());
                    StringTokenizer options = new StringTokenizer(this.preferences.getProperty("queue.bandwidth.options"), ",");
                    while (options.hasMoreTokens()) {
                        String bytes = options.nextToken();
                        NSMenuItem m = bandwidthMenu.addItemWithTitle_action_keyEquivalent(SizeFormatterFactory.get().format((long)Integer.parseInt(bytes)) + "/s", TransferToolbarItem.bandwidth.action(), "");
                        NSImage image = (NSImage)IconCacheFactory.get().iconNamed("turtle.tiff", Integer.valueOf(16));
                        image.setTemplate(true);
                        m.setImage(image);
                        m.setRepresentedObject(bytes);
                    }
                    toolbarMenu.setSubmenu(bandwidthMenu);
                    item.setMenuFormRepresentation(toolbarMenu);
                    NSPopUpButton button = NSPopUpButton.buttonWithFrame((NSRect)new NSRect(52.0, 26.0));
                    button.setImage(TransferToolbarItem.bandwidth.image());
                    button.setMenu(bandwidthMenu);
                    button.setTarget(this.controller.id());
                    button.setAction(TransferToolbarItem.bandwidth.action());
                    item.setView((NSView)button);
                    item.setMaxSize(new NSSize(button.frame().size.width.doubleValue(), button.frame().size.height.doubleValue()));
                    return item;
                }
                case connections: {
                    item.setLabel(TransferToolbarItem.connections.label());
                    item.setPaletteLabel(TransferToolbarItem.connections.label());
                    item.setToolTip(TransferToolbarItem.connections.tooltip());
                    NSMenuItem toolbarMenu = NSMenuItem.itemWithTitle((String)TransferToolbarItem.connections.label(), (Selector)TransferToolbarItem.connections.action(), (String)"");
                    NSMenu connectionsMenu = NSMenu.menu();
                    connectionsMenu.setAutoenablesItems(true);
                    StringTokenizer options = new StringTokenizer(this.preferences.getProperty("queue.connections.options"), ",");
                    while (options.hasMoreTokens()) {
                        String n = options.nextToken();
                        NSMenuItem m = connectionsMenu.addItemWithTitle_action_keyEquivalent(MessageFormat.format(LocaleFactory.localizedString((String)"{0} Connections", (String)"Transfer"), n), TransferToolbarItem.connections.action(), "");
                        m.setImage(TransferToolbarItem.connections.image());
                        m.setRepresentedObject(n);
                    }
                    toolbarMenu.setSubmenu(connectionsMenu);
                    item.setMenuFormRepresentation(toolbarMenu);
                    NSPopUpButton button = NSPopUpButton.buttonWithFrame((NSRect)new NSRect(52.0, 26.0));
                    button.setImage(TransferToolbarItem.connections.image());
                    button.setMenu(connectionsMenu);
                    button.setTarget(this.controller.id());
                    button.setAction(TransferToolbarItem.connections.action());
                    button.selectItemAtIndex(button.indexOfItemWithRepresentedObject(this.preferences.getProperty("queue.connections.limit")));
                    item.setView((NSView)button);
                    item.setMaxSize(new NSSize(button.frame().size.width.doubleValue(), button.frame().size.height.doubleValue()));
                    return item;
                }
            }
            item.setLabel(type.label());
            item.setPaletteLabel(type.label());
            item.setToolTip(type.tooltip());
            item.setImage(type.image());
            item.setTarget(this.controller.id());
            item.setAction(type.action());
            NSButton button = NSButton.buttonWithFrame((NSRect)new NSRect(0.0, 0.0));
            button.setBezelStyle(11);
            button.setImage(type.image());
            button.sizeToFit();
            button.setTarget(this.controller.id());
            button.setAction(type.action());
            item.setView((NSView)button);
            return item;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public NSArray getDefault() {
        return NSArray.arrayWithObjects((String[])new String[]{TransferToolbarItem.resume.name(), TransferToolbarItem.stop.name(), TransferToolbarItem.reload.name(), TransferToolbarItem.remove.name(), TransferToolbarItem.reveal.name(), "NSToolbarFlexibleSpaceItem", TransferToolbarItem.bandwidth.name(), TransferToolbarItem.connections.name(), TransferToolbarItem.search.name()});
    }

    @Override
    public NSArray getAllowed() {
        return NSArray.arrayWithObjects((String[])new String[]{TransferToolbarItem.resume.name(), TransferToolbarItem.reload.name(), TransferToolbarItem.stop.name(), TransferToolbarItem.remove.name(), TransferToolbarItem.cleanup.name(), TransferToolbarItem.reveal.name(), TransferToolbarItem.open.name(), TransferToolbarItem.trash.name(), TransferToolbarItem.search.name(), TransferToolbarItem.log.name(), TransferToolbarItem.bandwidth.name(), TransferToolbarItem.connections.name(), "NSToolbarCustomizeToolbarItem", "NSToolbarSpaceItem", "NSToolbarSeparatorItem", "NSToolbarFlexibleSpaceItem"});
    }

    public static enum TransferToolbarItem {
        resume{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Resume", (String)"Transfer");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"resumeButtonClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("transferresume.pdf");
            }
        }
        ,
        reload{

            @Override
            public Selector action() {
                return Foundation.selector((String)"reloadButtonClicked:");
            }
        }
        ,
        stop{

            @Override
            public Selector action() {
                return Foundation.selector((String)"stopButtonClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("transferstop.pdf");
            }
        }
        ,
        remove{

            @Override
            public Selector action() {
                return Foundation.selector((String)"deleteButtonClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("transferremove.pdf");
            }
        }
        ,
        cleanup{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Clean Up");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"clearButtonClicked:");
            }
        }
        ,
        open{

            @Override
            public Selector action() {
                return Foundation.selector((String)"openButtonClicked:");
            }
        }
        ,
        reveal{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Show in Finder");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"revealButtonClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("showinfinder.pdf");
            }
        }
        ,
        trash{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()), (String)"Transfer");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"trashButtonClicked:");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Move to Trash");
            }
        }
        ,
        log{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()), (String)"Transfer");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"toggleLogDrawer:");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Toggle Log Drawer");
            }
        }
        ,
        bandwidth{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()), (String)"Preferences");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"bandwidthPopupChanged:");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Bandwidth", (String)"Preferences");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("bandwidth.tiff", Integer.valueOf(16));
            }
        }
        ,
        connections{

            @Override
            public Selector action() {
                return Foundation.selector((String)"connectionsPopupChanged:");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Connections");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("connection.tiff", Integer.valueOf(16));
            }
        }
        ,
        search{

            @Override
            public Selector action() {
                return null;
            }
        };


        public String label() {
            return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()));
        }

        public String tooltip() {
            return null;
        }

        public abstract Selector action();

        public NSImage image() {
            return (NSImage)IconCacheFactory.get().iconNamed(String.format("%s.pdf", this.name()));
        }
    }
}

