/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.toolbar;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSComboBox;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSSegmentedControl;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.DefaultCharsetProvider;
import ch.cyberduck.core.FolderBookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.ApplicationFinder;
import ch.cyberduck.core.local.ApplicationFinderFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.toolbar.AbstractToolbarFactory;
import ch.cyberduck.ui.cocoa.toolbar.ToolbarFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSRect;
import org.rococoa.cocoa.foundation.NSSize;

public class BrowserToolbarFactory
extends AbstractToolbarFactory
implements ToolbarFactory {
    private final ApplicationFinder applicationFinder = ApplicationFinderFactory.get();
    private final ProxyController quickConnectPopupModel = new QuickConnectModel();
    private final AbstractHostCollection bookmarks = FolderBookmarkCollection.favoritesCollection();
    private final Preferences preferences = PreferencesFactory.get();
    private final BrowserController controller;
    private final Map<String, NSToolbarItem> toolbarItems = new HashMap<String, NSToolbarItem>();

    public BrowserToolbarFactory(BrowserController controller) {
        this.controller = controller;
    }

    @Override
    public NSToolbarItem create(String identifier) {
        if (!this.toolbarItems.containsKey(identifier)) {
            this.toolbarItems.put(identifier, AbstractToolbarFactory.CDToolbarItem.itemWithIdentifier(identifier));
        }
        NSToolbarItem item = this.toolbarItems.get(identifier);
        try {
            BrowserToolbarItem type = BrowserToolbarItem.valueOf(identifier);
            switch (type) {
                case browserview: {
                    item.setLabel(BrowserToolbarItem.browserview.label());
                    item.setPaletteLabel(BrowserToolbarItem.browserview.label());
                    item.setToolTip(BrowserToolbarItem.browserview.tooltip());
                    item.setTarget(this.controller.id());
                    item.setAction(BrowserToolbarItem.browserview.action());
                    NSSegmentedControl button = NSSegmentedControl.segmentedControl();
                    button.setSegmentCount(2);
                    button.setImage_forSegment(BrowserController.BrowserSwitchSegement.list.image(), BrowserController.BrowserSwitchSegement.list.ordinal());
                    button.setImage_forSegment(BrowserController.BrowserSwitchSegement.outline.image(), BrowserController.BrowserSwitchSegement.outline.ordinal());
                    button.sizeToFit();
                    button.setTarget(this.controller.id());
                    button.setAction(BrowserToolbarItem.browserview.action());
                    button.setSelectedSegment(this.preferences.getInteger("browser.view"));
                    NSMenu menu = NSMenu.menu();
                    NSMenuItem toolbarMenu = NSMenuItem.itemWithTitle((String)BrowserToolbarItem.browserview.label(), null, (String)"");
                    menu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"List"), Foundation.selector((String)"browserSwitchMenuClicked:"), "");
                    menu.itemWithTitle(LocaleFactory.localizedString((String)"List")).setTag(BrowserController.BrowserSwitchSegement.list.ordinal());
                    menu.addItemWithTitle_action_keyEquivalent(LocaleFactory.localizedString((String)"Outline"), Foundation.selector((String)"browserSwitchMenuClicked:"), "");
                    menu.itemWithTitle(LocaleFactory.localizedString((String)"Outline")).setTag(BrowserController.BrowserSwitchSegement.outline.ordinal());
                    toolbarMenu.setSubmenu(menu);
                    item.setView((NSView)button);
                    item.setMenuFormRepresentation(toolbarMenu);
                    return item;
                }
                case tools: {
                    item.setLabel(BrowserToolbarItem.tools.label());
                    item.setPaletteLabel(BrowserToolbarItem.tools.label());
                    item.setToolTip(BrowserToolbarItem.tools.tooltip());
                    item.setTarget(this.controller.id());
                    item.setAction(BrowserToolbarItem.tools.action());
                    NSMenu menu = this.controller.getSelectedBrowserView().menu();
                    NSMenuItem toolbarMenu = NSMenuItem.itemWithTitle((String)BrowserToolbarItem.tools.label(), null, (String)"");
                    toolbarMenu.setSubmenu(menu);
                    NSSegmentedControl button = NSSegmentedControl.segmentedControl();
                    button.setSegmentCount(1);
                    button.setImage_forSegment(BrowserToolbarItem.tools.image(), 0);
                    button.sizeToFit();
                    button.setMenu_forSegment(menu, 0);
                    button.setTarget(this.controller.id());
                    button.setAction(BrowserToolbarItem.tools.action());
                    item.setView((NSView)button);
                    item.setMenuFormRepresentation(toolbarMenu);
                    return item;
                }
                case quickconnect: {
                    item.setLabel(BrowserToolbarItem.quickconnect.label());
                    item.setPaletteLabel(BrowserToolbarItem.quickconnect.label());
                    item.setToolTip(BrowserToolbarItem.quickconnect.tooltip());
                    NSComboBox button = NSComboBox.textfieldWithFrame((NSRect)new NSRect(170.0, 26.0));
                    button.setTarget(this.controller.id());
                    button.setAction(BrowserToolbarItem.quickconnect.action());
                    button.setCompletes(true);
                    button.cell().setSendsActionOnEndEditing(false);
                    button.setUsesDataSource(true);
                    button.setDataSource(this.quickConnectPopupModel.id());
                    button.setFocusRingType(NSView.NSFocusRingType.NSFocusRingTypeNone.ordinal());
                    button.setNumberOfVisibleItems(this.bookmarks.size() > 10 ? new NSInteger(10L) : new NSInteger((long)this.bookmarks.size()));
                    item.setView((NSView)button);
                    item.setMaxSize(new NSSize(button.frame().size.width.doubleValue(), button.frame().size.height.doubleValue()));
                    return item;
                }
                case encoding: {
                    item.setLabel(BrowserToolbarItem.encoding.label());
                    item.setPaletteLabel(BrowserToolbarItem.encoding.label());
                    item.setToolTip(BrowserToolbarItem.encoding.tooltip());
                    NSMenuItem toolbarMenu = NSMenuItem.itemWithTitle((String)LocaleFactory.localizedString((String)BrowserToolbarItem.encoding.label()), (Selector)BrowserToolbarItem.encoding.action(), (String)"");
                    String[] charsets = new DefaultCharsetProvider().availableCharsets();
                    NSMenu charsetMenu = NSMenu.menu();
                    for (String charset : charsets) {
                        NSMenuItem m = charsetMenu.addItemWithTitle_action_keyEquivalent(charset, BrowserToolbarItem.encoding.action(), "");
                        m.setRepresentedObject(charset);
                    }
                    toolbarMenu.setSubmenu(charsetMenu);
                    item.setMenuFormRepresentation(toolbarMenu);
                    NSPopUpButton button = NSPopUpButton.buttonWithFrame((NSRect)new NSRect(120.0, 26.0));
                    button.setImage(BrowserToolbarItem.encoding.image());
                    button.setMenu(charsetMenu);
                    button.setTarget(this.controller.id());
                    button.setAction(BrowserToolbarItem.encoding.action());
                    item.setView((NSView)button);
                    return item;
                }
                case edit: {
                    item.setLabel(BrowserToolbarItem.edit.label());
                    item.setPaletteLabel(BrowserToolbarItem.edit.label());
                    item.setToolTip(BrowserToolbarItem.edit.tooltip());
                    item.setTarget(this.controller.id());
                    item.setAction(BrowserToolbarItem.edit.action());
                    NSMenuItem toolbarMenu = NSMenuItem.itemWithTitle((String)BrowserToolbarItem.edit.label(), (Selector)BrowserToolbarItem.edit.action(), (String)"");
                    NSMenu editMenu = NSMenu.menu();
                    editMenu.setAutoenablesItems(true);
                    editMenu.setDelegate(this.controller.getEditMenuDelegate().id());
                    toolbarMenu.setSubmenu(editMenu);
                    NSButton button = NSButton.buttonWithFrame((NSRect)new NSRect(0.0, 0.0));
                    button.setBezelStyle(11);
                    button.setImage(BrowserToolbarItem.edit.image());
                    button.sizeToFit();
                    button.setTarget(this.controller.id());
                    button.setAction(BrowserToolbarItem.edit.action());
                    item.setView((NSView)button);
                    item.setMenuFormRepresentation(toolbarMenu);
                    return item;
                }
                case terminal: {
                    Application application = this.applicationFinder.getDescription(this.preferences.getProperty("terminal.bundle.identifier"));
                    item.setLabel(application.getName());
                    item.setPaletteLabel(application.getName());
                    item.setTarget(this.controller.id());
                    item.setAction(BrowserToolbarItem.terminal.action());
                    NSButton button = NSButton.buttonWithFrame((NSRect)new NSRect(0.0, 0.0));
                    button.setBezelStyle(11);
                    button.setImage(BrowserToolbarItem.terminal.image());
                    button.sizeToFit();
                    button.setTarget(this.controller.id());
                    button.setAction(BrowserToolbarItem.terminal.action());
                    item.setView((NSView)button);
                    return item;
                }
                case quicklook: {
                    item.setLabel(BrowserToolbarItem.quicklook.label());
                    item.setPaletteLabel(BrowserToolbarItem.quicklook.label());
                    NSButton button = NSButton.buttonWithFrame((NSRect)new NSRect(0.0, 0.0));
                    button.setBezelStyle(11);
                    button.setImage(BrowserToolbarItem.quicklook.image());
                    button.sizeToFit();
                    button.setTarget(this.controller.id());
                    button.setAction(BrowserToolbarItem.quicklook.action());
                    item.setView((NSView)button);
                    return item;
                }
            }
            item.setLabel(type.label());
            item.setPaletteLabel(LocaleFactory.localizedString((String)type.label()));
            item.setToolTip(type.tooltip());
            item.setAction(type.action());
            NSButton button = NSButton.buttonWithFrame((NSRect)new NSRect(0.0, 0.0));
            button.setBezelStyle(11);
            button.setImage(type.image());
            button.sizeToFit();
            button.setAction(type.action());
            item.setView((NSView)button);
            return item;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public NSArray getDefault() {
        return NSArray.arrayWithObjects((String[])new String[]{BrowserToolbarItem.connect.name(), "NSToolbarSeparatorItem", BrowserToolbarItem.quickconnect.name(), BrowserToolbarItem.tools.name(), "NSToolbarSeparatorItem", BrowserToolbarItem.reload.name(), BrowserToolbarItem.edit.name(), "NSToolbarFlexibleSpaceItem", BrowserToolbarItem.disconnect.name()});
    }

    @Override
    public NSArray getAllowed() {
        return NSArray.arrayWithObjects((String[])new String[]{BrowserToolbarItem.connect.name(), BrowserToolbarItem.browserview.name(), BrowserToolbarItem.transfers.name(), BrowserToolbarItem.quickconnect.name(), BrowserToolbarItem.tools.name(), BrowserToolbarItem.reload.name(), BrowserToolbarItem.encoding.name(), BrowserToolbarItem.synchronize.name(), BrowserToolbarItem.download.name(), BrowserToolbarItem.upload.name(), BrowserToolbarItem.edit.name(), BrowserToolbarItem.delete.name(), BrowserToolbarItem.newfolder.name(), BrowserToolbarItem.addbookmark.name(), BrowserToolbarItem.info.name(), BrowserToolbarItem.webbrowser.name(), BrowserToolbarItem.terminal.name(), BrowserToolbarItem.archive.name(), BrowserToolbarItem.quicklook.name(), BrowserToolbarItem.log.name(), BrowserToolbarItem.disconnect.name(), "NSToolbarCustomizeToolbarItem", "NSToolbarSpaceItem", "NSToolbarSeparatorItem", "NSToolbarFlexibleSpaceItem"});
    }

    public static enum BrowserToolbarItem {
        browserview{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"View");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Switch Browser View");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"browserSwitchButtonClicked:");
            }
        }
        ,
        transfers{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Show Transfers window");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"showTransferQueueClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("filetransfer.pdf");
            }
        }
        ,
        connect{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"New Connection");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Connect to server");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"connectButtonClicked:");
            }
        }
        ,
        quickconnect{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Quick Connect");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"quickConnectSelectionChanged:");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Connect to server");
            }
        }
        ,
        tools{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Action");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("actions.pdf");
            }

            @Override
            public Selector action() {
                return null;
            }
        }
        ,
        reload{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Refresh");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Refresh directory listing");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"reloadButtonClicked:");
            }
        }
        ,
        encoding{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Character Encoding");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"encodingMenuClicked:");
            }
        }
        ,
        synchronize{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Synchronize files");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"syncButtonClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("sync.pdf");
            }
        }
        ,
        download{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Download file");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"downloadButtonClicked:");
            }
        }
        ,
        upload{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Upload local file to the remote host");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"uploadButtonClicked:");
            }
        }
        ,
        edit{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Edit file in external editor");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"editButtonClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("editor.pdf");
            }
        }
        ,
        delete{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Delete file");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"deleteFileButtonClicked:");
            }
        }
        ,
        share{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Share\u2026", (String)"Main");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"shareFileButtonClicked:");
            }
        }
        ,
        newfolder{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"New Folder", (String)"Folder");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Create new folder", (String)"Folder");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"createFolderButtonClicked:");
            }
        }
        ,
        addbookmark{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"New Bookmark");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"addBookmarkButtonClicked:");
            }
        }
        ,
        info{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Get Info");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Show file attributes");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed(String.format("%s.pdf", "fileinfo"));
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"infoButtonClicked:");
            }
        }
        ,
        webbrowser{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Open");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Open in Web Browser");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"openBrowserButtonClicked:");
            }
        }
        ,
        stop{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Cancel current operation in progress");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"disconnectButtonClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("transferstop.pdf");
            }
        }
        ,
        disconnect{

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Disconnect from server");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"disconnectButtonClicked:");
            }

            @Override
            public NSImage image() {
                return (NSImage)IconCacheFactory.get().iconNamed("eject.pdf");
            }
        }
        ,
        terminal{

            @Override
            public Selector action() {
                return Foundation.selector((String)"openTerminalButtonClicked:");
            }
        }
        ,
        unarchive{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Unarchive", (String)"Archive");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"unarchiveButtonClicked:");
            }
        }
        ,
        archive{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Archive", (String)"Archive");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"archiveButtonClicked:");
            }
        }
        ,
        quicklook{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)"Quick Look");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"quicklookButtonClicked:");
            }
        }
        ,
        log{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()), (String)"Transfer");
            }

            @Override
            public String tooltip() {
                return LocaleFactory.localizedString((String)"Toggle Log Drawer");
            }

            @Override
            public Selector action() {
                return Foundation.selector((String)"toggleLogDrawer:");
            }
        };


        public String label() {
            return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()));
        }

        public String tooltip() {
            return null;
        }

        public abstract Selector action();

        public NSImage image() {
            return (NSImage)IconCacheFactory.get().iconNamed(String.format("%s.pdf", this.name()));
        }
    }

    private final class QuickConnectModel
    extends ProxyController
    implements NSComboBox.DataSource {
        private QuickConnectModel() {
        }

        public NSInteger numberOfItemsInComboBox(NSComboBox sender) {
            return new NSInteger((long)BrowserToolbarFactory.this.bookmarks.size());
        }

        public NSObject comboBox_objectValueForItemAtIndex(NSComboBox sender, NSInteger row) {
            return NSString.stringWithString((String)BookmarkNameProvider.toString((Host)((Host)BrowserToolbarFactory.this.bookmarks.get(row.intValue()))));
        }
    }
}

