/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.quicklook;

import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Local;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewItem;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanel;
import ch.cyberduck.ui.cocoa.quicklook.QLPreviewPanelDataSource;
import ch.cyberduck.ui.cocoa.quicklook.QuickLook;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.cocoa.foundation.NSInteger;

public final class QuartzQuickLook
implements QuickLook {
    private static final Logger log = Logger.getLogger(QuartzQuickLook.class);
    private final List<QLPreviewItem> previews = new ArrayList<QLPreviewItem>();
    private final QLPreviewPanelDataSource model = new QLPreviewPanelDataSource(){

        @Override
        public NSInteger numberOfPreviewItemsInPreviewPanel(QLPreviewPanel panel) {
            return new NSInteger((long)QuartzQuickLook.this.previews.size());
        }

        @Override
        public ID previewPanel_previewItemAtIndex(QLPreviewPanel panel, int index) {
            return ((QLPreviewItem)((Object)QuartzQuickLook.this.previews.get(index))).id();
        }
    };

    @Override
    public void select(List<Local> files) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Select files for %s", files));
        }
        this.previews.clear();
        for (final Local selected : files) {
            this.previews.add(new QLPreviewItem(){

                @Override
                public NSURL previewItemURL() {
                    return NSURL.fileURLWithPath((String)selected.getAbsolute());
                }

                @Override
                public String previewItemTitle() {
                    return selected.getDisplayName();
                }
            });
        }
    }

    @Override
    public boolean isOpen() {
        return QLPreviewPanel.sharedPreviewPanelExists() && QLPreviewPanel.sharedPreviewPanel().isVisible();
    }

    @Override
    public void open() {
        QLPreviewPanel panel = QLPreviewPanel.sharedPreviewPanel();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Order front panel %s", new Object[]{panel}));
        }
        panel.makeKeyAndOrderFront(null);
        panel.setDataSource(this.model.id());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Reload data for panel %s", new Object[]{panel}));
        }
        panel.reloadData();
    }

    @Override
    public void close() {
        QLPreviewPanel panel = QLPreviewPanel.sharedPreviewPanel();
        if (null != panel.currentController()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Order out panel %s", new Object[]{panel}));
            }
            panel.setDataSource(null);
            panel.orderOut(null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Clear previews");
        }
        this.previews.clear();
    }
}

