/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.delegate.AbstractMenuDelegate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class URLMenuDelegate
extends AbstractMenuDelegate {
    protected abstract SessionPool getSession();

    protected abstract List<Path> getSelected();

    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        List<Path> selected = this.getSelected();
        if (selected.isEmpty()) {
            return new NSInteger(1L);
        }
        int urls = this.getURLs(selected.iterator().next()).size();
        if (0 == urls) {
            return new NSInteger(1L);
        }
        return new NSInteger((long)(urls * 2));
    }

    protected abstract List<DescriptiveUrl> getURLs(Path var1);

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        List<Path> selected = this.getSelected();
        if (selected.isEmpty() || this.getURLs(selected.iterator().next()).isEmpty()) {
            item.setTitle(LocaleFactory.localizedString((String)"None"));
            item.setEnabled(false);
            item.setAction(null);
            item.setTarget(null);
            item.setImage(null);
        } else {
            boolean label;
            boolean bl = label = index.intValue() % 2 == 0;
            if (label) {
                item.setEnabled(true);
                item.setTarget(this.id());
                item.setAction(Foundation.selector((String)"menuItemClicked:"));
                item.setImage((NSImage)IconCacheFactory.get().iconNamed("site.tiff", Integer.valueOf(16)));
                Iterator<Path> iter = selected.iterator();
                DescriptiveUrl url = this.getURLs(iter.next()).get(index.intValue() / 2);
                item.setTitle(url.getHelp());
                if (url.getType().equals((Object)DescriptiveUrl.Type.provider)) {
                    this.setShortcut(item, this.getKeyEquivalent(), this.getModifierMask());
                } else {
                    this.clearShortcut(item);
                }
            } else {
                List<DescriptiveUrl> target = this.getURLs(index, selected);
                item.setAttributedTitle(NSAttributedString.attributedStringWithAttributes((String)StringUtils.join(target, (char)'\n'), (NSDictionary)BundleController.MENU_HELP_FONT_ATTRIBUTES));
            }
        }
        return super.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    private List<DescriptiveUrl> getURLs(NSInteger index, List<Path> selected) {
        ArrayList<DescriptiveUrl> list = new ArrayList<DescriptiveUrl>();
        for (Path file : selected) {
            List<DescriptiveUrl> urls = this.getURLs(file);
            DescriptiveUrl url = urls.get(index.intValue() / 2);
            list.add(url);
        }
        return list;
    }

    public void menuItemClicked(NSMenuItem item) {
        this.handle(this.getURLs(item.menu().indexOfItem(item), this.getSelected()));
    }

    public abstract void handle(List<DescriptiveUrl> var1);

    @Override
    public boolean validateMenuItem(NSMenuItem item) {
        List<Path> selected = this.getSelected();
        if (selected.isEmpty()) {
            return false;
        }
        Selector action = item.action();
        if (action.equals((Object)this.getDefaultAction())) {
            return StringUtils.isNotBlank((CharSequence)item.representedObject());
        }
        return true;
    }

    @Override
    protected ID getTarget() {
        return this.id();
    }

    @Override
    public Selector getDefaultAction() {
        return null;
    }
}

