/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.HistoryCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.MainController;
import ch.cyberduck.ui.cocoa.delegate.CollectionMenuDelegate;
import ch.cyberduck.ui.cocoa.delegate.MenuCallback;
import java.util.Date;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public class HistoryMenuDelegate
extends CollectionMenuDelegate<Host> {
    private static final Logger log = Logger.getLogger(HistoryMenuDelegate.class);
    private final AbstractHostCollection collection = HistoryCollection.defaultCollection();
    private final MenuCallback callback;
    private final Preferences preferences = PreferencesFactory.get();

    public HistoryMenuDelegate() {
        this(new MenuCallback(){

            @Override
            public void selected(NSMenuItem sender) {
                MainController.newDocument().mount(HistoryCollection.defaultCollection().lookup(sender.representedObject()));
            }
        });
    }

    public HistoryMenuDelegate(MenuCallback callback) {
        this((AbstractHostCollection)HistoryCollection.defaultCollection(), callback);
    }

    public HistoryMenuDelegate(AbstractHostCollection collection, MenuCallback callback) {
        super(collection);
        this.callback = callback;
    }

    @Override
    public NSInteger numberOfItemsInMenu(NSMenu menu) {
        if (this.isPopulated()) {
            return new NSInteger(-1L);
        }
        if (this.collection.size() > 0) {
            return new NSInteger((long)(this.collection.size() + 2));
        }
        return new NSInteger(1L);
    }

    @Override
    public Host itemForIndex(NSInteger index) {
        return (Host)this.collection.get(index.intValue());
    }

    @Override
    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger row, boolean cancel) {
        int size = this.collection.size();
        if (size == 0) {
            item.setTitle(LocaleFactory.localizedString((String)"None"));
            item.setTarget(null);
            item.setAction(null);
            item.setImage(null);
            item.setEnabled(false);
            return false;
        }
        if (row.intValue() < size) {
            Date timestamp;
            Host h = this.itemForIndex(row);
            item.setTarget(this.id());
            item.setAction(this.getDefaultAction());
            item.setRepresentedObject(h.getUuid());
            item.setEnabled(true);
            NSMutableAttributedString title = NSMutableAttributedString.create((String)BookmarkNameProvider.toString((Host)h));
            if (this.preferences.getInteger("bookmark.menu.icon.size") >= 64) {
                title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", h.getHostname()), (NSDictionary)BundleController.MENU_HELP_FONT_ATTRIBUTES));
            }
            if (null != (timestamp = h.getTimestamp())) {
                title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", UserDateFormatterFactory.get().getLongFormat(timestamp.getTime())), (NSDictionary)BundleController.MENU_HELP_FONT_ATTRIBUTES));
            } else {
                title.appendAttributedString(NSAttributedString.attributedStringWithAttributes((String)String.format("\n%s", LocaleFactory.localizedString((String)"Unknown")), (NSDictionary)BundleController.MENU_HELP_FONT_ATTRIBUTES));
            }
            item.setAttributedTitle((NSAttributedString)title);
            item.setTitle(BookmarkNameProvider.toString((Host)h));
            switch (this.preferences.getInteger("bookmark.menu.icon.size")) {
                default: {
                    item.setImage((NSImage)IconCacheFactory.get().iconNamed(h.getProtocol().icon(), Integer.valueOf(24)));
                    break;
                }
                case 64: {
                    item.setImage((NSImage)IconCacheFactory.get().iconNamed(h.getProtocol().icon(), Integer.valueOf(40)));
                    break;
                }
            }
        } else if (row.intValue() == size) {
            menu.removeItemAtIndex(row);
            menu.insertItem_atIndex(this.seperator(), row);
        } else if (row.intValue() == size + 1) {
            item.setTitle(LocaleFactory.localizedString((String)"Clear Menu"));
            item.setTarget(this.id());
            item.setAction(Foundation.selector((String)"clearMenuItemClicked:"));
            item.setEnabled(true);
        }
        return super.menuUpdateItemAtIndex(menu, item, row, cancel);
    }

    public void menuItemClicked(NSMenuItem sender) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Menu item clicked %s", sender));
        }
        this.callback.selected(sender);
    }

    public void clearMenuItemClicked(NSMenuItem sender) {
        this.collection.clear();
    }

    @Override
    public Selector getDefaultAction() {
        return Foundation.selector((String)"menuItemClicked:");
    }
}

