/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.delegate;

import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSEvent;
import ch.cyberduck.binding.application.NSMenu;
import ch.cyberduck.binding.application.NSMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.ID;
import org.rococoa.Selector;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class AbstractMenuDelegate
extends ProxyController
implements NSMenu.Delegate,
NSMenu.Validation {
    private static final Logger log = Logger.getLogger(AbstractMenuDelegate.class);
    private boolean update = true;

    public boolean menu_updateItem_atIndex_shouldCancel(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        return this.menuUpdateItemAtIndex(menu, item, index, cancel);
    }

    public boolean menuUpdateItemAtIndex(NSMenu menu, NSMenuItem item, NSInteger index, boolean cancel) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("menuUpdateItemAtIndex:" + index.intValue()));
        }
        if (index.intValue() == this.numberOfItemsInMenu(menu).intValue() - 1) {
            this.setNeedsUpdate(false);
        }
        return !cancel;
    }

    public abstract Selector getDefaultAction();

    protected ID getTarget() {
        return this.id();
    }

    protected String getKeyEquivalent() {
        return null;
    }

    protected int getModifierMask() {
        return 0x100000;
    }

    public boolean menuHasKeyEquivalent_forEvent(NSMenu menu, NSEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("menuHasKeyEquivalent_forEvent:" + menu));
        }
        if (StringUtils.isBlank((CharSequence)this.getKeyEquivalent())) {
            return false;
        }
        if ((event.modifierFlags() & this.getModifierMask()) == this.getModifierMask()) {
            return event.charactersIgnoringModifiers().equalsIgnoreCase(this.getKeyEquivalent());
        }
        return false;
    }

    public ID menuKeyEquivalentTarget_forEvent(NSMenu menu, NSEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("menuKeyEquivalentTarget_forEvent:" + menu));
        }
        return this.getTarget();
    }

    public Selector menuKeyEquivalentAction_forEvent(NSMenu menu, NSEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("menuKeyEquivalentAction_forEvent:" + menu));
        }
        return this.getDefaultAction();
    }

    public void setNeedsUpdate(boolean u) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setNeedsUpdate:" + u));
        }
        this.update = u;
    }

    protected boolean isPopulated() {
        return !this.update;
    }

    protected NSMenuItem seperator() {
        return NSMenuItem.separatorItem();
    }

    public boolean validateMenuItem(NSMenuItem item) {
        return true;
    }

    protected void clearShortcut(NSMenuItem item) {
        this.setShortcut(item, "", 0);
    }

    protected void setShortcut(NSMenuItem item, String key) {
        this.setShortcut(item, key, 0);
    }

    protected void setShortcut(NSMenuItem item, String key, int modifier) {
        item.setKeyEquivalent(key);
        if (log.isDebugEnabled() && !item.keyEquivalent().equals(key)) {
            log.error((Object)("Failed to attach key equivalent to menu item:" + key));
        }
        item.setKeyEquivalentModifierMask(modifier);
    }
}

