/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import java.text.MessageFormat;

public class RecursiveAlertController<T>
extends AlertController {
    private final T value;
    private final Path directory;

    public RecursiveAlertController(T value, Path directory) {
        this.value = value;
        this.directory = directory;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(0);
        alert.setMessageText(LocaleFactory.localizedString((String)"Apply changes recursively"));
        alert.setInformativeText(MessageFormat.format(LocaleFactory.localizedString((String)"Do you want to set {0} on {1} recursively for all contained files?"), this.value, this.directory.getName()));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Continue", (String)"Credentials"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel"));
        alert.setShowsSuppressionButton(true);
        alert.suppressionButton().setTitle(LocaleFactory.localizedString((String)"Always"));
        super.loadBundle(alert);
    }
}

