/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.HyperlinkAttributedStringFactory;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageView;
import ch.cyberduck.binding.application.NSResponder;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.ConnectionController;
import org.apache.commons.lang3.StringUtils;

public class LoginController
extends ConnectionController {
    private final String title;
    private final String reason;
    private NSImageView iconView;
    private NSTextField titleField;
    private NSTextField textField;

    public LoginController(Host bookmark, String title, String reason, LoginOptions options) {
        super(bookmark, options);
        this.title = title;
        this.reason = reason;
    }

    @Override
    public void awakeFromNib() {
        super.awakeFromNib();
        if (this.options.user) {
            this.window.makeFirstResponder((NSResponder)this.usernameField);
        }
        if (this.options.password && !StringUtils.isBlank((CharSequence)this.bookmark.getCredentials().getUsername())) {
            this.window.makeFirstResponder((NSResponder)this.passwordField);
        }
    }

    @Override
    protected String getBundleName() {
        return "Login";
    }

    public void setIconView(NSImageView iconView) {
        this.iconView = iconView;
        this.iconView.setImage((NSImage)IconCacheFactory.get().iconNamed(this.options.icon, Integer.valueOf(64)));
    }

    public void setTitleField(NSTextField titleField) {
        this.titleField = titleField;
        this.updateField(this.titleField, LocaleFactory.localizedString((String)this.title, (String)"Credentials"));
    }

    public void setTextField(NSTextField textField) {
        this.textField = textField;
        this.textField.setSelectable(true);
        if (StringUtils.startsWith((CharSequence)this.reason, (CharSequence)Scheme.http.name())) {
            this.textField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((String)this.reason));
            this.textField.setAllowsEditingTextAttributes(true);
            this.textField.setSelectable(true);
        } else {
            this.updateField(this.textField, new StringAppender().append(this.reason).toString());
        }
    }
}

