/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import ch.cyberduck.ui.cocoa.controller.InfoController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InfoControllerFactory {
    private static final Map<BrowserController, InfoController> open = new HashMap<BrowserController, InfoController>();
    private static final Preferences preferences = PreferencesFactory.get();

    private InfoControllerFactory() {
    }

    public static InfoController create(final BrowserController controller, List<Path> files) {
        if (preferences.getBoolean("browser.info.inspector") && open.containsKey(controller)) {
            InfoController c = open.get(controller);
            c.setFiles(files);
            return c;
        }
        InfoController info = new InfoController((Controller)controller, controller.getSession(), files){

            @Override
            public void windowWillClose(NSNotification notification) {
                open.remove(controller);
                super.windowWillClose(notification);
            }
        };
        info.loadBundle();
        open.put(controller, info);
        return info;
    }

    public static InfoController get(BrowserController controller) {
        return open.get(controller);
    }
}

