/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AbstractTableDelegate;
import ch.cyberduck.binding.BundleController;
import ch.cyberduck.binding.HyperlinkAttributedStringFactory;
import ch.cyberduck.binding.ListDataSource;
import ch.cyberduck.binding.ToolbarWindowController;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.AppKitFunctionsLibrary;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSCell;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSComboBoxCell;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageView;
import ch.cyberduck.binding.application.NSMenuItem;
import ch.cyberduck.binding.application.NSPopUpButton;
import ch.cyberduck.binding.application.NSProgressIndicator;
import ch.cyberduck.binding.application.NSTabViewItem;
import ch.cyberduck.binding.application.NSTableColumn;
import ch.cyberduck.binding.application.NSTableView;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTextFieldCell;
import ch.cyberduck.binding.application.NSToolbar;
import ch.cyberduck.binding.application.NSToolbarItem;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSIndexSet;
import ch.cyberduck.binding.foundation.NSMutableAttributedString;
import ch.cyberduck.binding.foundation.NSNotification;
import ch.cyberduck.binding.foundation.NSNotificationCenter;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Header;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginCallbackFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.PermissionOverwrite;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProviderHelpServiceFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.analytics.AnalyticsProvider;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cdn.features.Cname;
import ch.cyberduck.core.cdn.features.DistributionLogging;
import ch.cyberduck.core.cdn.features.Index;
import ch.cyberduck.core.cdn.features.Purge;
import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.lifecycle.LifecycleConfiguration;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.local.FileDescriptor;
import ch.cyberduck.core.local.FileDescriptorFactory;
import ch.cyberduck.core.logging.LoggingConfiguration;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.RegistryBackgroundAction;
import ch.cyberduck.core.threading.WindowMainAction;
import ch.cyberduck.core.threading.WorkerBackgroundAction;
import ch.cyberduck.core.worker.BooleanRecursiveCallback;
import ch.cyberduck.core.worker.CalculateSizeWorker;
import ch.cyberduck.core.worker.DistributionPurgeWorker;
import ch.cyberduck.core.worker.ReadAclWorker;
import ch.cyberduck.core.worker.ReadDistributionWorker;
import ch.cyberduck.core.worker.ReadMetadataWorker;
import ch.cyberduck.core.worker.ReadPermissionWorker;
import ch.cyberduck.core.worker.ReadSizeWorker;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WriteAclWorker;
import ch.cyberduck.core.worker.WriteDistributionWorker;
import ch.cyberduck.core.worker.WriteEncryptionWorker;
import ch.cyberduck.core.worker.WriteIdentityWorker;
import ch.cyberduck.core.worker.WriteLifecycleWorker;
import ch.cyberduck.core.worker.WriteLoggingWorker;
import ch.cyberduck.core.worker.WriteMetadataWorker;
import ch.cyberduck.core.worker.WritePermissionWorker;
import ch.cyberduck.core.worker.WriteRedundancyWorker;
import ch.cyberduck.core.worker.WriteTransferAccelerationWorker;
import ch.cyberduck.core.worker.WriteVersioningWorker;
import ch.cyberduck.ui.cocoa.callback.PromptRecursiveCallback;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ID;
import org.rococoa.ObjCObject;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSPoint;
import org.rococoa.cocoa.foundation.NSSize;
import org.rococoa.cocoa.foundation.NSUInteger;

public class InfoController
extends ToolbarWindowController {
    private static final Logger log = Logger.getLogger(InfoController.class);
    private static NSPoint cascade = new NSPoint(0.0, 0.0);
    private final Controller controller;
    private final SessionPool session;
    private final NSComboBoxCell aclPermissionCellPrototype = NSComboBoxCell.comboBoxCell();
    private final NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    private List<Path> files;
    private final FileDescriptor descriptor = FileDescriptorFactory.get();
    private final LoginCallback prompt = LoginCallbackFactory.get((Controller)this);
    private final PathContainerService containerService = new PathContainerService();
    private final Preferences preferences = PreferencesFactory.get();
    private final List<Acl.UserAndRole> acl = new ArrayList<Acl.UserAndRole>();
    private final List<Header> metadata = new ArrayList<Header>();
    private NSTextField filenameField;
    private NSTextField groupField;
    private NSTextField kindField;
    private NSTextField modifiedField;
    private NSTextField createdField;
    private NSTextField permissionsField;
    private NSTextField octalField;
    private NSTextField ownerField;
    private NSTextField sizeField;
    private NSTextField checksumField;
    private NSTextField pathField;
    private NSTextField webUrlField;
    private NSButton recursiveButton;
    private NSButton sizeButton;
    private NSProgressIndicator sizeProgress;
    private NSProgressIndicator permissionProgress;
    private NSProgressIndicator s3Progress;
    private NSProgressIndicator aclProgress;
    private NSProgressIndicator metadataProgress;
    private NSProgressIndicator distributionProgress;
    private NSButton distributionEnableButton;
    private NSButton distributionLoggingButton;
    private NSPopUpButton distributionLoggingPopup;
    private NSButton distributionInvalidateObjectsButton;
    private NSTextField distributionInvalidationStatusField;
    private NSPopUpButton distributionDeliveryPopup;
    private NSPopUpButton distributionDefaultRootPopup;
    private NSTextField bucketLocationField;
    private NSPopUpButton storageClassPopup;
    private NSPopUpButton encryptionPopup;
    private NSButton bucketLoggingButton;
    private NSPopUpButton bucketLoggingPopup;
    private NSButton bucketAnalyticsButton;
    private NSTextField bucketAnalyticsSetupUrlField;
    private NSButton bucketTransferAccelerationButton;
    private NSButton bucketVersioningButton;
    private NSButton bucketMfaButton;
    private NSButton lifecycleTransitionCheckbox;
    private NSPopUpButton lifecycleTransitionPopup;
    private NSButton lifecycleDeleteCheckbox;
    private NSPopUpButton lifecycleDeletePopup;
    private NSTextField distributionCnameField;
    private NSTextField distributionOriginField;
    private NSTextField distributionStatusField;
    private NSTextField distributionUrlField;
    private NSTextField distributionCnameUrlField;
    private NSTextField aclUrlField;
    private NSTableView aclTable;
    private ListDataSource aclTableModel;
    private AbstractTableDelegate<Acl.UserAndRole, AclColumn> aclTableDelegate;
    private NSPopUpButton aclAddButton;
    private NSButton aclRemoveButton;
    private NSTableView metadataTable;
    private ListDataSource metadataTableModel;
    private AbstractTableDelegate<String, MetadataColumn> metadataTableDelegate;
    private NSPopUpButton metadataAddButton;
    private NSButton metadataRemoveButton;
    private NSButton ownerr;
    private NSButton ownerw;
    private NSButton ownerx;
    private NSButton groupr;
    private NSButton groupw;
    private NSButton groupx;
    private NSButton otherr;
    private NSButton otherw;
    private NSButton otherx;
    private NSImageView iconImageView;
    private NSView panelMetadata;
    private NSView panelCloud;
    private NSView panelDistribution;
    private NSView panelPermissions;
    private NSView panelAcl;
    private NSView panelGeneral;
    private NSButton distributionAnalyticsButton;
    private NSTextField distributionAnalyticsSetupUrlField;

    public InfoController(Controller controller, SessionPool session, List<Path> files) {
        this.controller = controller;
        this.session = session;
        this.files = files;
    }

    private Path getSelected() {
        Iterator<Path> iterator = this.files.iterator();
        if (iterator.hasNext()) {
            Path file = iterator.next();
            return file;
        }
        throw new IllegalArgumentException();
    }

    public void setWindow(NSWindow window) {
        window.setFrameAutosaveName("Info");
        window.setHidesOnDeactivate(false);
        window.setShowsResizeIndicator(true);
        window.setContentMinSize(window.frame().size);
        window.setContentMaxSize(new NSSize(600.0, window.frame().size.height.doubleValue()));
        super.setWindow(window);
        if (!this.preferences.getBoolean("browser.info.inspector")) {
            cascade = this.cascade(cascade);
        }
    }

    public void windowWillClose(NSNotification notification) {
        cascade = new NSPoint(this.window().frame().origin.x.doubleValue(), this.window().frame().origin.y.doubleValue() + this.window().frame().size.height.doubleValue());
        super.windowWillClose(notification);
    }

    public boolean isSingleton() {
        return this.preferences.getBoolean("browser.info.inspector");
    }

    protected void initializePanel(String identifier) {
        InfoToolbarItem item;
        try {
            item = InfoToolbarItem.valueOf(identifier);
        }
        catch (IllegalArgumentException e) {
            item = InfoToolbarItem.info;
        }
        switch (item) {
            case info: {
                this.initGeneral();
                this.initPermissions();
                break;
            }
            case permissions: {
                this.initPermissions();
                break;
            }
            case acl: {
                this.initAcl();
                break;
            }
            case distribution: {
                this.initDistribution();
                break;
            }
            case s3: {
                this.initS3();
                break;
            }
            case metadata: {
                this.initMetadata();
            }
        }
    }

    protected NSUInteger getToolbarSize() {
        return NSToolbar.NSToolbarSizeModeSmall;
    }

    public NSToolbarItem toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(NSToolbar toolbar, String identifier, boolean flag) {
        NSToolbarItem item = super.toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(toolbar, identifier, flag);
        switch (InfoToolbarItem.valueOf(identifier)) {
            case distribution: {
                if (this.session.getFeature(DistributionConfiguration.class) != null) {
                    item.setImage((NSImage)IconCacheFactory.get().iconNamed(this.session.getHost().getProtocol().icon(), Integer.valueOf(32)));
                    break;
                }
                item.setImage((NSImage)IconCacheFactory.get().iconNamed(new S3Protocol().icon(), Integer.valueOf(32)));
                break;
            }
            case s3: {
                item.setLabel(this.session.getHost().getProtocol().getName());
                item.setImage((NSImage)IconCacheFactory.get().iconNamed(this.session.getHost().getProtocol().icon(), Integer.valueOf(32)));
                break;
            }
            case metadata: {
                item.setImage((NSImage)IconCacheFactory.get().iconNamed("pencil.tiff", Integer.valueOf(32)));
                break;
            }
            case acl: {
                item.setImage((NSImage)IconCacheFactory.get().iconNamed("permissions.tiff", Integer.valueOf(32)));
            }
        }
        return item;
    }

    protected boolean validateTabWithIdentifier(String identifier) {
        boolean anonymous = this.session.getHost().getCredentials().isAnonymousLogin();
        switch (InfoToolbarItem.valueOf(identifier)) {
            case permissions: {
                if (anonymous) {
                    return false;
                }
                return this.session.getFeature(UnixPermission.class) != null;
            }
            case acl: {
                if (anonymous) {
                    return false;
                }
                return this.session.getFeature(AclPermission.class) != null;
            }
            case distribution: {
                if (anonymous) {
                    return false;
                }
                return this.session.getFeature(DistributionConfiguration.class) != null;
            }
            case s3: {
                if (anonymous) {
                    return false;
                }
                return this.session.getHost().getProtocol().getType() == Protocol.Type.s3 || this.session.getHost().getProtocol().getType() == Protocol.Type.b2 || this.session.getHost().getProtocol().getType() == Protocol.Type.azure || this.session.getHost().getProtocol().getType() == Protocol.Type.googlestorage;
            }
            case metadata: {
                if (anonymous) {
                    return false;
                }
                return this.session.getFeature(Metadata.class) != null;
            }
        }
        return true;
    }

    public String getTitle(NSTabViewItem item) {
        return String.format("%s \u2013 %s", item.label(), this.getName());
    }

    protected String getBundleName() {
        return "Info";
    }

    public void setFiles(List<Path> files) {
        if (files.isEmpty()) {
            return;
        }
        this.files = files;
        this.initializePanel(this.getSelectedTab());
        this.setTitle(this.getTitle(this.tabView.selectedTabViewItem()));
    }

    protected Map<ToolbarWindowController.Label, NSView> getPanels() {
        LinkedHashMap<ToolbarWindowController.Label, NSView> views = new LinkedHashMap<ToolbarWindowController.Label, NSView>();
        views.put(new ToolbarWindowController.Label(InfoToolbarItem.info.name(), InfoToolbarItem.info.label()), this.panelGeneral);
        if (this.session.getFeature(AclPermission.class) != null) {
            views.put(new ToolbarWindowController.Label(InfoToolbarItem.acl.name(), InfoToolbarItem.acl.label()), this.panelAcl);
        } else {
            views.put(new ToolbarWindowController.Label(InfoToolbarItem.permissions.name(), InfoToolbarItem.permissions.label()), this.panelPermissions);
        }
        views.put(new ToolbarWindowController.Label(InfoToolbarItem.metadata.name(), InfoToolbarItem.metadata.label()), this.panelMetadata);
        views.put(new ToolbarWindowController.Label(InfoToolbarItem.distribution.name(), InfoToolbarItem.distribution.label()), this.panelDistribution);
        views.put(new ToolbarWindowController.Label(InfoToolbarItem.s3.name(), InfoToolbarItem.s3.label()), this.panelCloud);
        return views;
    }

    private String getName() {
        int count = this.numberOfFiles();
        if (count > 1) {
            return String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files"));
        }
        Path file = this.getSelected();
        return file.getName();
    }

    public void setFilenameField(NSTextField filenameField) {
        this.filenameField = filenameField;
        this.filenameField.setEditable(false);
    }

    public void setGroupField(NSTextField t) {
        this.groupField = t;
    }

    public void setKindField(NSTextField t) {
        this.kindField = t;
    }

    public void setModifiedField(NSTextField t) {
        this.modifiedField = t;
    }

    public void setCreatedField(NSTextField t) {
        this.createdField = t;
    }

    public void setPermissionsField(NSTextField permissionsField) {
        this.permissionsField = permissionsField;
    }

    public void setOctalField(NSTextField t) {
        this.octalField = t;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"octalPermissionsInputDidEndEditing:"), "NSControlTextDidEndEditingNotification", t.id());
    }

    public void setOwnerField(NSTextField t) {
        this.ownerField = t;
    }

    public void setSizeField(NSTextField t) {
        this.sizeField = t;
    }

    public void setChecksumField(NSTextField t) {
        this.checksumField = t;
    }

    public void setPathField(NSTextField t) {
        this.pathField = t;
    }

    public void setWebUrlField(NSTextField t) {
        this.webUrlField = t;
        this.webUrlField.setAllowsEditingTextAttributes(true);
        this.webUrlField.setSelectable(true);
    }

    public void setRecursiveButton(NSButton b) {
        this.recursiveButton = b;
        this.recursiveButton.setTarget(this.id());
        this.recursiveButton.setAction(Foundation.selector((String)"recursiveButtonClicked:"));
    }

    public void setSizeButton(NSButton b) {
        this.sizeButton = b;
        this.sizeButton.setTarget(this.id());
        this.sizeButton.setAction(Foundation.selector((String)"calculateSizeButtonClicked:"));
    }

    public void setSizeProgress(NSProgressIndicator p) {
        this.sizeProgress = p;
        this.sizeProgress.setDisplayedWhenStopped(false);
        this.sizeProgress.setStyle(1);
    }

    public void setPermissionProgress(NSProgressIndicator p) {
        this.permissionProgress = p;
        this.permissionProgress.setDisplayedWhenStopped(false);
        this.permissionProgress.setStyle(1);
    }

    public void setS3Progress(NSProgressIndicator p) {
        this.s3Progress = p;
        this.s3Progress.setDisplayedWhenStopped(false);
        this.s3Progress.setStyle(1);
    }

    public void setAclProgress(NSProgressIndicator p) {
        this.aclProgress = p;
        this.aclProgress.setDisplayedWhenStopped(false);
        this.aclProgress.setStyle(1);
    }

    public void setMetadataProgress(NSProgressIndicator p) {
        this.metadataProgress = p;
        this.metadataProgress.setDisplayedWhenStopped(false);
        this.metadataProgress.setStyle(1);
    }

    public void setDistributionProgress(NSProgressIndicator p) {
        this.distributionProgress = p;
        this.distributionProgress.setDisplayedWhenStopped(false);
        this.distributionProgress.setStyle(1);
    }

    public void setDistributionEnableButton(NSButton b) {
        this.distributionEnableButton = b;
        this.distributionEnableButton.setTarget(this.id());
        this.distributionEnableButton.setAction(Foundation.selector((String)"distributionApplyButtonClicked:"));
    }

    public void setDistributionLoggingButton(NSButton b) {
        this.distributionLoggingButton = b;
        this.distributionLoggingButton.setTarget(this.id());
        this.distributionLoggingButton.setAction(Foundation.selector((String)"distributionApplyButtonClicked:"));
    }

    public void setDistributionLoggingPopup(NSPopUpButton b) {
        this.distributionLoggingPopup = b;
        this.distributionLoggingPopup.setTarget(this.id());
        this.distributionLoggingPopup.setAction(Foundation.selector((String)"distributionLoggingPopupClicked:"));
    }

    public void setDistributionInvalidateObjectsButton(NSButton b) {
        this.distributionInvalidateObjectsButton = b;
        this.distributionInvalidateObjectsButton.setTarget(this.id());
        this.distributionInvalidateObjectsButton.setAction(Foundation.selector((String)"distributionInvalidateObjectsButtonClicked:"));
    }

    public void setDistributionInvalidationStatusField(NSTextField t) {
        this.distributionInvalidationStatusField = t;
    }

    public void setDistributionDeliveryPopup(NSPopUpButton b) {
        this.distributionDeliveryPopup = b;
        this.distributionDeliveryPopup.setTarget(this.id());
        this.distributionDeliveryPopup.setAction(Foundation.selector((String)"distributionStatusButtonClicked:"));
    }

    public void setDistributionDefaultRootPopup(NSPopUpButton b) {
        this.distributionDefaultRootPopup = b;
        this.distributionDefaultRootPopup.setTarget(this.id());
        this.distributionDefaultRootPopup.setAction(Foundation.selector((String)"distributionApplyButtonClicked:"));
    }

    public void setBucketLocationField(NSTextField t) {
        this.bucketLocationField = t;
    }

    public void setStorageClassPopup(NSPopUpButton b) {
        this.storageClassPopup = b;
        this.storageClassPopup.setTarget(this.id());
        this.storageClassPopup.setAction(Foundation.selector((String)"storageClassPopupClicked:"));
        this.storageClassPopup.setAllowsMixedState(true);
    }

    public void storageClassPopupClicked(NSPopUpButton sender) {
        if (this.toggleS3Settings(false)) {
            String redundancy = sender.selectedItem().representedObject();
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteRedundancyWorker(this.files, redundancy, new PromptRecursiveCallback((WindowController)this), (ProgressListener)this.controller){

                public void cleanup(Boolean v) {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            }));
        }
    }

    public void setEncryptionPopup(NSPopUpButton b) {
        this.encryptionPopup = b;
        this.encryptionPopup.setTarget(this.id());
        this.encryptionPopup.setAction(Foundation.selector((String)"encryptionPopupClicked:"));
        this.encryptionPopup.setAllowsMixedState(true);
    }

    public void encryptionPopupClicked(NSPopUpButton sender) {
        String algorithm = sender.selectedItem().representedObject();
        if (null != algorithm && this.toggleS3Settings(false)) {
            Encryption.Algorithm encryption = Encryption.Algorithm.fromString((String)algorithm);
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteEncryptionWorker(this.files, encryption, new PromptRecursiveCallback((WindowController)this), (ProgressListener)this.controller){

                public void cleanup(Boolean v) {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            }));
        }
    }

    public void setBucketLoggingButton(NSButton b) {
        this.bucketLoggingButton = b;
        this.bucketLoggingButton.setAction(Foundation.selector((String)"bucketLoggingButtonClicked:"));
    }

    public void bucketLoggingButtonClicked(NSButton sender) {
        if (this.toggleS3Settings(false)) {
            LoggingConfiguration configuration = new LoggingConfiguration(this.bucketLoggingButton.state() == 1, null == this.bucketLoggingPopup.selectedItem() ? null : this.bucketLoggingPopup.selectedItem().representedObject());
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteLoggingWorker(this.files, configuration){

                public void cleanup(Boolean result) {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            }));
        }
    }

    public void setBucketLoggingPopup(NSPopUpButton b) {
        this.bucketLoggingPopup = b;
        this.bucketLoggingPopup.setTarget(this.id());
        this.bucketLoggingPopup.setAction(Foundation.selector((String)"bucketLoggingPopupClicked:"));
    }

    public void bucketLoggingPopupClicked(NSPopUpButton sender) {
        if (this.bucketLoggingButton.state() == 1) {
            this.bucketLoggingButtonClicked((NSButton)sender);
        }
    }

    public void setBucketAnalyticsButton(NSButton b) {
        this.bucketAnalyticsButton = b;
        this.bucketAnalyticsButton.setAction(Foundation.selector((String)"bucketAnalyticsButtonClicked:"));
    }

    public void bucketAnalyticsButtonClicked(NSButton sender) {
        if (this.toggleS3Settings(false)) {
            boolean enabled = this.bucketAnalyticsButton.state() == 1;
            String document = this.preferences.getProperty("analytics.provider.qloudstat.iam.policy");
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteIdentityWorker(this.prompt, enabled, document){

                public void cleanup(Boolean done) {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            }));
        }
    }

    public void setBucketAnalyticsSetupUrlField(NSTextField f) {
        this.bucketAnalyticsSetupUrlField = f;
        this.bucketAnalyticsSetupUrlField.setAllowsEditingTextAttributes(true);
        this.bucketAnalyticsSetupUrlField.setSelectable(true);
    }

    public void setBucketVersioningButton(NSButton b) {
        this.bucketVersioningButton = b;
        this.bucketVersioningButton.setAction(Foundation.selector((String)"bucketVersioningButtonClicked:"));
    }

    public void bucketVersioningButtonClicked(NSButton sender) {
        if (this.toggleS3Settings(false)) {
            VersioningConfiguration configuration = new VersioningConfiguration(this.bucketVersioningButton.state() == 1, this.bucketMfaButton.state() == 1);
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteVersioningWorker(this.files, this.prompt, configuration){

                public void cleanup(Boolean result) {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            }));
        }
    }

    public void setBucketMfaButton(NSButton b) {
        this.bucketMfaButton = b;
        this.bucketMfaButton.setAction(Foundation.selector((String)"bucketMfaButtonClicked:"));
    }

    public void bucketMfaButtonClicked(NSButton sender) {
        this.bucketVersioningButtonClicked(sender);
    }

    public void setBucketTransferAccelerationButton(NSButton bucketTransferAccelerationButton) {
        this.bucketTransferAccelerationButton = bucketTransferAccelerationButton;
        this.bucketTransferAccelerationButton.setAction(Foundation.selector((String)"bucketTransferAccelerationButtonClicked:"));
    }

    public void bucketTransferAccelerationButtonClicked(NSButton sender) {
        if (this.toggleS3Settings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteTransferAccelerationWorker(this.files, this.bucketTransferAccelerationButton.state() == 1){

                public void cleanup(Boolean done) {
                    super.cleanup((Object)done);
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            }));
        }
    }

    public void setLifecycleTransitionCheckbox(NSButton b) {
        this.lifecycleTransitionCheckbox = b;
        this.lifecycleTransitionCheckbox.setAction(Foundation.selector((String)"lifecyclePopupClicked:"));
    }

    public void setLifecycleTransitionPopup(NSPopUpButton b) {
        this.lifecycleTransitionPopup = b;
        this.lifecycleTransitionPopup.setTarget(this.id());
        for (String option : this.preferences.getList("s3.lifecycle.transition.options")) {
            this.lifecycleTransitionPopup.addItemWithTitle(MessageFormat.format(LocaleFactory.localizedString((String)"after {0} Days", (String)"S3"), option));
            this.lifecycleTransitionPopup.lastItem().setAction(Foundation.selector((String)"lifecyclePopupClicked:"));
            this.lifecycleTransitionPopup.lastItem().setTarget(this.id());
            this.lifecycleTransitionPopup.lastItem().setRepresentedObject(option);
        }
    }

    public void setLifecycleDeleteCheckbox(NSButton b) {
        this.lifecycleDeleteCheckbox = b;
        this.lifecycleDeleteCheckbox.setAction(Foundation.selector((String)"lifecyclePopupClicked:"));
    }

    public void setLifecycleDeletePopup(NSPopUpButton b) {
        this.lifecycleDeletePopup = b;
        for (String option : this.preferences.getList("s3.lifecycle.delete.options")) {
            this.lifecycleDeletePopup.addItemWithTitle(MessageFormat.format(LocaleFactory.localizedString((String)"after {0} Days", (String)"S3"), option));
            this.lifecycleDeletePopup.lastItem().setAction(Foundation.selector((String)"lifecyclePopupClicked:"));
            this.lifecycleDeletePopup.lastItem().setTarget(this.id());
            this.lifecycleDeletePopup.lastItem().setRepresentedObject(option);
        }
    }

    public void lifecyclePopupClicked(NSButton sender) {
        if (this.toggleS3Settings(false)) {
            LifecycleConfiguration configuration = new LifecycleConfiguration(this.lifecycleTransitionCheckbox.state() == 1 ? Integer.valueOf(this.lifecycleTransitionPopup.selectedItem().representedObject()) : null, "GLACIER", this.lifecycleDeleteCheckbox.state() == 1 ? Integer.valueOf(this.lifecycleDeletePopup.selectedItem().representedObject()) : null);
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteLifecycleWorker(this.files, configuration){

                public void cleanup(Boolean result) {
                    InfoController.this.toggleS3Settings(true);
                    InfoController.this.initS3();
                }
            }));
        }
    }

    public void setDistributionCnameField(NSTextField t) {
        this.distributionCnameField = t;
        this.notificationCenter.addObserver(this.id(), Foundation.selector((String)"distributionApplyButtonClicked:"), "NSControlTextDidEndEditingNotification", t.id());
    }

    public void setDistributionOriginField(NSTextField t) {
        this.distributionOriginField = t;
        this.distributionOriginField.setAllowsEditingTextAttributes(true);
        this.distributionOriginField.setSelectable(true);
    }

    public void setDistributionStatusField(NSTextField t) {
        this.distributionStatusField = t;
    }

    public void setDistributionUrlField(NSTextField t) {
        this.distributionUrlField = t;
        this.distributionUrlField.setAllowsEditingTextAttributes(true);
        this.distributionUrlField.setSelectable(true);
    }

    public void setDistributionCnameUrlField(NSTextField t) {
        this.distributionCnameUrlField = t;
        this.distributionCnameUrlField.setAllowsEditingTextAttributes(true);
        this.distributionCnameUrlField.setSelectable(true);
    }

    public void setAclUrlField(NSTextField t) {
        this.aclUrlField = t;
        this.aclUrlField.setAllowsEditingTextAttributes(true);
        this.aclUrlField.setSelectable(true);
    }

    private void setAcl(List<Acl.UserAndRole> permissions) {
        this.acl.clear();
        this.acl.addAll(permissions);
        this.aclTable.reloadData();
    }

    public void setAclTable(NSTableView t) {
        this.aclTable = t;
        this.aclTable.setAllowsMultipleSelection(true);
        this.aclPermissionCellPrototype.setFont(NSFont.systemFontOfSize((double)NSFont.smallSystemFontSize()));
        this.aclPermissionCellPrototype.setControlSize(1);
        this.aclPermissionCellPrototype.setCompletes(false);
        this.aclPermissionCellPrototype.setBordered(false);
        this.aclPermissionCellPrototype.setButtonBordered(false);
        this.aclTable.setColumnAutoresizingStyle(NSTableView.NSTableViewUniformColumnAutoresizingStyle);
        this.aclTable.tableColumnWithIdentifier(AclColumn.PERMISSION.name()).setDataCell((NSCell)this.aclPermissionCellPrototype);
        this.aclTableModel = new ListDataSource(){

            public NSInteger numberOfRowsInTableView(NSTableView view) {
                return new NSInteger((long)InfoController.this.acl.size());
            }

            public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                if (row.intValue() < InfoController.this.acl.size()) {
                    String identifier = tableColumn.identifier();
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row.intValue());
                    if (identifier.equals(AclColumn.GRANTEE.name())) {
                        return NSString.stringWithString((String)grant.getUser().getDisplayName());
                    }
                    if (identifier.equals(AclColumn.PERMISSION.name())) {
                        return NSString.stringWithString((String)grant.getRole().getName());
                    }
                }
                return null;
            }

            public void tableView_setObjectValue_forTableColumn_row(NSTableView view, NSObject value, NSTableColumn c, NSInteger row) {
                if (row.intValue() < InfoController.this.acl.size()) {
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row.intValue());
                    if (c.identifier().equals(AclColumn.GRANTEE.name())) {
                        grant.getUser().setIdentifier(value.toString());
                    }
                    if (c.identifier().equals(AclColumn.PERMISSION.name())) {
                        grant.getRole().setName(value.toString());
                    }
                    if (StringUtils.isNotBlank((CharSequence)grant.getUser().getIdentifier()) && StringUtils.isNotBlank((CharSequence)grant.getRole().getName())) {
                        InfoController.this.aclInputDidEndEditing();
                    }
                }
            }
        };
        this.aclTable.setDataSource(this.aclTableModel.id());
        this.aclTableDelegate = new AbstractTableDelegate<Acl.UserAndRole, AclColumn>(this.aclTable.tableColumnWithIdentifier(AclColumn.GRANTEE.name())){

            public boolean isColumnRowEditable(NSTableColumn column, NSInteger row) {
                if (column.identifier().equals(AclColumn.GRANTEE.name())) {
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row.intValue());
                    return grant.getUser().isEditable();
                }
                if (column.identifier().equals(AclColumn.PERMISSION.name())) {
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row.intValue());
                    return grant.getRole().isEditable();
                }
                return true;
            }

            public void tableRowDoubleClicked(ID sender) {
                this.enterKeyPressed(sender);
            }

            public void enterKeyPressed(ID sender) {
                InfoController.this.aclTable.editRow(InfoController.this.aclTable.columnWithIdentifier(AclColumn.GRANTEE.name()), InfoController.this.aclTable.selectedRow(), true);
            }

            public void deleteKeyPressed(ID sender) {
                InfoController.this.aclRemoveButtonClicked(sender);
            }

            public String tableView_toolTipForCell_rect_tableColumn_row_mouseLocation(NSTableView t, NSCell cell, ID rect, NSTableColumn c, NSInteger row, NSPoint mouseLocation) {
                return this.tooltip((Acl.UserAndRole)InfoController.this.acl.get(row.intValue()), AclColumn.valueOf(c.identifier()));
            }

            public String tooltip(Acl.UserAndRole c, AclColumn column) {
                return c.getUser().getIdentifier();
            }

            public void tableColumnClicked(NSTableView view, NSTableColumn c) {
            }

            public void selectionDidChange(NSNotification notification) {
                InfoController.this.aclRemoveButton.setEnabled(InfoController.this.aclTable.numberOfSelectedRows().intValue() > 0);
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSTextFieldCell cell, NSTableColumn c, NSInteger row) {
                if (c.identifier().equals(AclColumn.GRANTEE.name())) {
                    Acl.UserAndRole grant = (Acl.UserAndRole)InfoController.this.acl.get(row.intValue());
                    cell.setPlaceholderString(grant.getUser().getPlaceholder());
                    if (grant.getUser().isEditable()) {
                        cell.setTextColor(NSColor.controlTextColor());
                    } else {
                        cell.setTextColor(NSColor.disabledControlTextColor());
                    }
                }
            }

            protected boolean isTypeSelectSupported() {
                return false;
            }
        };
        this.aclTable.setDelegate(this.aclTableDelegate.id());
        this.aclTable.sizeToFit();
    }

    public void setAclAddButton(NSPopUpButton b) {
        this.aclAddButton = b;
        this.aclAddButton.setTarget(this.id());
    }

    public void aclAddButtonClicked(NSMenuItem sender) {
        AclPermission feature = (AclPermission)this.session.getFeature(AclPermission.class);
        for (Acl.User grantee : feature.getAvailableAclUsers()) {
            if (!sender.representedObject().equals(grantee.getPlaceholder())) continue;
            this.addAclItem(new Acl.UserAndRole(grantee, new Acl.Role("")));
        }
    }

    private void addAclItem(Acl.UserAndRole update) {
        ArrayList<Acl.UserAndRole> updated = new ArrayList<Acl.UserAndRole>(this.acl);
        int index = updated.size();
        updated.add(index, update);
        this.setAcl(updated);
        this.aclTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)new NSInteger((long)index)), false);
        if (update.getUser().isEditable()) {
            this.aclTable.editRow(this.aclTable.columnWithIdentifier(AclColumn.GRANTEE.name()), new NSInteger((long)index), true);
        } else {
            this.aclTable.editRow(this.aclTable.columnWithIdentifier(AclColumn.PERMISSION.name()), new NSInteger((long)index), true);
        }
    }

    public void setAclRemoveButton(NSButton b) {
        this.aclRemoveButton = b;
        this.aclRemoveButton.setEnabled(false);
        this.aclRemoveButton.setAction(Foundation.selector((String)"aclRemoveButtonClicked:"));
        this.aclRemoveButton.setTarget(this.id());
    }

    public void aclRemoveButtonClicked(ID sender) {
        ArrayList<Acl.UserAndRole> updated = new ArrayList<Acl.UserAndRole>(this.acl);
        NSIndexSet iterator = this.aclTable.selectedRowIndexes();
        ArrayList remove = new ArrayList();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            remove.add(updated.get(index.intValue()));
            index = iterator.indexGreaterThanIndex(index);
        }
        updated.removeAll(remove);
        this.setAcl(updated);
        this.aclInputDidEndEditing();
    }

    private void aclInputDidEndEditing() {
        if (this.toggleAclSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteAclWorker(this.files, new Acl(this.acl.toArray(new Acl.UserAndRole[this.acl.size()])), new PromptRecursiveCallback((WindowController)this), (ProgressListener)this.controller){

                public void cleanup(Boolean v) {
                    InfoController.this.toggleAclSettings(true);
                    InfoController.this.initAcl();
                }
            }));
        }
    }

    private void setMetadata(List<Header> m) {
        this.metadata.clear();
        this.metadata.addAll(m);
        this.metadataTable.reloadData();
    }

    public void setMetadataTable(NSTableView t) {
        this.metadataTable = t;
        this.metadataTable.setAllowsMultipleSelection(true);
        this.metadataTable.setColumnAutoresizingStyle(NSTableView.NSTableViewUniformColumnAutoresizingStyle);
        this.metadataTableModel = new ListDataSource(){

            public NSInteger numberOfRowsInTableView(NSTableView view) {
                return new NSInteger((long)InfoController.this.metadata.size());
            }

            public NSObject tableView_objectValueForTableColumn_row(NSTableView view, NSTableColumn tableColumn, NSInteger row) {
                if (row.intValue() < InfoController.this.metadata.size()) {
                    String identifier = tableColumn.identifier();
                    if (identifier.equals(MetadataColumn.NAME.name())) {
                        String name = ((Header)InfoController.this.metadata.get(row.intValue())).getName();
                        return NSAttributedString.attributedString((String)(StringUtils.isNotEmpty((CharSequence)name) ? name : ""));
                    }
                    if (identifier.equals(MetadataColumn.VALUE.name())) {
                        String value = ((Header)InfoController.this.metadata.get(row.intValue())).getValue();
                        return NSAttributedString.attributedString((String)(value != null ? value : LocaleFactory.localizedString((String)"Multiple files")));
                    }
                }
                return null;
            }

            public void tableView_setObjectValue_forTableColumn_row(NSTableView view, NSObject value, NSTableColumn c, NSInteger row) {
                if (row.intValue() < InfoController.this.metadata.size()) {
                    Header header = (Header)InfoController.this.metadata.get(row.intValue());
                    if (c.identifier().equals(MetadataColumn.NAME.name())) {
                        header.setName(value.toString());
                    }
                    if (c.identifier().equals(MetadataColumn.VALUE.name())) {
                        header.setValue(value.toString());
                    }
                    if (StringUtils.isNotBlank((CharSequence)header.getName()) && StringUtils.isNotBlank((CharSequence)header.getValue())) {
                        InfoController.this.metadataInputDidEndEditing();
                    }
                }
            }
        };
        this.metadataTable.setDataSource(this.metadataTableModel.id());
        this.metadataTableDelegate = new AbstractTableDelegate<String, MetadataColumn>(this.metadataTable.tableColumnWithIdentifier(MetadataColumn.NAME.name())){

            public boolean isColumnRowEditable(NSTableColumn column, NSInteger row) {
                return true;
            }

            public void tableRowDoubleClicked(ID sender) {
                this.enterKeyPressed(sender);
            }

            public void enterKeyPressed(ID sender) {
                InfoController.this.metadataTable.editRow(InfoController.this.metadataTable.columnWithIdentifier(MetadataColumn.VALUE.name()), InfoController.this.metadataTable.selectedRow(), true);
            }

            public void deleteKeyPressed(ID sender) {
                InfoController.this.metadataRemoveButtonClicked(sender);
            }

            public String tooltip(String c, MetadataColumn column) {
                return c;
            }

            public void tableColumnClicked(NSTableView view, NSTableColumn c) {
            }

            public void selectionDidChange(NSNotification notification) {
                InfoController.this.metadataRemoveButton.setEnabled(InfoController.this.metadataTable.numberOfSelectedRows().intValue() > 0);
            }

            protected boolean isTypeSelectSupported() {
                return false;
            }

            public void tableView_willDisplayCell_forTableColumn_row(NSTableView view, NSTextFieldCell cell, NSTableColumn c, NSInteger row) {
                String value;
                if (c.identifier().equals(MetadataColumn.VALUE.name()) && null == (value = ((Header)InfoController.this.metadata.get(row.intValue())).getValue())) {
                    cell.setPlaceholderString(LocaleFactory.localizedString((String)"Multiple files"));
                }
            }
        };
        this.metadataTable.setDelegate(this.metadataTableDelegate.id());
        this.metadataTable.sizeToFit();
    }

    public void setMetadataAddButton(NSPopUpButton b) {
        this.metadataAddButton = b;
        this.metadataAddButton.setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("");
        this.metadataAddButton.lastItem().setImage((NSImage)IconCacheFactory.get().iconNamed("NSActionTemplate"));
        this.metadataAddButton.addItemWithTitle(LocaleFactory.localizedString((String)"Custom Header", (String)"S3"));
        this.metadataAddButton.lastItem().setAction(Foundation.selector((String)"metadataAddCustomClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.menu().addItem(NSMenuItem.separatorItem());
        this.metadataAddButton.addItemWithTitle("Content-Disposition");
        this.metadataAddButton.lastItem().setAction(Foundation.selector((String)"metadataAddContentDispositionClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("Cache-Control");
        this.metadataAddButton.lastItem().setAction(Foundation.selector((String)"metadataAddCacheControlClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("Expires");
        this.metadataAddButton.lastItem().setAction(Foundation.selector((String)"metadataAddExpiresClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("Pragma");
        this.metadataAddButton.lastItem().setAction(Foundation.selector((String)"metadataAddPragmaClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("Content-Type");
        this.metadataAddButton.lastItem().setAction(Foundation.selector((String)"metadataAddContentTypeClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
        this.metadataAddButton.addItemWithTitle("x-amz-website-redirect-location");
        this.metadataAddButton.lastItem().setAction(Foundation.selector((String)"metadataAddRedirectLocationClicked:"));
        this.metadataAddButton.lastItem().setTarget(this.id());
    }

    public void metadataAddCustomClicked(ID sender) {
        this.addMetadataItem();
    }

    public void metadataAddContentDispositionClicked(ID sender) {
        this.addMetadataItem("Content-Disposition", "attachment");
    }

    public void metadataAddCacheControlClicked(ID sender) {
        this.addMetadataItem("Cache-Control", "public,max-age=" + this.preferences.getInteger("s3.cache.seconds"));
    }

    public void metadataAddContentTypeClicked(ID sender) {
        this.addMetadataItem("Content-Type", "", true);
    }

    public void metadataAddRedirectLocationClicked(ID sender) {
        this.addMetadataItem("x-amz-website-redirect-location", "", true);
    }

    public void metadataAddExpiresClicked(ID sender) {
        Calendar time = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        time.add(13, this.preferences.getInteger("s3.cache.seconds"));
        this.addMetadataItem("Expires", new RFC1123DateFormatter().format(time.getTime(), TimeZone.getTimeZone("UTC")));
    }

    public void metadataAddPragmaClicked(ID sender) {
        this.addMetadataItem("Pragma", "", true);
    }

    private void addMetadataItem() {
        this.addMetadataItem("");
    }

    private void addMetadataItem(String name) {
        this.addMetadataItem(name, "", false);
    }

    private void addMetadataItem(String name, String value) {
        this.addMetadataItem(name, value, true);
    }

    private void addMetadataItem(String name, String value, boolean selectValue) {
        int row = this.metadata.size();
        ArrayList<Header> updated = new ArrayList<Header>(this.metadata);
        updated.add(row, new Header(name, value));
        this.setMetadata(updated);
        this.metadataTable.selectRowIndexes(NSIndexSet.indexSetWithIndex((NSInteger)new NSInteger((long)row)), false);
        this.metadataTable.editRow(selectValue ? this.metadataTable.columnWithIdentifier(MetadataColumn.VALUE.name()) : this.metadataTable.columnWithIdentifier(MetadataColumn.NAME.name()), new NSInteger((long)row), true);
    }

    public void setMetadataRemoveButton(NSButton b) {
        this.metadataRemoveButton = b;
        this.metadataRemoveButton.setEnabled(false);
        this.metadataRemoveButton.setAction(Foundation.selector((String)"metadataRemoveButtonClicked:"));
        this.metadataRemoveButton.setTarget(this.id());
    }

    public void metadataRemoveButtonClicked(ID sender) {
        ArrayList<Header> updated = new ArrayList<Header>(this.metadata);
        NSIndexSet iterator = this.metadataTable.selectedRowIndexes();
        ArrayList remove = new ArrayList();
        NSUInteger index = iterator.firstIndex();
        while (!index.equals((Object)NSIndexSet.NSNotFound)) {
            remove.add(updated.get(index.intValue()));
            index = iterator.indexGreaterThanIndex(index);
        }
        updated.removeAll(remove);
        this.setMetadata(updated);
        this.metadataInputDidEndEditing();
    }

    private void metadataInputDidEndEditing() {
        if (this.toggleMetadataSettings(false)) {
            HashMap<String, String> update = new HashMap<String, String>();
            for (Header header : this.metadata) {
                update.put(header.getName(), header.getValue());
            }
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteMetadataWorker(this.files, update, new PromptRecursiveCallback((WindowController)this), (ProgressListener)this.controller){

                public void cleanup(Boolean v) {
                    InfoController.this.toggleMetadataSettings(true);
                    InfoController.this.initMetadata();
                }
            }));
        }
    }

    public void setOwnerr(NSButton ownerr) {
        this.ownerr = ownerr;
        this.ownerr.setTarget(this.id());
        this.ownerr.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.ownerr.setAllowsMixedState(true);
    }

    public void setOwnerw(NSButton ownerw) {
        this.ownerw = ownerw;
        this.ownerw.setTarget(this.id());
        this.ownerw.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.ownerw.setAllowsMixedState(true);
    }

    public void setOwnerx(NSButton ownerx) {
        this.ownerx = ownerx;
        this.ownerx.setTarget(this.id());
        this.ownerx.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.ownerx.setAllowsMixedState(true);
    }

    public void setGroupr(NSButton groupr) {
        this.groupr = groupr;
        this.groupr.setTarget(this.id());
        this.groupr.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.groupr.setAllowsMixedState(true);
    }

    public void setGroupw(NSButton groupw) {
        this.groupw = groupw;
        this.groupw.setTarget(this.id());
        this.groupw.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.groupw.setAllowsMixedState(true);
    }

    public void setGroupx(NSButton groupx) {
        this.groupx = groupx;
        this.groupx.setTarget(this.id());
        this.groupx.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.groupx.setAllowsMixedState(true);
    }

    public void setOtherr(NSButton otherr) {
        this.otherr = otherr;
        this.otherr.setTarget(this.id());
        this.otherr.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.otherr.setAllowsMixedState(true);
    }

    public void setOtherw(NSButton otherw) {
        this.otherw = otherw;
        this.otherw.setTarget(this.id());
        this.otherw.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.otherw.setAllowsMixedState(true);
    }

    public void setOtherx(NSButton otherx) {
        this.otherx = otherx;
        this.otherx.setTarget(this.id());
        this.otherx.setAction(Foundation.selector((String)"permissionSelectionChanged:"));
        this.otherx.setAllowsMixedState(true);
    }

    public void setIconImageView(NSImageView iconImageView) {
        this.iconImageView = iconImageView;
    }

    public void setPanelMetadata(NSView v) {
        this.panelMetadata = v;
    }

    public void setPanelCloud(NSView v) {
        this.panelCloud = v;
    }

    public void setPanelDistribution(NSView v) {
        this.panelDistribution = v;
    }

    public void setPanelPermissions(NSView v) {
        this.panelPermissions = v;
    }

    public void setPanelAcl(NSView v) {
        this.panelAcl = v;
    }

    public void setPanelGeneral(NSView v) {
        this.panelGeneral = v;
    }

    private void initGeneral() {
        int count = this.numberOfFiles();
        if (count > 0) {
            this.filenameField.setStringValue(this.getName());
            Path file = this.getSelected();
            this.filenameField.setEnabled(1 == count && ((Move)this.session.getFeature(Move.class)).isSupported(file, file));
            String path = file.isSymbolicLink() ? file.getSymlinkTarget().getAbsolute() : file.getParent().getAbsolute();
            this.updateField(this.pathField, path, TRUNCATE_MIDDLE_ATTRIBUTES);
            this.pathField.setToolTip(path);
            if (count > 1) {
                this.kindField.setStringValue(String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
                this.checksumField.setStringValue(String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
            } else {
                this.updateField(this.kindField, this.descriptor.getKind(file), TRUNCATE_MIDDLE_ATTRIBUTES);
            }
            if (count > 1) {
                this.modifiedField.setStringValue(String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
                this.createdField.setStringValue(String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
            } else {
                if (-1L == file.attributes().getModificationDate()) {
                    this.updateField(this.modifiedField, LocaleFactory.localizedString((String)"Unknown"));
                } else {
                    this.updateField(this.modifiedField, UserDateFormatterFactory.get().getLongFormat(file.attributes().getModificationDate()), TRUNCATE_MIDDLE_ATTRIBUTES);
                }
                if (-1L == file.attributes().getCreationDate()) {
                    this.updateField(this.createdField, LocaleFactory.localizedString((String)"Unknown"));
                } else {
                    this.updateField(this.createdField, UserDateFormatterFactory.get().getLongFormat(file.attributes().getCreationDate()), TRUNCATE_MIDDLE_ATTRIBUTES);
                }
            }
            this.updateField(this.ownerField, count > 1 ? String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")) : (StringUtils.isBlank((CharSequence)file.attributes().getOwner()) ? LocaleFactory.localizedString((String)"Unknown") : file.attributes().getOwner()), TRUNCATE_MIDDLE_ATTRIBUTES);
            this.updateField(this.groupField, count > 1 ? String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")) : (StringUtils.isBlank((CharSequence)file.attributes().getGroup()) ? LocaleFactory.localizedString((String)"Unknown") : file.attributes().getGroup()), TRUNCATE_MIDDLE_ATTRIBUTES);
            if (count > 1) {
                this.iconImageView.setImage((NSImage)IconCacheFactory.get().iconNamed("NSMultipleDocuments", Integer.valueOf(32)));
            } else if (file.isVolume()) {
                this.iconImageView.setImage((NSImage)IconCacheFactory.get().volumeIcon(this.session.getHost().getProtocol(), Integer.valueOf(32)));
            } else {
                this.iconImageView.setImage((NSImage)IconCacheFactory.get().fileIcon(file, Integer.valueOf(32)));
            }
        }
        this.initSize();
        this.initChecksum();
        this.initWebUrl();
    }

    private void initWebUrl() {
        if (this.numberOfFiles() > 1) {
            this.updateField(this.webUrlField, String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
            this.webUrlField.setToolTip("");
        } else {
            this.updateField(this.webUrlField, LocaleFactory.localizedString((String)"Unknown"));
            Path file = this.getSelected();
            DescriptiveUrl http = ((UrlProvider)this.session.getFeature(UrlProvider.class)).toUrl(file).find(DescriptiveUrl.Type.http);
            if (!http.equals((Object)DescriptiveUrl.EMPTY)) {
                this.webUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((DescriptiveUrl)http));
                this.webUrlField.setToolTip(LocaleFactory.localizedString((String)"Open in Web Browser"));
            }
        }
    }

    private void initPermissions() {
        this.permissionsField.setStringValue(LocaleFactory.localizedString((String)"Unknown"));
        if (this.togglePermissionSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new ReadPermissionWorker(this.files){

                public void cleanup(PermissionOverwrite permissions) {
                    InfoController.this.setPermissions(permissions);
                    InfoController.this.togglePermissionSettings(true);
                }
            }));
        }
    }

    private void setPermissions(PermissionOverwrite permissions) {
        this.updateCheckbox(this.ownerr, permissions.user.read);
        this.updateCheckbox(this.ownerw, permissions.user.write);
        this.updateCheckbox(this.ownerx, permissions.user.execute);
        this.updateCheckbox(this.groupr, permissions.group.read);
        this.updateCheckbox(this.groupw, permissions.group.write);
        this.updateCheckbox(this.groupx, permissions.group.execute);
        this.updateCheckbox(this.otherr, permissions.other.read);
        this.updateCheckbox(this.otherw, permissions.other.write);
        this.updateCheckbox(this.otherx, permissions.other.execute);
        if (this.numberOfFiles() > 1) {
            this.permissionsField.setStringValue(permissions.toString());
            this.octalField.setStringValue(permissions.getMode());
        } else {
            Permission permission = permissions.resolve(Permission.EMPTY);
            this.permissionsField.setStringValue(permission.toString());
            this.octalField.setStringValue(permission.getMode());
        }
    }

    private void updateCheckbox(NSButton checkbox, Boolean enabled) {
        checkbox.setState(enabled != null ? (enabled.booleanValue() ? 1 : 0) : -1);
        checkbox.setEnabled(true);
    }

    private void initDistribution() {
        this.distributionStatusField.setStringValue(LocaleFactory.localizedString((String)"Unknown"));
        this.distributionCnameField.cell().setPlaceholderString(LocaleFactory.localizedString((String)"None"));
        this.distributionOriginField.setStringValue(LocaleFactory.localizedString((String)"Unknown"));
        this.distributionUrlField.setStringValue(LocaleFactory.localizedString((String)"Unknown"));
        this.distributionInvalidationStatusField.setStringValue(LocaleFactory.localizedString((String)"None"));
        String selected = this.distributionDeliveryPopup.titleOfSelectedItem();
        this.distributionDeliveryPopup.removeAllItems();
        this.distributionDeliveryPopup.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.distributionDefaultRootPopup.removeAllItems();
        this.distributionDefaultRootPopup.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.distributionDefaultRootPopup.menu().addItem(NSMenuItem.separatorItem());
        Path file = this.getSelected();
        DistributionConfiguration cdn = (DistributionConfiguration)this.session.getFeature(DistributionConfiguration.class);
        this.distributionEnableButton.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Enable {0} Distribution", (String)"Status"), cdn.getName()));
        this.distributionDeliveryPopup.removeItemWithTitle(LocaleFactory.localizedString((String)"None"));
        for (Distribution.Method method : cdn.getMethods(file)) {
            this.distributionDeliveryPopup.addItemWithTitle(method.toString());
            this.distributionDeliveryPopup.itemWithTitle(method.toString()).setRepresentedObject(method.toString());
        }
        this.distributionDeliveryPopup.selectItemWithTitle(selected);
        if (null == this.distributionDeliveryPopup.selectedItem()) {
            Distribution.Method method = (Distribution.Method)cdn.getMethods(file).iterator().next();
            this.distributionDeliveryPopup.selectItemWithTitle(method.toString());
        }
        this.distributionLoggingPopup.removeAllItems();
        this.distributionLoggingPopup.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.distributionLoggingPopup.itemWithTitle(LocaleFactory.localizedString((String)"None")).setEnabled(false);
        this.distributionAnalyticsSetupUrlField.setStringValue(LocaleFactory.localizedString((String)"None"));
        this.distributionStatusButtonClicked(null);
    }

    private void initSize() {
        if (this.toggleSizeSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new ReadSizeWorker(this.files){

                public void cleanup(Long size) {
                    InfoController.this.setSize(size);
                    InfoController.this.toggleSizeSettings(true);
                }
            }));
        }
    }

    private void setSize(Long size) {
        this.sizeField.setAttributedStringValue(NSAttributedString.attributedStringWithAttributes((String)SizeFormatterFactory.get().format(size.longValue(), true), (NSDictionary)TRUNCATE_MIDDLE_ATTRIBUTES));
    }

    private void initChecksum() {
        if (this.numberOfFiles() > 1) {
            this.checksumField.setStringValue(String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
        } else {
            Path file = this.getSelected();
            Checksum checksum = file.attributes().getChecksum();
            if (Checksum.NONE == checksum) {
                this.checksumField.setStringValue(LocaleFactory.localizedString((String)"Unknown"));
            } else {
                this.updateField(this.checksumField, checksum.hash, TRUNCATE_MIDDLE_ATTRIBUTES);
            }
        }
    }

    private boolean toggleS3Settings(boolean stop) {
        boolean enable;
        this.window().endEditingFor(null);
        Credentials credentials = this.session.getHost().getCredentials();
        boolean bl = enable = this.session.getHost().getProtocol().getType() == Protocol.Type.s3 || this.session.getHost().getProtocol().getType() == Protocol.Type.b2 || this.session.getHost().getProtocol().getType() == Protocol.Type.azure || this.session.getHost().getProtocol().getType() == Protocol.Type.googlestorage;
        if (enable) {
            enable = !credentials.isAnonymousLogin();
        }
        boolean logging = false;
        boolean analytics = false;
        boolean versioning = false;
        boolean storageclass = false;
        boolean encryption = false;
        boolean lifecycle = false;
        boolean acceleration = false;
        if (enable) {
            logging = this.session.getFeature(Logging.class) != null;
            analytics = this.session.getFeature(AnalyticsProvider.class) != null;
            versioning = this.session.getFeature(Versioning.class) != null;
            lifecycle = this.session.getFeature(Lifecycle.class) != null;
            encryption = this.session.getFeature(Encryption.class) != null;
            storageclass = this.session.getFeature(Redundancy.class) != null;
            acceleration = this.session.getFeature(TransferAcceleration.class) != null;
        }
        this.storageClassPopup.setEnabled(stop && enable && storageclass);
        this.encryptionPopup.setEnabled(stop && enable && encryption);
        this.bucketVersioningButton.setEnabled(stop && enable && versioning);
        this.bucketMfaButton.setEnabled(stop && enable && versioning && this.bucketVersioningButton.state() == 1);
        this.bucketTransferAccelerationButton.setEnabled(stop && enable && acceleration);
        this.bucketLoggingButton.setEnabled(stop && enable && logging);
        this.bucketLoggingPopup.setEnabled(stop && enable && logging);
        if (analytics && Objects.equals(((IdentityConfiguration)this.session.getFeature(IdentityConfiguration.class)).getCredentials(((AnalyticsProvider)this.session.getFeature(AnalyticsProvider.class)).getName()), credentials)) {
            this.bucketAnalyticsButton.setEnabled(false);
        } else {
            this.bucketAnalyticsButton.setEnabled(stop && enable && analytics);
        }
        this.lifecycleDeletePopup.setEnabled(stop && enable && lifecycle);
        this.lifecycleDeleteCheckbox.setEnabled(stop && enable && lifecycle);
        this.lifecycleTransitionPopup.setEnabled(stop && enable && lifecycle);
        this.lifecycleTransitionCheckbox.setEnabled(stop && enable && lifecycle);
        if (stop) {
            this.s3Progress.stopAnimation(null);
        } else if (enable) {
            this.s3Progress.startAnimation(null);
        }
        return enable;
    }

    private void initS3() {
        this.bucketLocationField.setStringValue(LocaleFactory.localizedString((String)"Unknown"));
        this.bucketAnalyticsSetupUrlField.setStringValue(LocaleFactory.localizedString((String)"None"));
        this.bucketLoggingPopup.removeAllItems();
        this.bucketLoggingPopup.addItemWithTitle(LocaleFactory.localizedString((String)"None"));
        this.bucketLoggingPopup.lastItem().setEnabled(false);
        this.storageClassPopup.removeAllItems();
        this.storageClassPopup.addItemWithTitle(LocaleFactory.localizedString((String)"Unknown"));
        this.storageClassPopup.lastItem().setEnabled(false);
        this.storageClassPopup.selectItem(this.storageClassPopup.lastItem());
        this.encryptionPopup.removeAllItems();
        this.encryptionPopup.addItemWithTitle(LocaleFactory.localizedString((String)"Unknown"));
        this.encryptionPopup.lastItem().setEnabled(false);
        this.encryptionPopup.selectItem(this.encryptionPopup.lastItem());
        if (this.toggleS3Settings(false)) {
            final Path file = this.getSelected();
            if (this.session.getFeature(Redundancy.class) != null) {
                for (String redundancy : ((Redundancy)this.session.getFeature(Redundancy.class)).getClasses()) {
                    this.storageClassPopup.addItemWithTitle(LocaleFactory.localizedString((String)redundancy, (String)"S3"));
                    this.storageClassPopup.lastItem().setRepresentedObject(redundancy);
                }
            }
            this.controller.background((BackgroundAction)new RegistryBackgroundAction<Void>(this.controller, this.session){
                Location.Name location;
                LoggingConfiguration logging;
                VersioningConfiguration versioning;
                Set<Encryption.Algorithm> managedEncryptionKeys;
                final Set<Encryption.Algorithm> selectedEncryptionKeys;
                final Set<String> selectedStorageClasses;
                LifecycleConfiguration lifecycle;
                Credentials credentials;
                Boolean transferAcceleration;
                {
                    super(x0, x1);
                    this.managedEncryptionKeys = new HashSet<Encryption.Algorithm>();
                    this.selectedEncryptionKeys = new HashSet<Encryption.Algorithm>();
                    this.selectedStorageClasses = new HashSet<String>();
                }

                public Void run(Session<?> session) throws BackgroundException {
                    if (session.getFeature(Location.class) != null) {
                        this.location = ((Location)session.getFeature(Location.class)).getLocation(file);
                    }
                    if (session.getFeature(Logging.class) != null) {
                        this.logging = ((Logging)session.getFeature(Logging.class)).getConfiguration(file);
                    }
                    if (session.getFeature(Versioning.class) != null) {
                        this.versioning = ((Versioning)session.getFeature(Versioning.class)).getConfiguration(file);
                    }
                    if (session.getFeature(Lifecycle.class) != null) {
                        this.lifecycle = ((Lifecycle)session.getFeature(Lifecycle.class)).getConfiguration(file);
                    }
                    if (session.getFeature(AnalyticsProvider.class) != null && session.getFeature(IdentityConfiguration.class) != null) {
                        this.credentials = ((IdentityConfiguration)session.getFeature(IdentityConfiguration.class)).getCredentials(((AnalyticsProvider)session.getFeature(AnalyticsProvider.class)).getName());
                    }
                    if (session.getFeature(Redundancy.class) != null) {
                        for (Path f : InfoController.this.files) {
                            this.selectedStorageClasses.add(((Redundancy)session.getFeature(Redundancy.class)).getClass(f));
                        }
                    }
                    if (session.getFeature(Encryption.class) != null) {
                        this.managedEncryptionKeys = ((Encryption)session.getFeature(Encryption.class)).getKeys(file, InfoController.this.prompt);
                        for (Path f : InfoController.this.files) {
                            this.selectedEncryptionKeys.add(((Encryption)session.getFeature(Encryption.class)).getEncryption(f));
                        }
                        this.managedEncryptionKeys.addAll(this.selectedEncryptionKeys);
                    }
                    if (session.getFeature(TransferAcceleration.class) != null) {
                        this.transferAcceleration = ((TransferAcceleration)session.getFeature(TransferAcceleration.class)).getStatus(file);
                    }
                    return null;
                }

                public void cleanup() {
                    super.cleanup();
                    if (this.logging != null) {
                        InfoController.this.bucketLoggingButton.setState(this.logging.isEnabled() ? 1 : 0);
                        if (!this.logging.getContainers().isEmpty()) {
                            InfoController.this.bucketLoggingPopup.removeAllItems();
                        }
                        for (Path c : this.logging.getContainers()) {
                            InfoController.this.bucketLoggingPopup.addItemWithTitle(c.getName());
                            InfoController.this.bucketLoggingPopup.lastItem().setRepresentedObject(c.getName());
                        }
                        if (this.logging.isEnabled()) {
                            InfoController.this.bucketLoggingPopup.selectItemWithTitle(this.logging.getLoggingTarget());
                        } else {
                            InfoController.this.bucketLoggingPopup.selectItemAtIndex(InfoController.this.bucketLoggingPopup.indexOfItemWithRepresentedObject(InfoController.this.containerService.getContainer(file).getName()));
                        }
                    }
                    if (this.location != null) {
                        InfoController.this.bucketLocationField.setStringValue(this.location.toString());
                    }
                    if (this.versioning != null) {
                        InfoController.this.bucketVersioningButton.setState(this.versioning.isEnabled() ? 1 : 0);
                        InfoController.this.bucketMfaButton.setState(this.versioning.isMultifactor() ? 1 : 0);
                    }
                    for (Encryption.Algorithm algorithm : this.managedEncryptionKeys) {
                        InfoController.this.encryptionPopup.addItemWithTitle(LocaleFactory.localizedString((String)algorithm.getDescription(), (String)"S3"));
                        InfoController.this.encryptionPopup.lastItem().setRepresentedObject(algorithm.toString());
                    }
                    if (!this.selectedEncryptionKeys.isEmpty()) {
                        InfoController.this.encryptionPopup.selectItemAtIndex(new NSInteger(-1L));
                        if (-1 != InfoController.this.encryptionPopup.indexOfItemWithTitle(LocaleFactory.localizedString((String)"Unknown")).intValue()) {
                            InfoController.this.encryptionPopup.removeItemWithTitle(LocaleFactory.localizedString((String)"Unknown"));
                        }
                    }
                    for (Encryption.Algorithm algorithm : this.selectedEncryptionKeys) {
                        InfoController.this.encryptionPopup.selectItemAtIndex(InfoController.this.encryptionPopup.indexOfItemWithRepresentedObject(algorithm.toString()));
                    }
                    for (Encryption.Algorithm algorithm : this.selectedEncryptionKeys) {
                        InfoController.this.encryptionPopup.itemAtIndex(InfoController.this.encryptionPopup.indexOfItemWithRepresentedObject(algorithm.toString())).setState(this.selectedEncryptionKeys.size() == 1 ? 1 : -1);
                    }
                    if (!this.selectedStorageClasses.isEmpty()) {
                        InfoController.this.storageClassPopup.selectItemAtIndex(new NSInteger(-1L));
                        if (-1 != InfoController.this.storageClassPopup.indexOfItemWithTitle(LocaleFactory.localizedString((String)"Unknown")).intValue()) {
                            InfoController.this.storageClassPopup.removeItemWithTitle(LocaleFactory.localizedString((String)"Unknown"));
                        }
                    }
                    for (String storageClass : this.selectedStorageClasses) {
                        InfoController.this.storageClassPopup.selectItemAtIndex(InfoController.this.storageClassPopup.indexOfItemWithRepresentedObject(storageClass));
                    }
                    for (String storageClass : this.selectedStorageClasses) {
                        InfoController.this.storageClassPopup.itemAtIndex(InfoController.this.storageClassPopup.indexOfItemWithRepresentedObject(storageClass)).setState(this.selectedStorageClasses.size() == 1 ? 1 : -1);
                    }
                    if (null != this.credentials) {
                        InfoController.this.bucketAnalyticsSetupUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((DescriptiveUrl)((AnalyticsProvider)InfoController.this.session.getFeature(AnalyticsProvider.class)).getSetup(InfoController.this.session.getHost().getProtocol().getDefaultHostname(), InfoController.this.session.getHost().getProtocol().getScheme(), file, this.credentials)));
                    }
                    InfoController.this.bucketAnalyticsButton.setState(null != this.credentials ? 1 : 0);
                    if (this.lifecycle != null) {
                        NSInteger index;
                        InfoController.this.lifecycleDeleteCheckbox.setState(this.lifecycle.getExpiration() != null ? 1 : 0);
                        if (this.lifecycle.getExpiration() != null) {
                            index = InfoController.this.lifecycleDeletePopup.indexOfItemWithRepresentedObject(String.valueOf(this.lifecycle.getExpiration()));
                            if (-1 == index.intValue()) {
                                InfoController.this.lifecycleDeletePopup.addItemWithTitle(MessageFormat.format(LocaleFactory.localizedString((String)"after {0} Days", (String)"S3"), String.valueOf(this.lifecycle.getExpiration())));
                                InfoController.this.lifecycleDeletePopup.lastItem().setAction(Foundation.selector((String)"lifecyclePopupClicked:"));
                                InfoController.this.lifecycleDeletePopup.lastItem().setTarget(InfoController.this.id());
                                InfoController.this.lifecycleDeletePopup.lastItem().setRepresentedObject(String.valueOf(this.lifecycle.getExpiration()));
                            }
                            InfoController.this.lifecycleDeletePopup.selectItemAtIndex(InfoController.this.lifecycleDeletePopup.indexOfItemWithRepresentedObject(String.valueOf(this.lifecycle.getExpiration())));
                        }
                        InfoController.this.lifecycleTransitionCheckbox.setState(this.lifecycle.getTransition() != null ? 1 : 0);
                        if (this.lifecycle.getTransition() != null) {
                            index = InfoController.this.lifecycleTransitionPopup.indexOfItemWithRepresentedObject(String.valueOf(this.lifecycle.getTransition()));
                            if (-1 == index.intValue()) {
                                InfoController.this.lifecycleTransitionPopup.addItemWithTitle(MessageFormat.format(LocaleFactory.localizedString((String)"after {0} Days", (String)"S3"), String.valueOf(this.lifecycle.getTransition())));
                                InfoController.this.lifecycleTransitionPopup.lastItem().setAction(Foundation.selector((String)"lifecyclePopupClicked:"));
                                InfoController.this.lifecycleTransitionPopup.lastItem().setTarget(InfoController.this.id());
                                InfoController.this.lifecycleTransitionPopup.lastItem().setRepresentedObject(String.valueOf(this.lifecycle.getTransition()));
                            }
                            InfoController.this.lifecycleTransitionPopup.selectItemAtIndex(InfoController.this.lifecycleTransitionPopup.indexOfItemWithRepresentedObject(String.valueOf(this.lifecycle.getTransition())));
                        }
                    }
                    if (this.transferAcceleration != null) {
                        InfoController.this.bucketTransferAccelerationButton.setState(this.transferAcceleration != false ? 1 : 0);
                    }
                    InfoController.this.toggleS3Settings(true);
                }

                public String getActivity() {
                    return MessageFormat.format(LocaleFactory.localizedString((String)"Reading metadata of {0}", (String)"Status"), this.toString(InfoController.this.files));
                }
            });
        }
    }

    private boolean toggleAclSettings(boolean stop) {
        this.window().endEditingFor(null);
        Credentials credentials = this.session.getHost().getCredentials();
        boolean enable = !credentials.isAnonymousLogin() && this.session.getFeature(AclPermission.class) != null;
        this.aclTable.setEnabled(stop && enable);
        this.aclAddButton.setEnabled(stop && enable);
        boolean selection = this.aclTable.selectedRowIndexes().count().intValue() > 0;
        this.aclRemoveButton.setEnabled(stop && enable && selection);
        if (stop) {
            this.aclProgress.stopAnimation(null);
        } else if (enable) {
            this.aclProgress.startAnimation(null);
        }
        return enable;
    }

    private boolean toggleMetadataSettings(boolean stop) {
        this.window().endEditingFor(null);
        Credentials credentials = this.session.getHost().getCredentials();
        boolean enable = !credentials.isAnonymousLogin() && this.session.getFeature(Metadata.class) != null;
        this.metadataTable.setEnabled(stop && enable);
        this.metadataAddButton.setEnabled(stop && enable);
        boolean selection = this.metadataTable.selectedRowIndexes().count().intValue() > 0;
        this.metadataRemoveButton.setEnabled(stop && enable && selection);
        if (stop) {
            this.metadataProgress.stopAnimation(null);
        } else if (enable) {
            this.metadataProgress.startAnimation(null);
        }
        return enable;
    }

    private void initMetadata() {
        this.setMetadata(Collections.emptyList());
        if (this.toggleMetadataSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new ReadMetadataWorker(this.files){

                public void cleanup(Map<String, String> updated) {
                    ArrayList<Header> m = new ArrayList<Header>();
                    if (updated != null) {
                        for (Map.Entry<String, String> key : updated.entrySet()) {
                            m.add(new Header(key.getKey(), key.getValue()));
                        }
                    }
                    InfoController.this.setMetadata(m);
                    InfoController.this.toggleMetadataSettings(true);
                }
            }));
        }
    }

    private void initAcl() {
        this.setAcl(Collections.emptyList());
        this.aclUrlField.setStringValue(LocaleFactory.localizedString((String)"None"));
        if (this.toggleAclSettings(false)) {
            AclPermission feature = (AclPermission)this.session.getFeature(AclPermission.class);
            this.aclAddButton.removeAllItems();
            this.aclAddButton.addItemWithTitle("");
            this.aclAddButton.lastItem().setImage((NSImage)IconCacheFactory.get().iconNamed("NSActionTemplate"));
            for (Acl.User user : feature.getAvailableAclUsers()) {
                this.aclAddButton.addItemWithTitle(user.getPlaceholder());
                this.aclAddButton.lastItem().setAction(Foundation.selector((String)"aclAddButtonClicked:"));
                this.aclAddButton.lastItem().setTarget(this.id());
                this.aclAddButton.lastItem().setRepresentedObject(user.getPlaceholder());
            }
            this.aclPermissionCellPrototype.removeAllItems();
            for (Acl.Role permission : feature.getAvailableAclRoles(this.files)) {
                this.aclPermissionCellPrototype.addItemWithObjectValue((ObjCObject)NSString.stringWithString((String)permission.getName()));
            }
            if (this.numberOfFiles() > 1) {
                this.aclUrlField.setStringValue(String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
                this.aclUrlField.setToolTip("");
            } else {
                for (Path file : this.files) {
                    DescriptiveUrl authenticated;
                    if (!file.isFile() || (authenticated = ((UrlProvider)this.session.getFeature(UrlProvider.class)).toUrl(file).find(DescriptiveUrl.Type.authenticated)).equals((Object)DescriptiveUrl.EMPTY)) continue;
                    this.aclUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((DescriptiveUrl)authenticated));
                    this.aclUrlField.setToolTip(authenticated.getHelp());
                }
            }
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new ReadAclWorker(this.files){

                public void cleanup(List<Acl.UserAndRole> updated) {
                    if (updated != null) {
                        InfoController.this.setAcl(updated);
                    }
                    InfoController.this.toggleAclSettings(true);
                }
            }));
        }
    }

    private int numberOfFiles() {
        return null == this.files ? 0 : this.files.size();
    }

    public void octalPermissionsInputDidEndEditing(NSNotification sender) {
        Permission permission = this.getPermissionFromOctalField();
        if (null == permission) {
            AppKitFunctionsLibrary.beep();
            this.initPermissions();
        } else if (this.togglePermissionSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WritePermissionWorker(this.files, permission, (Worker.RecursiveCallback)new BooleanRecursiveCallback(false), (ProgressListener)this.controller){

                public void cleanup(Boolean done) {
                    InfoController.this.togglePermissionSettings(true);
                    InfoController.this.initPermissions();
                }
            }));
        }
    }

    private Permission getPermissionFromOctalField() {
        if (StringUtils.isNotBlank((CharSequence)this.octalField.stringValue()) && StringUtils.length((CharSequence)this.octalField.stringValue()) >= 3 && StringUtils.isNumeric((CharSequence)this.octalField.stringValue())) {
            return new Permission(Integer.valueOf(this.octalField.stringValue()).intValue());
        }
        log.warn((Object)String.format("Invalid octal field input %s", this.octalField.stringValue()));
        return null;
    }

    public void recursiveButtonClicked(NSButton sender) {
        Permission permission = this.getPermissionFromOctalField();
        if (null == permission) {
            AppKitFunctionsLibrary.beep();
            this.initPermissions();
        } else if (this.togglePermissionSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WritePermissionWorker(this.files, permission, new PromptRecursiveCallback((WindowController)this), (ProgressListener)this.controller){

                public void cleanup(Boolean done) {
                    InfoController.this.togglePermissionSettings(true);
                    InfoController.this.initPermissions();
                }
            }));
        }
    }

    public void permissionSelectionChanged(NSButton sender) {
        if (sender.state() == -1) {
            sender.setState(1);
        }
        PermissionOverwrite permission = new PermissionOverwrite(new PermissionOverwrite.Action(Boolean.valueOf(this.ownerr.state() == 1), Boolean.valueOf(this.ownerw.state() == 1), Boolean.valueOf(this.ownerx.state() == 1)), new PermissionOverwrite.Action(Boolean.valueOf(this.groupr.state() == 1), Boolean.valueOf(this.groupw.state() == 1), Boolean.valueOf(this.groupx.state() == 1)), new PermissionOverwrite.Action(Boolean.valueOf(this.otherr.state() == 1), Boolean.valueOf(this.otherw.state() == 1), Boolean.valueOf(this.otherx.state() == 1)));
        if (this.togglePermissionSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WritePermissionWorker(this.files, permission, (Worker.RecursiveCallback)new BooleanRecursiveCallback(false), (ProgressListener)this.controller){

                public void cleanup(Boolean done) {
                    InfoController.this.togglePermissionSettings(true);
                    InfoController.this.initPermissions();
                }
            }));
        }
    }

    private boolean togglePermissionSettings(boolean stop) {
        this.window().endEditingFor(null);
        Credentials credentials = this.session.getHost().getCredentials();
        boolean enable = !credentials.isAnonymousLogin() && this.session.getFeature(UnixPermission.class) != null;
        this.recursiveButton.setEnabled(stop && enable);
        for (Path next : this.files) {
            if (!next.isFile()) continue;
            this.recursiveButton.setEnabled(false);
            break;
        }
        this.octalField.setEnabled(stop && enable);
        this.ownerr.setEnabled(stop && enable);
        this.ownerw.setEnabled(stop && enable);
        this.ownerx.setEnabled(stop && enable);
        this.groupr.setEnabled(stop && enable);
        this.groupw.setEnabled(stop && enable);
        this.groupx.setEnabled(stop && enable);
        this.otherr.setEnabled(stop && enable);
        this.otherw.setEnabled(stop && enable);
        this.otherx.setEnabled(stop && enable);
        if (stop) {
            this.permissionProgress.stopAnimation(null);
        } else if (enable) {
            this.permissionProgress.startAnimation(null);
        }
        return enable;
    }

    private boolean toggleDistributionSettings(boolean stop) {
        this.window().endEditingFor(null);
        Credentials credentials = this.session.getHost().getCredentials();
        DistributionConfiguration cdn = (DistributionConfiguration)this.session.getFeature(DistributionConfiguration.class);
        boolean enable = !credentials.isAnonymousLogin() && cdn != null;
        Path file = this.getSelected();
        Path container = this.containerService.getContainer(file);
        if (enable) {
            for (Path next : this.files) {
                if (this.containerService.getContainer(next).equals((Object)container)) continue;
                enable = false;
                break;
            }
        }
        Distribution.Method method = Distribution.Method.forName((String)this.distributionDeliveryPopup.selectedItem().representedObject());
        this.distributionEnableButton.setEnabled(stop && enable);
        this.distributionDeliveryPopup.setEnabled(stop && enable);
        this.distributionLoggingButton.setEnabled(stop && enable && cdn.getFeature(DistributionLogging.class, method) != null);
        if (enable) {
            AnalyticsProvider analyticsFeature = (AnalyticsProvider)cdn.getFeature(AnalyticsProvider.class, method);
            IdentityConfiguration identityFeature = (IdentityConfiguration)cdn.getFeature(IdentityConfiguration.class, method);
            if (null == analyticsFeature || null == identityFeature) {
                this.distributionAnalyticsButton.setEnabled(false);
            } else if (Objects.equals(identityFeature.getCredentials(analyticsFeature.getName()), credentials)) {
                this.distributionAnalyticsButton.setEnabled(false);
            } else {
                this.distributionAnalyticsButton.setEnabled(stop);
            }
        } else {
            this.distributionAnalyticsButton.setEnabled(false);
        }
        this.distributionLoggingPopup.setEnabled(stop && enable && cdn.getFeature(DistributionLogging.class, method) != null);
        this.distributionCnameField.setEnabled(stop && enable && cdn.getFeature(Cname.class, method) != null);
        this.distributionInvalidateObjectsButton.setEnabled(stop && enable && cdn.getFeature(Purge.class, method) != null);
        this.distributionDefaultRootPopup.setEnabled(stop && enable && cdn.getFeature(Index.class, method) != null);
        if (stop) {
            this.distributionProgress.stopAnimation(null);
        } else if (enable) {
            this.distributionProgress.startAnimation(null);
        }
        return enable;
    }

    public void distributionInvalidateObjectsButtonClicked(final ID sender) {
        if (this.toggleDistributionSettings(false)) {
            Distribution.Method method = Distribution.Method.forName((String)this.distributionDeliveryPopup.selectedItem().representedObject());
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new DistributionPurgeWorker(this.files, this.prompt, method){

                public void cleanup(Boolean result) {
                    InfoController.this.distributionStatusButtonClicked(sender);
                }
            }));
        }
    }

    public void distributionLoggingPopupClicked(ID sender) {
        if (this.distributionLoggingButton.state() == 1) {
            this.distributionApplyButtonClicked(sender);
        }
    }

    public void distributionApplyButtonClicked(final ID sender) {
        if (this.toggleDistributionSettings(false)) {
            Distribution.Method method = Distribution.Method.forName((String)this.distributionDeliveryPopup.selectedItem().representedObject());
            Distribution configuration = new Distribution(method, this.distributionEnableButton.state() == 1);
            configuration.setIndexDocument(this.distributionDefaultRootPopup.selectedItem().representedObject());
            configuration.setLogging(this.distributionLoggingButton.state() == 1);
            configuration.setLoggingContainer(this.distributionLoggingPopup.selectedItem().representedObject());
            configuration.setCNAMEs(StringUtils.split((String)this.distributionCnameField.stringValue()));
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteDistributionWorker(this.files, this.prompt, configuration){

                public void cleanup(Boolean result) {
                    InfoController.this.distributionStatusButtonClicked(sender);
                }
            }));
        }
    }

    public void distributionStatusButtonClicked(ID sender) {
        if (this.toggleDistributionSettings(false)) {
            final Path file = this.getSelected();
            final Distribution.Method method = Distribution.Method.forName((String)this.distributionDeliveryPopup.selectedItem().representedObject());
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new ReadDistributionWorker(this.files, this.prompt, method){

                public void cleanup(Distribution distribution) {
                    DescriptiveUrl origin;
                    DistributionConfiguration cdn = (DistributionConfiguration)InfoController.this.session.getFeature(DistributionConfiguration.class);
                    InfoController.this.distributionEnableButton.setTitle(MessageFormat.format(LocaleFactory.localizedString((String)"Enable {0} Distribution", (String)"Status"), cdn.getName(distribution.getMethod())));
                    InfoController.this.distributionEnableButton.setState(distribution.isEnabled() ? 1 : 0);
                    InfoController.this.distributionStatusField.setAttributedStringValue((NSAttributedString)NSMutableAttributedString.create((String)distribution.getStatus(), (NSDictionary)BundleController.TRUNCATE_MIDDLE_ATTRIBUTES));
                    InfoController.this.distributionLoggingButton.setState(distribution.isLogging() ? 1 : 0);
                    List containers = distribution.getContainers();
                    if (!containers.isEmpty()) {
                        InfoController.this.distributionLoggingPopup.removeAllItems();
                    }
                    for (Path c : containers) {
                        InfoController.this.distributionLoggingPopup.addItemWithTitle(c.getName());
                        InfoController.this.distributionLoggingPopup.lastItem().setRepresentedObject(c.getName());
                    }
                    if (StringUtils.isNotBlank((CharSequence)distribution.getLoggingContainer())) {
                        InfoController.this.distributionLoggingPopup.selectItemWithTitle(distribution.getLoggingContainer());
                    } else if (InfoController.this.distributionLoggingPopup.itemWithTitle(this.containerService.getContainer(file).getName()) != null) {
                        InfoController.this.distributionLoggingPopup.selectItemWithTitle(this.containerService.getContainer(file).getName());
                    }
                    if (null == InfoController.this.distributionLoggingPopup.selectedItem()) {
                        InfoController.this.distributionLoggingPopup.selectItemWithTitle(LocaleFactory.localizedString((String)"None"));
                    }
                    AnalyticsProvider analyticsFeature = (AnalyticsProvider)cdn.getFeature(AnalyticsProvider.class, method);
                    IdentityConfiguration identityFeature = (IdentityConfiguration)cdn.getFeature(IdentityConfiguration.class, method);
                    if (analyticsFeature != null && identityFeature != null) {
                        Credentials credentials = identityFeature.getCredentials(analyticsFeature.getName());
                        InfoController.this.distributionAnalyticsButton.setState(credentials != null ? 1 : 0);
                        if (credentials != null) {
                            InfoController.this.distributionAnalyticsSetupUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((DescriptiveUrl)analyticsFeature.getSetup(cdn.getHostname(), distribution.getMethod().getScheme(), file, credentials)));
                        }
                    }
                    if (!(origin = cdn.toUrl(file).find(DescriptiveUrl.Type.origin)).equals((Object)DescriptiveUrl.EMPTY)) {
                        InfoController.this.distributionOriginField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((DescriptiveUrl)origin));
                    }
                    if (InfoController.this.numberOfFiles() > 1) {
                        InfoController.this.distributionUrlField.setStringValue(String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
                        InfoController.this.distributionUrlField.setToolTip("");
                        InfoController.this.distributionCnameUrlField.setStringValue(String.format("(%s)", LocaleFactory.localizedString((String)"Multiple files")));
                    } else {
                        DescriptiveUrl url = cdn.toUrl(file).find(DescriptiveUrl.Type.cdn);
                        if (!url.equals((Object)DescriptiveUrl.EMPTY)) {
                            InfoController.this.distributionUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((DescriptiveUrl)url));
                            InfoController.this.distributionUrlField.setToolTip(LocaleFactory.localizedString((String)"CDN URL"));
                        } else {
                            InfoController.this.distributionUrlField.setStringValue(LocaleFactory.localizedString((String)"None"));
                            InfoController.this.distributionUrlField.setToolTip("");
                        }
                    }
                    Object[] cnames = distribution.getCNAMEs();
                    if (0 == cnames.length) {
                        InfoController.this.distributionCnameField.setStringValue("");
                        InfoController.this.distributionCnameUrlField.setStringValue("");
                        InfoController.this.distributionCnameUrlField.setToolTip("");
                    } else {
                        InfoController.this.distributionCnameField.setStringValue(StringUtils.join((Object[])cnames, (char)' '));
                        DescriptiveUrl url = cdn.toUrl(file).find(DescriptiveUrl.Type.cname);
                        if (!url.equals((Object)DescriptiveUrl.EMPTY)) {
                            InfoController.this.distributionCnameUrlField.setAttributedStringValue(HyperlinkAttributedStringFactory.create((DescriptiveUrl)url));
                            InfoController.this.distributionCnameUrlField.setToolTip(LocaleFactory.localizedString((String)"CDN URL"));
                        }
                    }
                    if (cdn.getFeature(Index.class, distribution.getMethod()) != null) {
                        for (Path next : distribution.getRootDocuments()) {
                            if (!next.isFile()) continue;
                            InfoController.this.distributionDefaultRootPopup.addItemWithTitle(next.getName());
                            InfoController.this.distributionDefaultRootPopup.lastItem().setRepresentedObject(next.getName());
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)distribution.getIndexDocument())) {
                        if (null == InfoController.this.distributionDefaultRootPopup.itemWithTitle(distribution.getIndexDocument())) {
                            InfoController.this.distributionDefaultRootPopup.addItemWithTitle(distribution.getIndexDocument());
                        }
                        InfoController.this.distributionDefaultRootPopup.selectItemWithTitle(distribution.getIndexDocument());
                    } else {
                        InfoController.this.distributionDefaultRootPopup.selectItemWithTitle(LocaleFactory.localizedString((String)"None"));
                    }
                    StringBuilder tooltip = new StringBuilder();
                    Iterator iter = InfoController.this.files.iterator();
                    while (iter.hasNext()) {
                        Path f = (Path)iter.next();
                        tooltip.append(f.getAbsolute());
                        if (!iter.hasNext()) continue;
                        tooltip.append("\n");
                    }
                    InfoController.this.distributionInvalidateObjectsButton.setToolTip(tooltip.toString());
                    InfoController.this.distributionInvalidationStatusField.setStringValue(distribution.getInvalidationStatus());
                    InfoController.this.toggleDistributionSettings(true);
                }
            }));
        }
    }

    public void setDistributionAnalyticsButton(NSButton b) {
        this.distributionAnalyticsButton = b;
        this.distributionAnalyticsButton.setAction(Foundation.selector((String)"distributionAnalyticsButtonClicked:"));
    }

    public void distributionAnalyticsButtonClicked(NSButton sender) {
        if (this.toggleDistributionSettings(false)) {
            boolean enabled = this.distributionAnalyticsButton.state() == 1;
            String document = this.preferences.getProperty("analytics.provider.qloudstat.iam.policy");
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new WriteIdentityWorker(this.prompt, enabled, document){

                public void cleanup(Boolean result) {
                    InfoController.this.toggleDistributionSettings(true);
                    InfoController.this.initDistribution();
                }
            }));
        }
    }

    public void setDistributionAnalyticsSetupUrlField(NSTextField f) {
        this.distributionAnalyticsSetupUrlField = f;
        this.distributionAnalyticsSetupUrlField.setAllowsEditingTextAttributes(true);
        this.distributionAnalyticsSetupUrlField.setSelectable(true);
    }

    public void calculateSizeButtonClicked(ID sender) {
        if (this.toggleSizeSettings(false)) {
            this.controller.background((BackgroundAction)new WorkerBackgroundAction(this.controller, this.session, (Worker)new CalculateSizeWorker(this.files, (ProgressListener)this.controller){

                public void cleanup(Long size) {
                    InfoController.this.setSize(size);
                    InfoController.this.toggleSizeSettings(true);
                }

                protected void update(final long size) {
                    InfoController.this.invoke((MainAction)new WindowMainAction((WindowController)InfoController.this){

                        public void run() {
                            InfoController.this.setSize(size);
                        }
                    });
                }
            }));
        }
    }

    private boolean toggleSizeSettings(boolean stop) {
        this.window().endEditingFor(null);
        this.sizeButton.setEnabled(false);
        for (Path next : this.files) {
            if (!next.isDirectory()) continue;
            this.sizeButton.setEnabled(stop);
            break;
        }
        if (stop) {
            this.sizeProgress.stopAnimation(null);
        } else {
            this.sizeProgress.startAnimation(null);
        }
        return true;
    }

    public void helpButtonClicked(ID sender) {
        BrowserLauncherFactory.get().open(ProviderHelpServiceFactory.get().help());
    }

    private static enum InfoToolbarItem {
        info{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)"General"), (String)"Info");
            }
        }
        ,
        permissions,
        acl{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)"Permissions"), (String)"Info");
            }
        }
        ,
        distribution{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)"Distribution (CDN)"), (String)"Info");
            }
        }
        ,
        s3{

            @Override
            public String label() {
                return LocaleFactory.localizedString((String)StringUtils.capitalize((String)"Amazon S3"), (String)"Info");
            }
        }
        ,
        metadata;


        public String label() {
            return LocaleFactory.localizedString((String)StringUtils.capitalize((String)this.name()), (String)"Info");
        }
    }

    private static enum MetadataColumn {
        NAME,
        VALUE;

    }

    private static enum AclColumn {
        GRANTEE,
        PERMISSION;

    }
}

