/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.AlertController;
import ch.cyberduck.binding.ProxyController;
import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSComboBox;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSView;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSString;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.NullComparator;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.BrowserController;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.cocoa.foundation.NSInteger;
import org.rococoa.cocoa.foundation.NSRect;

public class GotoController
extends AlertController {
    private final NSComboBox folderCombobox;
    private final ProxyController folderComboboxModel;
    private final BrowserController parent;
    private final Cache<Path> cache;

    public GotoController(BrowserController parent, Cache<Path> cache) {
        this.parent = parent;
        this.cache = cache;
        this.folderCombobox = NSComboBox.textfieldWithFrame((NSRect)new NSRect(0.0, 26.0));
        this.folderCombobox.setCompletes(true);
        this.folderCombobox.setUsesDataSource(true);
        this.folderComboboxModel = new FolderComboboxModel(parent.workdir());
        this.folderCombobox.setDataSource(this.folderComboboxModel.id());
        this.folderCombobox.setStringValue(parent.workdir().getAbsolute());
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"Go to folder", (String)"Goto"));
        alert.setInformativeText(LocaleFactory.localizedString((String)"Enter the pathname to list:", (String)"Goto"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Go", (String)"Goto"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"Goto"));
        alert.setIcon((NSImage)IconCacheFactory.get().folderIcon(Integer.valueOf(64)));
        super.loadBundle(alert);
    }

    public NSView getAccessoryView(NSAlert alert) {
        return this.folderCombobox;
    }

    protected void focus(NSAlert alert) {
        super.focus(alert);
        this.folderCombobox.selectText(null);
    }

    public void invalidate() {
        this.folderCombobox.setDelegate(null);
        this.folderCombobox.setDataSource(null);
        super.invalidate();
    }

    public void callback(int returncode) {
        switch (returncode) {
            case 1: {
                String filename = this.folderCombobox.stringValue();
                Path workdir = this.parent.workdir();
                Path directory = ((Home)this.parent.getSession().getFeature(Home.class)).find(workdir, filename);
                if (workdir.getParent().equals((Object)directory)) {
                    this.parent.setWorkdir(directory, workdir);
                    break;
                }
                this.parent.setWorkdir(directory);
            }
        }
    }

    public boolean validate() {
        return StringUtils.isNotBlank((CharSequence)this.folderCombobox.stringValue());
    }

    private final class FolderComboboxModel
    extends ProxyController
    implements NSComboBox.DataSource {
        private final Path workdir;
        private final Comparator<Path> comparator = new NullComparator();
        private final Filter<Path> filter = new NullFilter<Path>(){

            public boolean accept(Path p) {
                return p.isDirectory();
            }
        };

        private FolderComboboxModel(Path workdir) {
            this.workdir = workdir;
        }

        public NSInteger numberOfItemsInComboBox(NSComboBox combo) {
            return new NSInteger((long)GotoController.this.cache.get((Referenceable)this.workdir).filter(this.comparator, this.filter).size());
        }

        public NSObject comboBox_objectValueForItemAtIndex(NSComboBox sender, NSInteger row) {
            return NSString.stringWithString((String)((Path)GotoController.this.cache.get((Referenceable)this.workdir).filter(this.comparator, this.filter).get(row.intValue())).getName());
        }
    }
}

