/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.application.NSAlert;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.editor.EditorFactory;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.ui.cocoa.controller.FileController;

public class CreateFileController
extends FileController {
    private final Callback callback;

    public CreateFileController(Path workdir, Path selected, Cache<Path> cache, Callback callback) {
        super(workdir, selected, cache);
        this.callback = callback;
    }

    public void loadBundle() {
        NSAlert alert = NSAlert.alert();
        alert.setAlertStyle(1);
        alert.setMessageText(LocaleFactory.localizedString((String)"Create new file", (String)"File"));
        alert.setInformativeText(LocaleFactory.localizedString((String)"Enter the name for the new file", (String)"File"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Create", (String)"File"));
        alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Cancel", (String)"File"));
        if (EditorFactory.instance().getDefaultEditor() != Application.notfound) {
            alert.addButtonWithTitle(LocaleFactory.localizedString((String)"Edit", (String)"File"));
        }
        alert.setIcon((NSImage)IconCacheFactory.get().documentIcon(null, Integer.valueOf(64)));
        super.loadBundle(alert);
    }

    @Override
    public void callback(int returncode, Path file) {
        switch (returncode) {
            case 1: {
                this.callback.callback(false, file);
                break;
            }
            case 0: {
                this.callback.callback(true, file);
            }
        }
    }

    public static interface Callback {
        public void callback(boolean var1, Path var2);
    }
}

