/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.controller;

import ch.cyberduck.binding.SheetController;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSButton;
import ch.cyberduck.binding.application.NSColor;
import ch.cyberduck.binding.application.NSFont;
import ch.cyberduck.binding.application.NSImage;
import ch.cyberduck.binding.application.NSImageView;
import ch.cyberduck.binding.application.NSLayoutManager;
import ch.cyberduck.binding.application.NSProgressIndicator;
import ch.cyberduck.binding.application.NSTextField;
import ch.cyberduck.binding.application.NSTextView;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSAttributedString;
import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSRange;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Command;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.resources.IconCacheFactory;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.MainAction;
import ch.cyberduck.core.threading.RegistryBackgroundAction;
import ch.cyberduck.core.threading.WindowMainAction;
import org.apache.commons.lang3.StringUtils;
import org.rococoa.cocoa.foundation.NSUInteger;

public class CommandController
extends SheetController
implements TranscriptListener,
NSLayoutManager.Delegate {
    private static final NSDictionary FIXED_WITH_FONT_ATTRIBUTES = NSDictionary.dictionaryWithObjectsForKeys((NSArray)NSArray.arrayWithObjects((NSObject[])new NSObject[]{NSFont.userFixedPitchFontOfSize((double)9.0), NSColor.controlTextColor()}), (NSArray)NSArray.arrayWithObjects((String[])new String[]{"NSFont", "NSColor"}));
    private NSTextField inputField;
    private NSTextView responseField;
    private NSProgressIndicator progress;
    private NSImageView image;
    private final WindowController parent;
    private final SessionPool session;

    public CommandController(WindowController parent, SessionPool session) {
        this.parent = parent;
        this.session = session;
    }

    public void setWindow(NSWindow window) {
        window.setContentMinSize(window.frame().size);
        super.setWindow(window);
    }

    public void setInputField(NSTextField inputField) {
        this.inputField = inputField;
    }

    public void setResponseField(NSTextView responseField) {
        this.responseField = responseField;
        this.responseField.setEditable(false);
        this.responseField.setSelectable(true);
        this.responseField.setUsesFontPanel(false);
        this.responseField.setRichText(false);
        this.responseField.layoutManager().setDelegate(this.id());
    }

    public void setProgress(NSProgressIndicator progress) {
        this.progress = progress;
        this.progress.setDisplayedWhenStopped(false);
    }

    public void setImage(NSImageView image) {
        this.image = image;
        this.image.setImage((NSImage)IconCacheFactory.get().applicationIcon(new Application("com.apple.Terminal"), Integer.valueOf(128)));
    }

    public void layoutManager_didCompleteLayoutForTextContainer_atEnd(NSLayoutManager layoutManager, NSObject textContainer, boolean finished) {
        if (finished && this.responseField.window().isVisible()) {
            this.responseField.scrollRangeToVisible(NSRange.NSMakeRange((NSUInteger)this.responseField.textStorage().length(), (NSUInteger)new NSUInteger(0L)));
        }
    }

    protected String getBundleName() {
        return "Command";
    }

    public void sendButtonClicked(final NSButton sender) {
        final String command = this.inputField.stringValue();
        if (StringUtils.isNotBlank((CharSequence)command)) {
            this.progress.startAnimation(null);
            sender.setEnabled(false);
            this.parent.background((BackgroundAction)new RegistryBackgroundAction<Void>((Controller)this, this.session){

                public boolean alert(BackgroundException e) {
                    return false;
                }

                public Void run(Session<?> session) throws BackgroundException {
                    Command feature = (Command)session.getFeature(Command.class);
                    feature.send(command, (ProgressListener)CommandController.this.parent, (TranscriptListener)CommandController.this);
                    return null;
                }

                public void cleanup() {
                    super.cleanup();
                    CommandController.this.progress.stopAnimation(null);
                    sender.setEnabled(true);
                }

                public String getActivity() {
                    return command;
                }
            });
        }
    }

    public void log(TranscriptListener.Type request, final String message) {
        this.invoke((MainAction)new WindowMainAction((WindowController)this){

            public void run() {
                CommandController.this.responseField.textStorage().replaceCharactersInRange_withAttributedString(NSRange.NSMakeRange((NSUInteger)CommandController.this.responseField.textStorage().length(), (NSUInteger)new NSUInteger(0L)), NSAttributedString.attributedStringWithAttributes((String)(message + "\n"), (NSDictionary)FIXED_WITH_FONT_ATTRIBUTES));
            }
        });
    }

    public void invalidate() {
        this.responseField.layoutManager().setDelegate(null);
        super.invalidate();
    }

    public void callback(int returncode) {
    }
}

