/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.callback;

import ch.cyberduck.binding.DisabledSheetCallback;
import ch.cyberduck.binding.SheetInvoker;
import ch.cyberduck.binding.WindowController;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.application.NSWindow;
import ch.cyberduck.binding.application.SheetCallback;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.cocoa.callback.PromptPasswordCallback;
import ch.cyberduck.ui.cocoa.controller.InsecureLoginAlertController;
import ch.cyberduck.ui.cocoa.controller.LoginController;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.rococoa.Foundation;
import org.rococoa.ObjCObject;
import org.rococoa.Rococoa;

public final class PromptLoginCallback
extends PromptPasswordCallback
implements LoginCallback {
    private static final Logger log = Logger.getLogger(PromptLoginCallback.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final WindowController parent;
    private NSOpenPanel select;

    public PromptLoginCallback(WindowController parent) {
        super(parent);
        this.parent = parent;
    }

    public void warn(Host bookmark, String title, String message, String continueButton, String disconnectButton, String preference) throws LoginCanceledException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Display insecure connection alert for %s", bookmark));
        }
        InsecureLoginAlertController alert = new InsecureLoginAlertController(title, message, continueButton, disconnectButton, bookmark.getProtocol(), StringUtils.isNotBlank((CharSequence)preference));
        int option = alert.beginSheet(this.parent);
        if (alert.isSuppressed()) {
            this.preferences.setProperty(preference, true);
        }
        switch (option) {
            case -1: {
                throw new LoginCanceledException();
            }
        }
    }

    public Credentials prompt(Host bookmark, String username, String title, String reason, LoginOptions options) throws LoginCanceledException {
        Credentials credentials;
        LoginController controller;
        SheetInvoker sheet;
        int option;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Prompt for credentials for %s", username));
        }
        if ((option = (sheet = new SheetInvoker((SheetCallback)(controller = new LoginController(new Host(bookmark).withCredentials(credentials = new Credentials(username).withSaved(options.keychain)), title, reason, options)), this.parent, (WindowController)controller)).beginSheet()) == -1) {
            throw new LoginCanceledException();
        }
        return credentials;
    }

    public Local select(Local identity) throws LoginCanceledException {
        NSObject selected;
        SheetInvoker sheet = new SheetInvoker((SheetCallback)new DisabledSheetCallback(), this.parent, (NSWindow)this.select){

            public int beginSheet(NSWindow window) {
                PromptLoginCallback.this.select = NSOpenPanel.openPanel();
                PromptLoginCallback.this.select.setCanChooseDirectories(false);
                PromptLoginCallback.this.select.setCanChooseFiles(true);
                PromptLoginCallback.this.select.setAllowsMultipleSelection(false);
                PromptLoginCallback.this.select.setMessage(LocaleFactory.localizedString((String)"Select the private key in PEM or PuTTY format", (String)"Credentials"));
                PromptLoginCallback.this.select.setPrompt(LocaleFactory.localizedString((String)"Choose"));
                PromptLoginCallback.this.select.beginSheetForDirectory(LocalFactory.get((String)"~/.ssh").getAbsolute(), null, PromptLoginCallback.this.parent.window(), this.id(), Foundation.selector((String)"sheetDidClose:returnCode:contextInfo:"), null);
                return this.getSelectedOption();
            }
        };
        int option = sheet.beginSheet();
        if (option == 1 && (selected = this.select.URLs().lastObject()) != null) {
            return LocalFactory.get((String)((NSURL)Rococoa.cast((ObjCObject)selected, NSURL.class)).path());
        }
        throw new LoginCanceledException();
    }
}

