/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa.callback;

import ch.cyberduck.binding.WindowController;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.exception.ChecksumException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.SSHFingerprintGenerator;
import ch.cyberduck.core.sftp.openssh.OpenSSHHostKeyVerifier;
import ch.cyberduck.ui.cocoa.controller.ChangedHostKeyAlertController;
import ch.cyberduck.ui.cocoa.controller.UnknownHostKeyAlertController;
import java.security.PublicKey;
import org.apache.log4j.Logger;

public class PromptHostKeyCallback
extends OpenSSHHostKeyVerifier {
    private static final Logger log = Logger.getLogger(PromptHostKeyCallback.class);
    private final WindowController controller;

    public PromptHostKeyCallback(WindowController c) {
        this(c, LocalFactory.get((String)PreferencesFactory.get().getProperty("ssh.knownhosts")).withBookmark(PreferencesFactory.get().getProperty("ssh.knownhosts.bookmark")));
    }

    public PromptHostKeyCallback(WindowController controller, Local file) {
        super(file);
        this.controller = controller;
    }

    protected boolean isUnknownKeyAccepted(Host hostname, PublicKey key) throws ConnectionCanceledException, ChecksumException {
        String fingerprint = new SSHFingerprintGenerator().fingerprint(key);
        UnknownHostKeyAlertController alert = new UnknownHostKeyAlertController(hostname.getHostname(), fingerprint, key);
        switch (alert.beginSheet(this.controller)) {
            case 1: {
                this.allow(hostname, key, alert.isSuppressed());
                return true;
            }
        }
        log.warn((Object)"Cannot continue without a valid host key");
        throw new ConnectionCanceledException();
    }

    protected boolean isChangedKeyAccepted(Host hostname, PublicKey key) throws ConnectionCanceledException, ChecksumException {
        String fingerprint = new SSHFingerprintGenerator().fingerprint(key);
        ChangedHostKeyAlertController alert = new ChangedHostKeyAlertController(hostname.getHostname(), fingerprint, key);
        switch (alert.beginSheet(this.controller)) {
            case 1: {
                this.allow(hostname, key, alert.isSuppressed());
                return true;
            }
        }
        log.warn((Object)"Cannot continue without a valid host key");
        throw new ConnectionCanceledException();
    }
}

