/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.binding.foundation.NSDate;
import ch.cyberduck.binding.foundation.NSDateFormatter;
import ch.cyberduck.binding.foundation.NSLocale;
import ch.cyberduck.binding.foundation.NSTimeZone;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.date.AbstractUserDateFormatter;
import ch.cyberduck.core.date.UserDateFormatter;

public class UserDefaultsDateFormatter
extends AbstractUserDateFormatter
implements UserDateFormatter {
    private static final NSLocale locale = NSLocale.currentLocale();
    private final String timezone;
    private static final NSDateFormatter longDateFormatter = NSDateFormatter.dateFormatter();
    private static final NSDateFormatter shortDateFormatter;
    private static final NSDateFormatter mediumDateFormatter;
    private static final NSDateFormatter longDateNaturalFormatter;
    private static final NSDateFormatter shortDateNaturalFormatter;
    private static final NSDateFormatter mediumDateNaturalFormatter;

    public UserDefaultsDateFormatter(String timezone) {
        this.timezone = timezone;
    }

    private static NSLocale locale() {
        return locale;
    }

    private static NSDate toDate(long milliseconds) {
        return NSDate.dateWithTimeIntervalSince1970((double)((double)milliseconds / 1000.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortFormat(long milliseconds, boolean natural) {
        NSDateFormatter nSDateFormatter = shortDateFormatter;
        synchronized (nSDateFormatter) {
            if (-1L == milliseconds) {
                return LocaleFactory.localizedString((String)"Unknown");
            }
            shortDateNaturalFormatter.setTimeZone(NSTimeZone.timeZoneWithName((String)this.timezone));
            if (natural) {
                return shortDateNaturalFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
            }
            return shortDateFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMediumFormat(long milliseconds, boolean natural) {
        NSDateFormatter nSDateFormatter = mediumDateFormatter;
        synchronized (nSDateFormatter) {
            if (-1L == milliseconds) {
                return LocaleFactory.localizedString((String)"Unknown");
            }
            mediumDateNaturalFormatter.setTimeZone(NSTimeZone.timeZoneWithName((String)this.timezone));
            if (natural) {
                return mediumDateNaturalFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
            }
            return mediumDateFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLongFormat(long milliseconds, boolean natural) {
        NSDateFormatter nSDateFormatter = longDateFormatter;
        synchronized (nSDateFormatter) {
            if (-1L == milliseconds) {
                return LocaleFactory.localizedString((String)"Unknown");
            }
            longDateFormatter.setTimeZone(NSTimeZone.timeZoneWithName((String)this.timezone));
            if (natural) {
                return longDateNaturalFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
            }
            return longDateFormatter.stringFromDate(UserDefaultsDateFormatter.toDate(milliseconds));
        }
    }

    static {
        longDateFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateFormatter.setLocale(UserDefaultsDateFormatter.locale());
        shortDateFormatter = NSDateFormatter.dateFormatter();
        shortDateFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateFormatter.setLocale(UserDefaultsDateFormatter.locale());
        mediumDateFormatter = NSDateFormatter.dateFormatter();
        mediumDateFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterMediumStyle);
        mediumDateFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterMediumStyle);
        mediumDateFormatter.setLocale(UserDefaultsDateFormatter.locale());
        longDateNaturalFormatter = NSDateFormatter.dateFormatter();
        longDateNaturalFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateNaturalFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterLongStyle);
        longDateNaturalFormatter.setLocale(UserDefaultsDateFormatter.locale());
        longDateNaturalFormatter.setDoesRelativeDateFormatting(true);
        shortDateNaturalFormatter = NSDateFormatter.dateFormatter();
        shortDateNaturalFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateNaturalFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterShortStyle);
        shortDateNaturalFormatter.setLocale(UserDefaultsDateFormatter.locale());
        shortDateNaturalFormatter.setDoesRelativeDateFormatting(true);
        mediumDateNaturalFormatter = NSDateFormatter.dateFormatter();
        mediumDateNaturalFormatter.setDateStyle(NSDateFormatter.kCFDateFormatterMediumStyle);
        mediumDateNaturalFormatter.setTimeStyle(NSDateFormatter.kCFDateFormatterMediumStyle);
        mediumDateNaturalFormatter.setLocale(UserDefaultsDateFormatter.locale());
        mediumDateNaturalFormatter.setDoesRelativeDateFormatting(true);
    }
}

