/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.cocoa;

import ch.cyberduck.binding.application.NSApplication;
import ch.cyberduck.binding.foundation.NSBundle;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.azure.AzureProtocol;
import ch.cyberduck.core.b2.B2Protocol;
import ch.cyberduck.core.brick.BrickProtocol;
import ch.cyberduck.core.dav.DAVProtocol;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.dropbox.DropboxProtocol;
import ch.cyberduck.core.ftp.FTPProtocol;
import ch.cyberduck.core.ftp.FTPTLSProtocol;
import ch.cyberduck.core.googledrive.DriveProtocol;
import ch.cyberduck.core.googlestorage.GoogleStorageProtocol;
import ch.cyberduck.core.hubic.HubicProtocol;
import ch.cyberduck.core.irods.IRODSProtocol;
import ch.cyberduck.core.nextcloud.NextcloudProtocol;
import ch.cyberduck.core.nio.LocalProtocol;
import ch.cyberduck.core.onedrive.OneDriveProtocol;
import ch.cyberduck.core.onedrive.SharepointProtocol;
import ch.cyberduck.core.openstack.SwiftProtocol;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.sds.SDSProtocol;
import ch.cyberduck.core.sftp.SFTPProtocol;
import ch.cyberduck.core.spectra.SpectraProtocol;
import ch.cyberduck.core.storegate.StoregateProtocol;
import ch.cyberduck.core.threading.AutoreleaseActionOperationBatcher;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.ui.cocoa.ApplicationUserDefaultsPreferences;
import ch.cyberduck.ui.cocoa.controller.MainController;
import org.apache.log4j.Logger;

public final class MainApplication {
    private static final Logger log = Logger.getLogger(MainApplication.class);

    private MainApplication() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... arguments) {
        AutoreleaseActionOperationBatcher autorelease = new AutoreleaseActionOperationBatcher();
        try {
            NSApplication app = NSApplication.sharedApplication();
            ApplicationUserDefaultsPreferences preferences = new ApplicationUserDefaultsPreferences();
            PreferencesFactory.set((Preferences)preferences);
            ProtocolFactory protocols = ProtocolFactory.get();
            protocols.register(new Protocol[]{new FTPProtocol(), new FTPTLSProtocol(), new SFTPProtocol(), new DAVProtocol(), new DAVSSLProtocol(), new SwiftProtocol(), new S3Protocol(), new GoogleStorageProtocol(), new AzureProtocol(), new IRODSProtocol(), new SpectraProtocol(), new B2Protocol(), new DropboxProtocol(), new DriveProtocol(), new HubicProtocol(), new OneDriveProtocol(), new SharepointProtocol(), new LocalProtocol(), new SDSProtocol(), new StoregateProtocol(), new BrickProtocol(), new NextcloudProtocol()});
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Running version %s", NSBundle.mainBundle().objectForInfoDictionaryKey("CFBundleVersion").toString()));
                log.info((Object)String.format("Running Java %s on %s", System.getProperty("java.version"), System.getProperty("os.arch")));
                log.info((Object)String.format("Available localizations:%s", preferences.applicationLocales()));
                log.info((Object)String.format("Native library path:%s", System.getProperty("java.library.path")));
                log.info((Object)String.format("Using default encoding %s", System.getProperty("file.encoding")));
            }
            protocols.loadDefaultProfiles();
            MainController c = new MainController();
            app.setDelegate(c.id());
            app.activateIgnoringOtherApps(false);
            app.run();
        }
        finally {
            autorelease.operate();
        }
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler());
    }
}

