/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate.provider;

import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.glassfish.jersey.apache.connector.LocalizationMessages;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.Statuses;

public class HttpComponentsConnector
implements Connector {
    private static final Logger log = Logger.getLogger(HttpComponentsConnector.class);
    private final CloseableHttpClient client;
    private final HttpClientContext context;

    public HttpComponentsConnector(CloseableHttpClient client, Configuration runtimeConfig) {
        this.client = client;
        this.context = HttpClientContext.create();
    }

    public ClientResponse apply(ClientRequest clientRequest) throws ProcessingException {
        HttpUriRequest request = this.toUriHttpRequest(clientRequest);
        Map<String, String> clientHeadersSnapshot = HttpComponentsConnector.writeOutBoundHeaders((MultivaluedMap<String, Object>)clientRequest.getHeaders(), request);
        try {
            CloseableHttpResponse response = this.client.execute(new HttpHost(request.getURI().getHost(), request.getURI().getPort(), request.getURI().getScheme()), (HttpRequest)request, (HttpContext)new BasicHttpContext((HttpContext)this.context));
            HeaderUtils.checkHeaderChanges(clientHeadersSnapshot, (MultivaluedMap)clientRequest.getHeaders(), (String)this.getClass().getName());
            Response.StatusType status = response.getStatusLine().getReasonPhrase() == null ? Statuses.from((int)response.getStatusLine().getStatusCode()) : Statuses.from((int)response.getStatusLine().getStatusCode(), (String)response.getStatusLine().getReasonPhrase());
            ClientResponse responseContext = new ClientResponse(status, clientRequest);
            List redirectLocations = this.context.getRedirectLocations();
            if (redirectLocations != null && !redirectLocations.isEmpty()) {
                responseContext.setResolvedRequestUri((URI)redirectLocations.get(redirectLocations.size() - 1));
            }
            Header[] respHeaders = response.getAllHeaders();
            MultivaluedMap headers = responseContext.getHeaders();
            for (Header header : respHeaders) {
                String headerName = header.getName();
                ArrayList<String> list = (ArrayList<String>)headers.get((Object)headerName);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(header.getValue());
                headers.put((Object)headerName, list);
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (headers.get((Object)"Content-Length") == null) {
                    headers.add((Object)"Content-Length", (Object)String.valueOf(entity.getContentLength()));
                }
                Header contentEncoding = entity.getContentEncoding();
                if (headers.get((Object)"Content-Encoding") == null && contentEncoding != null) {
                    headers.add((Object)"Content-Encoding", (Object)contentEncoding.getValue());
                }
            }
            responseContext.setEntityStream(this.toInputStream(response));
            return responseContext;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private InputStream toInputStream(CloseableHttpResponse response) throws IOException {
        return new HttpMethodReleaseInputStream((HttpResponse)response);
    }

    private HttpUriRequest toUriHttpRequest(ClientRequest request) {
        HttpEntity entity = this.getHttpEntity(request);
        return RequestBuilder.create((String)request.getMethod()).setUri(request.getUri()).setEntity(entity).build();
    }

    private static Map<String, String> writeOutBoundHeaders(MultivaluedMap<String, Object> headers, HttpUriRequest request) {
        Map stringHeaders = HeaderUtils.asStringHeadersSingleValue(headers);
        for (Map.Entry e : stringHeaders.entrySet()) {
            request.addHeader((String)e.getKey(), (String)e.getValue());
        }
        return stringHeaders;
    }

    private HttpEntity getHttpEntity(final ClientRequest clientRequest) {
        Object entity = clientRequest.getEntity();
        if (entity == null) {
            return null;
        }
        return new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return false;
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getContent() throws IllegalStateException {
                return null;
            }

            public void writeTo(final OutputStream outputStream) throws IOException {
                clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    public OutputStream getOutputStream(int contentLength) {
                        return outputStream;
                    }
                });
                clientRequest.writeEntity();
            }

            public boolean isStreaming() {
                return false;
            }
        };
    }

    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        return MoreExecutors.newDirectExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.response(HttpComponentsConnector.this.apply(request));
                }
                catch (Throwable t) {
                    callback.failure(t);
                }
            }
        });
    }

    public String getName() {
        return new PreferencesUseragentProvider().get();
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.FAILED_TO_STOP_CLIENT(), (Throwable)e);
        }
    }
}

