/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.StoregateWriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;

public class StoregateTouchFeature
implements Touch<VersionId> {
    private Write<VersionId> writer;

    public StoregateTouchFeature(StoregateSession session, StoregateIdProvider fileid) {
        this.writer = new StoregateWriteFeature(session, fileid);
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            StatusOutputStream out = this.writer.write(file, status, (ConnectionCallback)new DisabledConnectionCallback());
            out.close();
            return new Path(file.getParent(), file.getName(), file.getType(), new PathAttributes(file.attributes()).withVersionId(((VersionId)out.getStatus()).id));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create file {0}", (Throwable)e, file);
        }
    }

    public Touch<VersionId> withWriter(Write<VersionId> writer) {
        this.writer = writer;
        return this;
    }
}

