/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.ChunkUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class UploadsApi {
    private ApiClient apiClient;

    public UploadsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UploadsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void cancelFileUploadByToken(String token) throws ApiException {
        Object localVarPostBody = null;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling cancelFileUploadByToken");
        }
        String localVarPath = "/v4/uploads/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Node completeFileUploadByToken(String token, CompleteUploadRequest body, String xSdsDateFormat) throws ApiException {
        CompleteUploadRequest localVarPostBody = body;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling completeFileUploadByToken");
        }
        String localVarPath = "/v4/uploads/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsDateFormat != null) {
            localVarHeaderParams.put("X-Sds-Date-Format", this.apiClient.parameterToString(xSdsDateFormat));
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<Node> localVarReturnType = new GenericType<Node>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ChunkUploadResponse uploadFileByToken(String token, File file, String contentRange) throws ApiException {
        Object localVarPostBody = null;
        if (token == null) {
            throw new ApiException(400, "Missing the required parameter 'token' when calling uploadFileByToken");
        }
        if (file == null) {
            throw new ApiException(400, "Missing the required parameter 'file' when calling uploadFileByToken");
        }
        String localVarPath = "/v4/uploads/{token}".replaceAll("\\{token\\}", this.apiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentRange != null) {
            localVarHeaderParams.put("Content-Range", this.apiClient.parameterToString(contentRange));
        }
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<ChunkUploadResponse> localVarReturnType = new GenericType<ChunkUploadResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

