/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.api.SharesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateDownloadShareRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateUploadShareRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.DownloadShare;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.KeyValueEntry;
import ch.cyberduck.core.sds.io.swagger.client.model.UploadShare;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;

public class SDSSharesUrlProvider
implements PromptUrlProvider<CreateDownloadShareRequest, CreateUploadShareRequest> {
    private static final Logger log = Logger.getLogger(SDSSharesUrlProvider.class);
    private final PathContainerService containerService = new SDSPathContainerService();
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSSharesUrlProvider(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        if (file.isRoot()) {
            return false;
        }
        List<KeyValueEntry> configuration = this.session.configuration();
        switch (type) {
            case download: {
                for (KeyValueEntry entry : configuration) {
                    if (!"manageDownloadShare".equals(entry.getKey()) || !"false".equalsIgnoreCase(entry.getValue())) continue;
                    return false;
                }
                if (file.isDirectory() && this.nodeid.isEncrypted(this.containerService.getContainer(file))) {
                    return false;
                }
                return new SDSPermissionsFeature(this.session, this.nodeid).containsRole(file, SDSPermissionsFeature.DOWNLOAD_SHARE_ROLE);
            }
            case upload: {
                if (!file.isDirectory()) {
                    return false;
                }
                for (KeyValueEntry entry : configuration) {
                    if (!"manageUploadShare".equals(entry.getKey()) || !"false".equalsIgnoreCase(entry.getValue())) continue;
                    return false;
                }
                return new SDSPermissionsFeature(this.session, this.nodeid).containsRole(file, SDSPermissionsFeature.UPLOAD_SHARE_ROLE);
            }
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, CreateDownloadShareRequest options, PasswordCallback callback) throws BackgroundException {
        try {
            String help;
            DownloadShare share;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Create download share for %s", file));
            }
            if (null == options) {
                options = new CreateDownloadShareRequest();
                log.warn((Object)String.format("Use default share options %s", options));
            }
            Long fileid = Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            if (this.nodeid.isEncrypted(file)) {
                FileKey key = new NodesApi((ApiClient)this.session.getClient()).getUserFileKey(fileid, "");
                UserPrivateKey privateKey = new UserPrivateKey();
                UserKeyPairContainer keyPairContainer = this.session.keyPair();
                privateKey.setPrivateKey(keyPairContainer.getPrivateKeyContainer().getPrivateKey());
                privateKey.setVersion(keyPairContainer.getPrivateKeyContainer().getVersion());
                UserKeyPair userKeyPair = new UserKeyPair();
                userKeyPair.setUserPrivateKey(privateKey);
                Credentials passphrase = new TripleCryptKeyPair().unlock(callback, this.session.getHost(), userKeyPair);
                PlainFileKey plainFileKey = Crypto.decryptFileKey((EncryptedFileKey)TripleCryptConverter.toCryptoEncryptedFileKey(key), (UserPrivateKey)privateKey, (String)passphrase.getPassword());
                UserKeyPair pair = null == options.getPassword() ? Crypto.generateUserKeyPair((String)callback.prompt(this.session.getHost(), LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator"), LocaleFactory.localizedString((String)"Provide additional login credentials", (String)"Credentials"), new LoginOptions().icon(this.session.getHost().getProtocol().disk())).getPassword()) : Crypto.generateUserKeyPair((String)options.getPassword());
                EncryptedFileKey encryptedFileKey = Crypto.encryptFileKey((PlainFileKey)plainFileKey, (UserPublicKey)pair.getUserPublicKey());
                options.setPassword(null);
                options.setKeyPair(TripleCryptConverter.toSwaggerUserKeyPairContainer(pair));
                options.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptedFileKey));
            }
            if (null == (share = new SharesApi((ApiClient)this.session.getClient()).createDownloadShare(options.nodeId(fileid), "", null)).getExpireAt()) {
                help = MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3"));
            } else {
                long expiry = share.getExpireAt().getMillis();
                help = MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getShortFormat(expiry * 1000L));
            }
            return new DescriptiveUrl(URI.create(String.format("%s://%s/#/public/shares-downloads/%s", this.session.getHost().getProtocol().getScheme(), this.session.getHost().getHostname(), share.getAccessKey())), DescriptiveUrl.Type.signed, help);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map(e);
        }
        catch (CryptoException e) {
            throw new TripleCryptExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, CreateUploadShareRequest options, PasswordCallback callback) throws BackgroundException {
        try {
            String help;
            UploadShare share;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Create upload share for %s", file));
            }
            if (null == options) {
                options = new CreateUploadShareRequest();
                log.warn((Object)String.format("Use default share options %s", options));
            }
            if (null == (share = new SharesApi((ApiClient)this.session.getClient()).createUploadShare(options.targetId(Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()))), "", null)).getExpireAt()) {
                help = MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3"));
            } else {
                long expiry = share.getExpireAt().getMillis();
                help = MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getShortFormat(expiry * 1000L));
            }
            return new DescriptiveUrl(URI.create(String.format("%s://%s/#/public/shares-uploads/%s", this.session.getHost().getProtocol().getScheme(), this.session.getHost().getHostname(), share.getAccessKey())), DescriptiveUrl.Type.signed, help);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map(e);
        }
    }
}

