/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.api.UserApi;
import ch.cyberduck.core.sds.io.swagger.client.model.FileFileKeys;
import ch.cyberduck.core.sds.io.swagger.client.model.MissingKeysResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.UserFileKeySetBatchRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UserFileKeySetRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.UserIdFileIdItem;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.UserUserPublicKey;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptKeyPair;
import ch.cyberduck.core.shared.AbstractSchedulerFeature;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPrivateKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class SDSMissingFileKeysSchedulerFeature
extends AbstractSchedulerFeature<List<UserFileKeySetRequest>, SDSApiClient> {
    private static final Logger log = Logger.getLogger(SDSMissingFileKeysSchedulerFeature.class);

    public SDSMissingFileKeysSchedulerFeature() {
        this(PreferencesFactory.get().getLong("sds.encryption.missingkeys.scheduler.period"));
    }

    public SDSMissingFileKeysSchedulerFeature(long period) {
        super(period);
    }

    public List<UserFileKeySetRequest> operate(Session<SDSApiClient> session, PasswordCallback callback, Path file) throws BackgroundException {
        try {
            UserFileKeySetBatchRequest request;
            ArrayList<UserFileKeySetRequest> processed = new ArrayList<UserFileKeySetRequest>();
            UserPrivateKey privateKey = new UserPrivateKey();
            UserKeyPairContainer keyPairContainer = new UserApi((ApiClient)session.getClient()).getUserKeyPair("");
            privateKey.setPrivateKey(keyPairContainer.getPrivateKeyContainer().getPrivateKey());
            privateKey.setVersion(keyPairContainer.getPrivateKeyContainer().getVersion());
            UserKeyPair userKeyPair = new UserKeyPair();
            userKeyPair.setUserPrivateKey(privateKey);
            Credentials passphrase = new TripleCryptKeyPair().unlock(callback, session.getHost(), userKeyPair);
            IdProvider node = (IdProvider)session.getFeature(IdProvider.class);
            Long fileId = file != null ? Long.valueOf(Long.parseLong(node.getFileid(file, (ListProgressListener)new DisabledListProgressListener()))) : null;
            do {
                MissingKeysResponse missingKeys = new NodesApi((ApiClient)session.getClient()).missingFileKeys(null, null, null, fileId, null, "");
                Map publicKeys = missingKeys.getUsers().stream().collect(Collectors.toMap(UserUserPublicKey::getId, Function.identity()));
                Map files = missingKeys.getFiles().stream().collect(Collectors.toMap(FileFileKeys::getId, Function.identity()));
                request = new UserFileKeySetBatchRequest();
                for (UserIdFileIdItem item : missingKeys.getItems()) {
                    UserUserPublicKey publicKey = (UserUserPublicKey)publicKeys.get(item.getUserId());
                    FileFileKeys fileKeys = (FileFileKeys)files.get(item.getFileId());
                    UserFileKeySetRequest keySetRequest = new UserFileKeySetRequest().fileId(item.getFileId()).userId(item.getUserId());
                    processed.add(keySetRequest);
                    PlainFileKey plainFileKey = Crypto.decryptFileKey((EncryptedFileKey)TripleCryptConverter.toCryptoEncryptedFileKey(fileKeys.getFileKeyContainer()), (UserPrivateKey)privateKey, (String)passphrase.getPassword());
                    EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)plainFileKey, (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(publicKey.getPublicKeyContainer()));
                    keySetRequest.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Missing file key for file with id %d processed", item.getFileId()));
                    }
                    request.addItemsItem(keySetRequest);
                }
                if (request.getItems().isEmpty()) continue;
                new NodesApi((ApiClient)session.getClient()).setUserFileKeys(request, "");
            } while (!request.getItems().isEmpty());
            return processed;
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map(e);
        }
        catch (CryptoException e) {
            throw new TripleCryptExceptionMappingService().map(e);
        }
    }
}

