/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.vault.VaultFinderListProgressListener;
import ch.cyberduck.core.vault.VaultFinderListService;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;
import org.apache.log4j.Logger;

public class VaultRegistryListService
implements ListService {
    private static final Logger log = Logger.getLogger(VaultRegistryListService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final VaultRegistry registry;
    private final VaultLookupListener lookup;
    private final Session<?> session;
    private final ListService proxy;
    private boolean autodetect = this.preferences.getBoolean("cryptomator.vault.autodetect") && this.preferences.getBoolean("cryptomator.enable");

    public VaultRegistryListService(Session<?> session, ListService proxy, VaultRegistry registry, VaultLookupListener lookup) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
        this.lookup = lookup;
    }

    @Override
    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            Vault vault = this.registry.find(this.session, directory);
            if (vault.contains(directory)) {
                return vault.getFeature(this.session, ListService.class, this.proxy).list(directory, listener);
            }
            if (this.autodetect) {
                return new VaultFinderListService(this.session, this.proxy, new VaultFinderListProgressListener(this.session, this.lookup)).list(directory, listener);
            }
            return this.proxy.list(directory, listener);
        }
        catch (VaultUnlockCancelException e) {
            log.warn((Object)String.format("Canceled loading vault %s. %s", e.getVault(), e));
            throw e;
        }
    }

    @Override
    public ListService withCache(Cache<Path> cache) {
        this.proxy.withCache(cache);
        return this;
    }

    public VaultRegistryListService withAutodetect(boolean autodetect) {
        this.autodetect = autodetect && this.preferences.getBoolean("cryptomator.enable");
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryListService{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

