/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.ssl.X509TrustManager;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractX509TrustManager
implements X509TrustManager {
    private static final Logger log = Logger.getLogger(AbstractX509TrustManager.class);
    private final Set<X509Certificate> accepted = Collections.synchronizedSet(new LinkedHashSet());

    protected void accept(List<X509Certificate> certs) {
        if (log.isTraceEnabled()) {
            for (X509Certificate cert : certs) {
                log.trace((Object)String.format("Certificate %s trusted", cert.toString()));
            }
        }
        this.accepted.clear();
        this.accepted.addAll(certs);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.accepted.toArray(new X509Certificate[this.accepted.size()]);
    }
}

