/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.socket;

import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.socket.SocketConfigurator;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class DefaultSocketConfigurator
implements SocketConfigurator {
    private static final Logger log = Logger.getLogger(DefaultSocketConfigurator.class);
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public void configure(Socket socket) throws IOException {
        if (this.preferences.getInteger("connection.buffer.receive") > 0) {
            socket.setReceiveBufferSize(this.preferences.getInteger("connection.buffer.receive"));
        }
        if (this.preferences.getInteger("connection.buffer.send") > 0) {
            socket.setSendBufferSize(this.preferences.getInteger("connection.buffer.send"));
        }
        int timeout = this.preferences.getInteger("connection.timeout.seconds") * 1000;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Set timeout to %dms for socket %s", timeout, socket));
        }
        socket.setSoTimeout(timeout);
        if (this.preferences.getBoolean("connection.socket.linger")) {
            socket.setSoLinger(true, timeout);
        }
        if (this.preferences.getBoolean("connection.socket.keepalive")) {
            socket.setKeepAlive(true);
        }
    }
}

