/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.local.AbstractTemporaryFileService;
import ch.cyberduck.core.local.TemporaryFileService;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class DefaultTemporaryFileService
extends AbstractTemporaryFileService
implements TemporaryFileService {
    private final String delimiter = PreferencesFactory.get().getProperty("local.delimiter");

    @Override
    public Local create(Path file) {
        return this.create(new UUIDRandomStringService().random(), file);
    }

    @Override
    public Local create(String name) {
        return this.create(new UUIDRandomStringService().random(), name);
    }

    @Override
    public Local create(String uid, Path file) {
        String pathFormat = "%2$s%1$s%3$s%1$s%4$s";
        String normalizedPathFormat = "%2$s%1$s%3$s%1$s%4$s%1$s%5$s";
        String attributes = "";
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getRegion()) && new PathContainerService().isContainer(file)) {
            attributes = attributes + file.attributes().getRegion();
        }
        if (file.isFile() && StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            attributes = attributes + file.attributes().getVersionId();
        }
        String normalizedFileName = PathNormalizer.name(file.getAbsolute());
        File shortenTestPath = new File(PreferencesFactory.get().getProperty("tmp.dir"), String.format("%2$s%1$s%3$s%1$s%4$s%1$s%5$s", this.delimiter, uid, "", attributes, normalizedFileName));
        int shortenLength = PreferencesFactory.get().getInteger("local.temporaryfiles.shortening.threshold") - shortenTestPath.getAbsolutePath().length();
        if (shortenLength < 0) {
            // empty if block
        }
        String shortenedPath = this.shorten(file.getParent().getAbsolute(), shortenLength);
        String folder = String.format("%2$s%1$s%3$s%1$s%4$s", this.delimiter, uid, shortenedPath, attributes);
        return this.create(folder, normalizedFileName);
    }

    private Local create(String folder, String name) {
        Local file = LocalFactory.get(new File(PreferencesFactory.get().getProperty("tmp.dir"), folder).getAbsolutePath(), name);
        this.delete(file.getParent());
        return this.delete(file);
    }
}

