/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.Pattern;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.guesses.EstimateGuess;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.MatchFactory;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Scoring {
    public static final int REFERENCE_YEAR = Calendar.getInstance().get(1);
    public static final int MIN_GUESSES_BEFORE_GROWING_SEQUENCE = 10000;

    public static double log10(double n) {
        return Math.log(n) / Math.log(10.0);
    }

    public static Strength mostGuessableMatchSequence(String password, List<Match> matches) {
        return Scoring.mostGuessableMatchSequence(password, matches, false);
    }

    /*
     * WARNING - void declaration
     */
    public static Strength mostGuessableMatchSequence(String password, List<Match> matches, boolean excludeAdditive) {
        void var6_11;
        int n = password.length();
        ArrayList matchesByJ = new ArrayList();
        for (int i = 0; i < n; ++i) {
            matchesByJ.add(new ArrayList());
        }
        for (Match match : matches) {
            ((List)matchesByJ.get(match.j)).add(match);
        }
        for (List list : matchesByJ) {
            Collections.sort(list, new Comparator<Match>(){

                @Override
                public int compare(Match m1, Match m2) {
                    return m1.i - m2.i;
                }
            });
        }
        Optimal optimal = new Optimal(n);
        boolean bl = false;
        while (var6_11 < n) {
            for (Match m : (List)matchesByJ.get((int)var6_11)) {
                if (m.i > 0) {
                    for (Map.Entry<Integer, Match> entry : optimal.m.get(m.i - 1).entrySet()) {
                        int l = entry.getKey();
                        Scoring.update(password, m, l + 1, optimal, excludeAdditive);
                    }
                    continue;
                }
                Scoring.update(password, m, 1, optimal, excludeAdditive);
            }
            Scoring.bruteforceUpdate(password, (int)var6_11, optimal, excludeAdditive);
            ++var6_11;
        }
        List<Match> list = Scoring.unwind(n, optimal);
        Integer optimalL = list.size();
        double guesses = password.length() == 0 ? 1.0 : optimal.g.get(n - 1).get(optimalL);
        Strength strength = new Strength();
        strength.setPassword(password);
        strength.setGuesses(guesses);
        strength.setGuessesLog10(Scoring.log10(guesses));
        strength.setSequence(list);
        return strength;
    }

    private static void update(String password, Match m, int l, Optimal optimal, boolean excludeAdditive) {
        double g;
        int k = m.j;
        double pi = new EstimateGuess(password).exec(m);
        if (l > 1) {
            pi *= optimal.pi.get(m.i - 1).get(l - 1).doubleValue();
        }
        if (Double.isInfinite(pi)) {
            pi = Double.MAX_VALUE;
        }
        if (Double.isInfinite(g = (double)Scoring.factorial(l) * pi)) {
            g = Double.MAX_VALUE;
        }
        if (!excludeAdditive && Double.isInfinite(g += Math.pow(10000.0, l - 1))) {
            g = Double.MAX_VALUE;
        }
        for (Map.Entry<Integer, Double> competing : optimal.g.get(k).entrySet()) {
            if (competing.getKey() > l || !(competing.getValue() <= g)) continue;
            return;
        }
        optimal.g.get(k).put(l, g);
        optimal.m.get(k).put(l, m);
        optimal.pi.get(k).put(l, pi);
    }

    private static void bruteforceUpdate(String password, int k, Optimal optimal, boolean excludeAdditive) {
        Match m = Scoring.makeBruteforceMatch(password, 0, k);
        Scoring.update(password, m, 1, optimal, excludeAdditive);
        for (int i = 1; i <= k; ++i) {
            m = Scoring.makeBruteforceMatch(password, i, k);
            for (Map.Entry<Integer, Match> entry : optimal.m.get(i - 1).entrySet()) {
                int l = entry.getKey();
                Match last_m = entry.getValue();
                if (last_m.pattern == Pattern.Bruteforce) continue;
                Scoring.update(password, m, l + 1, optimal, excludeAdditive);
            }
        }
    }

    private static List<Match> unwind(int n, Optimal optimal) {
        ArrayList<Match> optimalMatchSequence = new ArrayList<Match>();
        int k = n - 1;
        if (0 <= k) {
            Integer l = null;
            Double g = Double.POSITIVE_INFINITY;
            for (Map.Entry<Integer, Double> candidate : optimal.g.get(k).entrySet()) {
                if (!(candidate.getValue() < g)) continue;
                l = candidate.getKey();
                g = candidate.getValue();
            }
            while (k >= 0) {
                Match m = optimal.m.get(k).get(l);
                optimalMatchSequence.add(0, m);
                k = m.i - 1;
                Integer n2 = l;
                Integer n3 = l = Integer.valueOf(l - 1);
            }
        }
        return optimalMatchSequence;
    }

    private static Match makeBruteforceMatch(String password, int i, int j) {
        return MatchFactory.createBruteforceMatch(i, j, password.substring(i, j + 1));
    }

    private static int factorial(int n) {
        if (n < 2) {
            return 1;
        }
        int f = 1;
        for (int i = 2; i <= n; ++i) {
            f *= i;
        }
        return f;
    }

    private static class Optimal {
        public final List<Map<Integer, Match>> m = new ArrayList<Map<Integer, Match>>();
        public final List<Map<Integer, Double>> pi = new ArrayList<Map<Integer, Double>>();
        public final List<Map<Integer, Double>> g = new ArrayList<Map<Integer, Double>>();

        public Optimal(int n) {
            for (int i = 0; i < n; ++i) {
                this.m.add(new HashMap());
                this.pi.add(new HashMap());
                this.g.add(new HashMap());
            }
        }
    }
}

