/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3HttpRequestRetryHandler;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.s3.S3Session;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.HttpMethodReleaseInputStream;
import org.jets3t.service.impl.rest.httpclient.JetS3tRequestAuthorizer;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.StorageBucketLoggingStatus;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.WebsiteConfig;

public class RequestEntityRestStorageService
extends RestS3Service {
    private static final Logger log = Logger.getLogger(RequestEntityRestStorageService.class);
    private final S3Session session;
    private final Preferences preferences = PreferencesFactory.get();

    public RequestEntityRestStorageService(final S3Session session, Jets3tProperties properties, HttpClientBuilder configuration) {
        super(null, new PreferencesUseragentProvider().get(), null, properties);
        this.session = session;
        configuration.disableContentCompression();
        configuration.setRetryHandler((HttpRequestRetryHandler)new S3HttpRequestRetryHandler((JetS3tRequestAuthorizer)this, this.preferences.getInteger("http.connections.retry")));
        configuration.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                if (response.containsHeader("x-amz-bucket-region")) {
                    String host = ((HttpUriRequest)request).getURI().getHost();
                    if (!StringUtils.equals((CharSequence)session.getHost().getHostname(), (CharSequence)host)) {
                        RequestEntityRestStorageService.this.regionEndpointCache.putRegionForBucketName(StringUtils.split((String)StringUtils.removeEnd((String)((HttpUriRequest)request).getURI().getHost(), (String)session.getHost().getHostname()), (String)".")[0], response.getFirstHeader("x-amz-bucket-region").getValue());
                    }
                }
                return super.getRedirect(request, response, context);
            }
        });
        this.setHttpClient(configuration.build());
    }

    protected void initializeDefaults() {
    }

    protected HttpClientBuilder initHttpClientBuilder() {
        return null;
    }

    protected void initializeProxy(HttpClientBuilder httpClientBuilder) {
    }

    protected HttpUriRequest setupConnection(RestStorageService.HTTP_METHOD method, String bucketName, String objectKey, Map<String, String> requestParameters) throws S3ServiceException {
        Jets3tProperties properties;
        HttpUriRequest request = super.setupConnection(method, bucketName, objectKey, requestParameters);
        if (this.preferences.getBoolean("s3.upload.expect-continue") && "PUT".equals(request.getMethod()) && !(properties = this.getJetS3tProperties()).getBoolProperty("s3service.disable-expect-continue", false)) {
            request.addHeader("Expect", "100-continue");
        }
        if (this.preferences.getBoolean("s3.bucket.requesterpays") && S3Session.isAwsHostname(this.session.getHost().getHostname()) && ("GET".equals(request.getMethod()) || "POST".equals(request.getMethod())) && !(properties = this.getJetS3tProperties()).getBoolProperty("s3service.disable-request-payer", false)) {
            request.addHeader("x-amz-request-payer", "requester");
        }
        return request;
    }

    protected boolean isTargettingGoogleStorageService() {
        return this.session.getHost().getHostname().equals(Constants.GS_DEFAULT_HOSTNAME);
    }

    public void putObjectWithRequestEntityImpl(String bucketName, StorageObject object, HttpEntity requestEntity, Map<String, String> requestParams) throws ServiceException {
        super.putObjectWithRequestEntityImpl(bucketName, object, requestEntity, requestParams);
    }

    public StorageObject getObjectImpl(boolean headOnly, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd, String versionId, Map<String, Object> requestHeaders, Map<String, String> requestParameters) throws ServiceException {
        return super.getObjectImpl(headOnly, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd, versionId, requestHeaders, requestParameters);
    }

    protected StorageObjectsChunk listObjectsInternal(String bucketName, String prefix, String delimiter, long maxListingLength, boolean automaticallyMergeChunks, String priorLastKey) throws ServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("encoding-type", "url");
        if (prefix != null) {
            parameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            parameters.put("delimiter", delimiter);
        }
        if (maxListingLength > 0L) {
            parameters.put("max-keys", String.valueOf(maxListingLength));
        }
        ArrayList<StorageObject> objects = new ArrayList<StorageObject>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        while (incompleteListing) {
            XmlResponsesSaxParser.ListBucketHandler listBucketHandler;
            if (priorLastKey != null) {
                parameters.put("marker", priorLastKey);
            } else {
                parameters.remove("marker");
            }
            HttpResponse httpResponse = this.performRestGet(bucketName, null, parameters, null);
            try {
                listBucketHandler = this.getXmlResponseSaxParser().parseListBucketResponse((InputStream)new HttpMethodReleaseInputStream(httpResponse));
                ioErrorRetryCount = 0;
            }
            catch (ServiceException e) {
                if (e.getCause() instanceof IOException && ioErrorRetryCount < 5) {
                    ++ioErrorRetryCount;
                    log.warn((Object)"Retrying bucket listing failure due to IO error", (Throwable)e);
                    continue;
                }
                throw e;
            }
            StorageObject[] partialObjects = listBucketHandler.getObjects();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialObjects.length + " objects in one batch"));
            }
            objects.addAll(Arrays.asList(partialObjects));
            String[] partialCommonPrefixes = listBucketHandler.getCommonPrefixes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialCommonPrefixes.length + " common prefixes in one batch"));
            }
            commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
            incompleteListing = listBucketHandler.isListingTruncated();
            if (incompleteListing) {
                priorLastKey = listBucketHandler.getMarkerForNextListing();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Yet to receive complete listing of bucket contents, last key for prior chunk: " + priorLastKey));
                }
            } else {
                priorLastKey = null;
            }
            if (automaticallyMergeChunks) continue;
            break;
        }
        if (automaticallyMergeChunks) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + objects.size() + " objects in total"));
            }
            return new StorageObjectsChunk(prefix, delimiter, objects.toArray(new StorageObject[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), null);
        }
        return new StorageObjectsChunk(prefix, delimiter, objects.toArray(new StorageObject[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), priorLastKey);
    }

    protected VersionOrDeleteMarkersChunk listVersionedObjectsInternal(String bucketName, String prefix, String delimiter, long maxListingLength, boolean automaticallyMergeChunks, String nextKeyMarker, String nextVersionIdMarker) throws S3ServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("encoding-type", "url");
        parameters.put("versions", null);
        if (prefix != null) {
            parameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            parameters.put("delimiter", delimiter);
        }
        if (maxListingLength > 0L) {
            parameters.put("max-keys", String.valueOf(maxListingLength));
        }
        ArrayList<BaseVersionOrDeleteMarker> items = new ArrayList<BaseVersionOrDeleteMarker>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        while (incompleteListing) {
            XmlResponsesSaxParser.ListVersionsResultsHandler handler;
            HttpResponse httpResponse;
            if (nextKeyMarker != null) {
                parameters.put("key-marker", nextKeyMarker);
            } else {
                parameters.remove("key-marker");
            }
            if (nextVersionIdMarker != null) {
                parameters.put("version-id-marker", nextVersionIdMarker);
            } else {
                parameters.remove("version-id-marker");
            }
            try {
                httpResponse = this.performRestGet(bucketName, null, parameters, null);
            }
            catch (ServiceException se) {
                throw new S3ServiceException(se);
            }
            try {
                handler = this.getXmlResponseSaxParser().parseListVersionsResponse((InputStream)new HttpMethodReleaseInputStream(httpResponse));
                ioErrorRetryCount = 0;
            }
            catch (ServiceException se) {
                if (se.getCause() instanceof IOException && ioErrorRetryCount < 5) {
                    ++ioErrorRetryCount;
                    log.warn((Object)"Retrying bucket listing failure due to IO error", (Throwable)se);
                    continue;
                }
                throw new S3ServiceException(se);
            }
            BaseVersionOrDeleteMarker[] partialItems = handler.getItems();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialItems.length + " items in one batch"));
            }
            items.addAll(Arrays.asList(partialItems));
            String[] partialCommonPrefixes = handler.getCommonPrefixes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialCommonPrefixes.length + " common prefixes in one batch"));
            }
            commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
            incompleteListing = handler.isListingTruncated();
            nextKeyMarker = handler.getNextKeyMarker();
            nextVersionIdMarker = handler.getNextVersionIdMarker();
            if (incompleteListing && log.isDebugEnabled()) {
                log.debug((Object)("Yet to receive complete listing of bucket versions, continuing with key-marker=" + nextKeyMarker + " and version-id-marker=" + nextVersionIdMarker));
            }
            if (automaticallyMergeChunks) continue;
            break;
        }
        if (automaticallyMergeChunks) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + items.size() + " items in total"));
            }
            return new VersionOrDeleteMarkersChunk(prefix, delimiter, items.toArray(new BaseVersionOrDeleteMarker[items.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), null, null);
        }
        return new VersionOrDeleteMarkersChunk(prefix, delimiter, items.toArray(new BaseVersionOrDeleteMarker[items.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), nextKeyMarker, nextVersionIdMarker);
    }

    public void verifyExpectedAndActualETagValues(String expectedETag, StorageObject uploadedObject) throws ServiceException {
        if (StringUtils.isBlank((CharSequence)uploadedObject.getETag())) {
            log.warn((Object)"No ETag to verify");
            return;
        }
        super.verifyExpectedAndActualETagValues(expectedETag, uploadedObject);
    }

    protected String getSignatureIdentifier() {
        return this.session.getSignatureIdentifier();
    }

    public String getRestHeaderPrefix() {
        return this.session.getRestHeaderPrefix();
    }

    public String getRestMetadataPrefix() {
        return this.session.getRestMetadataPrefix();
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return this.session.getXmlResponseSaxParser();
    }

    public void setBucketLoggingStatusImpl(String bucketName, StorageBucketLoggingStatus status) throws ServiceException {
        super.setBucketLoggingStatusImpl(bucketName, status);
    }

    public StorageBucketLoggingStatus getBucketLoggingStatusImpl(String bucketName) throws ServiceException {
        return super.getBucketLoggingStatusImpl(bucketName);
    }

    public WebsiteConfig getWebsiteConfigImpl(String bucketName) throws ServiceException {
        return super.getWebsiteConfigImpl(bucketName);
    }

    public void setWebsiteConfigImpl(String bucketName, WebsiteConfig config) throws ServiceException {
        super.setWebsiteConfigImpl(bucketName, config);
    }

    public void deleteWebsiteConfigImpl(String bucketName) throws ServiceException {
        super.deleteWebsiteConfigImpl(bucketName);
    }

    public void authorizeHttpRequest(HttpUriRequest httpMethod, HttpContext context, String forceRequestSignatureVersion) throws ServiceException {
        if (forceRequestSignatureVersion != null) {
            S3Protocol.AuthenticationHeaderSignatureVersion authenticationHeaderSignatureVersion = S3Protocol.AuthenticationHeaderSignatureVersion.valueOf(StringUtils.remove((String)forceRequestSignatureVersion, (String)"-"));
            log.warn((Object)String.format("Switched authentication signature version to %s", forceRequestSignatureVersion));
            this.session.setSignatureVersion(authenticationHeaderSignatureVersion);
        }
        super.authorizeHttpRequest(httpMethod, context, forceRequestSignatureVersion);
    }

    protected boolean isXmlContentType(String contentType) {
        if (null == contentType) {
            return false;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/xml")) {
            return true;
        }
        return StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"text/xml");
    }
}

