/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aws;

import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Resolver;
import ch.cyberduck.core.exception.ResolveCanceledException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.http.DisabledX509HostnameVerifier;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyFinder;
import ch.cyberduck.core.proxy.ProxySocketFactory;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.DnsResolver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class CustomClientConfiguration
extends ClientConfiguration {
    public CustomClientConfiguration(final Host bookmark) {
        this.setDnsResolver(new DnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                try {
                    return new InetAddress[]{new Resolver().resolve(host, (CancelCallback)new DisabledCancelCallback())};
                }
                catch (ResolveCanceledException | ResolveFailedException e) {
                    throw new UnknownHostException(e.getDetail(false));
                }
            }
        });
        int timeout = PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000;
        this.setConnectionTimeout(timeout);
        this.setSocketTimeout(timeout);
        PreferencesUseragentProvider ua = new PreferencesUseragentProvider();
        this.setUserAgentPrefix(ua.get());
        this.setMaxErrorRetry(0);
        this.setMaxConnections(1);
        this.setUseGzip(PreferencesFactory.get().getBoolean("http.compression.enable"));
        final ProxyFinder proxyFinder = ProxyFactory.get();
        Proxy proxy = proxyFinder.find(bookmark);
        switch (proxy.getType()) {
            case HTTP: 
            case HTTPS: {
                this.setProxyHost(proxy.getHostname());
                this.setProxyPort(proxy.getPort());
            }
        }
        final ThreadLocalHostnameDelegatingTrustManager trust = new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)new KeychainX509TrustManager((TrustManagerHostnameCallback)new DefaultTrustManagerHostnameCallback(bookmark)), bookmark.getHostname());
        this.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory((SSLSocketFactory)new CustomTrustSSLProtocolSocketFactory((X509TrustManager)trust, (X509KeyManager)new KeychainX509KeyManager(bookmark)), (HostnameVerifier)new DisabledX509HostnameVerifier()){

            public Socket createSocket(final HttpContext context) throws IOException {
                return new ProxySocketFactory(bookmark.getProtocol(), new TrustManagerHostnameCallback(){

                    public String getTarget() {
                        return ((HttpHost)context.getAttribute("http.target_host")).getHostName();
                    }
                }, proxyFinder).disable(Proxy.Type.HTTP).disable(Proxy.Type.HTTPS).createSocket();
            }

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                trust.setTarget(remoteAddress.getHostName());
                return super.connectSocket(connectTimeout, socket, host, remoteAddress, localAddress, context);
            }
        });
    }
}

