/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer.impl.jna;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.binding.foundation.NSMutableArray;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.serializer.Writer;
import java.util.Collection;

public class PlistWriter<S extends Serializable>
implements Writer<S> {
    public void write(Collection<S> collection, Local file) throws AccessDeniedException {
        NSMutableArray list = NSMutableArray.array();
        for (Serializable bookmark : collection) {
            list.addObject((NSObject)bookmark.serialize(SerializerFactory.get()));
        }
        if (!list.writeToFile(file.getAbsolute())) {
            throw new LocalAccessDeniedException(String.format("Cannot create file %s", file.getAbsolute()));
        }
    }

    public void write(S item, Local file) throws AccessDeniedException {
        if (!((NSDictionary)item.serialize(SerializerFactory.get())).writeToFile(file.getAbsolute())) {
            throw new LocalAccessDeniedException(String.format("Cannot create file %s", file.getAbsolute()));
        }
    }
}

