/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WsFtpBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(WsFtpBookmarkCollection.class);
    private static final long serialVersionUID = -254244450037887034L;

    @Override
    public String getBundleIdentifier() {
        return "com.ipswitch.wsftp";
    }

    public String getName() {
        return "WS_FTP";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.wsftp.location"));
    }

    @Override
    protected void parse(ProtocolFactory protocols, Local folder) throws AccessDeniedException {
        for (Local child : folder.list().filter((Filter)new NullFilter<Local>(){

            public boolean accept(Local file) {
                if (file.isDirectory()) {
                    return false;
                }
                return "ini".equals(file.getExtension());
            }
        })) {
            if (child.isDirectory()) {
                this.parse(protocols, child);
                continue;
            }
            this.read(protocols, child);
        }
    }

    protected void read(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            Host current = null;
            while ((line = in.readLine()) != null) {
                log.trace((Object)line);
                if (line.startsWith("[")) {
                    this.add(current);
                    current = new Host(protocols.forScheme(Scheme.ftp));
                    current.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
                    Pattern pattern = Pattern.compile("\\[(.*)\\]");
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    current.setNickname(matcher.group(1));
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)line)) {
                    this.add(current);
                    continue;
                }
                if (null == current) {
                    log.warn((Object)"Failed to detect start of bookmark");
                    continue;
                }
                this.parse(protocols, current, line);
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }

    private boolean parse(ProtocolFactory protocols, Host current, String line) {
        Scanner scanner = new Scanner(line);
        scanner.useDelimiter("=");
        if (!scanner.hasNext()) {
            log.warn((Object)("Missing key in line:" + line));
            return false;
        }
        String name = scanner.next().toLowerCase(Locale.ROOT);
        if (!scanner.hasNext()) {
            log.warn((Object)("Missing value in line:" + line));
            return false;
        }
        String value = scanner.next().replaceAll("\"", "");
        switch (name) {
            case "conntype": {
                try {
                    switch (Integer.parseInt(value)) {
                        case 4: {
                            current.setProtocol(protocols.forScheme(Scheme.sftp));
                            break;
                        }
                        case 5: {
                            current.setProtocol(protocols.forScheme(Scheme.ftps));
                        }
                    }
                    current.setPort(-1);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Unknown Protocol:" + e.getMessage()));
                }
                break;
            }
            case "host": {
                current.setHostname(value);
                break;
            }
            case "port": {
                try {
                    current.setPort(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    log.warn((Object)("Invalid Port:" + e.getMessage()));
                }
                break;
            }
            case "dir": {
                current.setDefaultPath(value);
                break;
            }
            case "comment": {
                current.setComment(value);
                break;
            }
            case "uid": {
                current.getCredentials().setUsername(value);
            }
        }
        return true;
    }

    @Override
    public boolean add(Host bookmark) {
        if (bookmark == null) {
            return false;
        }
        if (bookmark.getHostname().equals(PreferencesFactory.get().getProperty("connection.hostname.default"))) {
            return false;
        }
        return super.add(bookmark);
    }
}

