/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.importer.JsonBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class NetDrive2BookmarkCollection
extends JsonBookmarkCollection {
    private static final Logger log = Logger.getLogger(NetDrive2BookmarkCollection.class);

    public String getName() {
        return "NetDrive 2";
    }

    @Override
    public String getBundleIdentifier() {
        return "net.netdrive.NetDrive2";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.netdrive2.location"));
    }

    @Override
    protected void parse(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                boolean skip = false;
                String url = null;
                boolean ssl = false;
                Protocol protocol = null;
                String user = null;
                block29: while (reader.hasNext()) {
                    String name;
                    block8 : switch (name = reader.nextName()) {
                        case "url": {
                            url = this.readNext(name, reader);
                            if (!StringUtils.isBlank((CharSequence)url)) continue block29;
                            skip = true;
                            break;
                        }
                        case "ssl": {
                            ssl = reader.nextBoolean();
                            break;
                        }
                        case "user": {
                            user = this.readNext(name, reader);
                            break;
                        }
                        case "type": {
                            String type;
                            switch (type = this.readNext(name, reader)) {
                                case "google_cloud_storage": {
                                    protocol = protocols.forType(Protocol.Type.googlestorage);
                                    break block8;
                                }
                                case "gdrive": {
                                    protocol = protocols.forType(Protocol.Type.googledrive);
                                    break block8;
                                }
                            }
                            protocol = protocols.forName(type);
                            break;
                        }
                        default: {
                            log.warn((Object)String.format("Ignore property %s", name));
                            reader.skipValue();
                        }
                    }
                }
                reader.endObject();
                if (skip || protocol == null || !StringUtils.isNotBlank(user)) continue;
                if (ssl) {
                    switch (protocol.getType()) {
                        case ftp: {
                            protocol = protocols.forScheme(Scheme.ftps);
                            break;
                        }
                        case dav: {
                            protocol = protocols.forScheme(Scheme.davs);
                        }
                    }
                }
                try {
                    this.add(new HostParser(protocols, protocol).get(url));
                }
                catch (HostParserException e) {
                    log.warn((Object)e);
                }
            }
            reader.endArray();
        }
        catch (IOException | IllegalStateException e) {
            throw new LocalAccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }
}

