/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.impl.jna.PlistDeserializer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class InterarchyBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(InterarchyBookmarkCollection.class);
    private static final long serialVersionUID = 999209774019642938L;

    @Override
    public String getBundleIdentifier() {
        return "com.nolobe.interarchy";
    }

    public String getName() {
        return "Interarchy";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.interarchy.location"));
    }

    @Override
    protected void parse(ProtocolFactory protocols, Local file) {
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        List items = new PlistDeserializer(serialized).listForKey("Children");
        if (null == items) {
            log.error((Object)("Invalid bookmark file:" + file));
            return;
        }
        for (NSDictionary item : items) {
            this.parse(protocols, item);
        }
    }

    private void parse(ProtocolFactory protocols, NSDictionary item) {
        Host host;
        PlistDeserializer bookmark = new PlistDeserializer(item);
        List children = bookmark.listForKey("Children");
        if (null != children) {
            for (NSDictionary child : children) {
                this.parse(protocols, child);
            }
            return;
        }
        String url = bookmark.stringForKey("URL");
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        try {
            host = new HostParser(protocols).get(url);
        }
        catch (HostParserException e) {
            log.warn((Object)e);
            return;
        }
        String title = bookmark.stringForKey("Title");
        if (StringUtils.isNotBlank((CharSequence)title)) {
            host.setNickname(title);
        }
        this.add(host);
    }
}

