/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.binding.foundation.NSDictionary;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.ftp.FTPConnectMode;
import ch.cyberduck.core.importer.ThirdpartyBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.impl.jna.PlistDeserializer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class FlowBookmarkCollection
extends ThirdpartyBookmarkCollection {
    private static final Logger log = Logger.getLogger(FlowBookmarkCollection.class);
    private static final long serialVersionUID = 2017398431454618548L;

    @Override
    public String getBundleIdentifier() {
        return "com.extendmac.Flow";
    }

    public String getName() {
        return "Flow";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.flow.location"));
    }

    @Override
    protected void parse(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        NSDictionary serialized = NSDictionary.dictionaryWithContentsOfFile((String)file.getAbsolute());
        if (null == serialized) {
            throw new LocalAccessDeniedException(String.format("Invalid bookmark file %s", file));
        }
        this.parse(protocols, serialized);
    }

    private void parse(ProtocolFactory protocols, NSDictionary serialized) {
        List items = new PlistDeserializer(serialized).listForKey("BookmarkItems");
        for (NSDictionary item : items) {
            PlistDeserializer bookmark = new PlistDeserializer(item);
            String classname = bookmark.stringForKey("ClassName");
            if (null == classname) continue;
            if ("Bookmark".equals(classname)) {
                this.read(protocols, bookmark);
            }
            if (!"BookmarkFolder".equals(classname)) continue;
            this.parse(protocols, item);
        }
    }

    private boolean read(ProtocolFactory protocols, PlistDeserializer bookmark) {
        String protocol;
        String user;
        String name;
        String path;
        String server = bookmark.stringForKey("Server");
        if (null == server) {
            return false;
        }
        Host host = new Host(protocols.forScheme(Scheme.ftp), server);
        String port = bookmark.stringForKey("Port");
        if (StringUtils.isNotBlank((CharSequence)port)) {
            host.setPort(Integer.parseInt(port));
        }
        if (StringUtils.isNotBlank((CharSequence)(path = bookmark.stringForKey("InitialPath")))) {
            host.setDefaultPath(path);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = bookmark.stringForKey("Name")))) {
            host.setNickname(name);
        }
        if (StringUtils.isNotBlank((CharSequence)(user = bookmark.stringForKey("Username")))) {
            host.getCredentials().setUsername(user);
        } else {
            host.getCredentials().setUsername(PreferencesFactory.get().getProperty("connection.login.anon.name"));
        }
        String mode = bookmark.stringForKey("PreferredFTPDataConnectionType");
        if (StringUtils.isNotBlank((CharSequence)mode)) {
            if ("Passive".equals(mode)) {
                host.setFTPConnectMode(FTPConnectMode.passive);
            }
            if ("Active".equals(mode)) {
                host.setFTPConnectMode(FTPConnectMode.active);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(protocol = bookmark.stringForKey("Protocol")))) {
            try {
                switch (Integer.parseInt(protocol)) {
                    case 0: {
                        host.setProtocol(protocols.forScheme(Scheme.ftp));
                        break;
                    }
                    case 1: {
                        host.setProtocol(protocols.forScheme(Scheme.sftp));
                        break;
                    }
                    case 3: {
                        host.setProtocol(protocols.forScheme(Scheme.s3));
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (host.getPort() == Scheme.davs.getPort()) {
                            host.setProtocol(protocols.forScheme(Scheme.davs));
                            break;
                        }
                        host.setProtocol(protocols.forScheme(Scheme.dav));
                    }
                }
                host.setPort(-1);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Unknown protocol:" + e.getMessage()));
            }
        }
        this.add(host);
        return true;
    }
}

