/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.importer.XmlBookmarkCollection;
import ch.cyberduck.core.preferences.PreferencesFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;

public class CrossFtpBookmarkCollection
extends XmlBookmarkCollection {
    private static final Logger log = Logger.getLogger(CrossFtpBookmarkCollection.class);
    private static final long serialVersionUID = 7442378118872253601L;

    @Override
    public String getBundleIdentifier() {
        return "com.crossftp";
    }

    public String getName() {
        return "CrossFTP";
    }

    @Override
    public Local getFile() {
        return LocalFactory.get((String)PreferencesFactory.get().getProperty("bookmark.import.crossftp.location"));
    }

    @Override
    protected XmlBookmarkCollection.AbstractHandler getHandler(ProtocolFactory protocols) {
        return new ServerHandler(protocols);
    }

    private class ServerHandler
    extends XmlBookmarkCollection.AbstractHandler {
        private final ProtocolFactory protocols;
        private Host current = null;

        public ServerHandler(ProtocolFactory protocols) {
            this.protocols = protocols;
        }

        @Override
        public void startElement(String name, Attributes attrs) {
            switch (name) {
                case "site": {
                    this.current = new Host(this.protocols.forScheme(Scheme.ftp), attrs.getValue("hName"));
                    this.current.setNickname(attrs.getValue("name"));
                    this.current.getCredentials().setUsername(attrs.getValue("un"));
                    this.current.setWebURL(attrs.getValue("wURL"));
                    this.current.setComment(attrs.getValue("comm"));
                    this.current.setDefaultPath(attrs.getValue("path"));
                    String protocol = attrs.getValue("ftpPType");
                    try {
                        switch (Integer.valueOf(protocol)) {
                            case 1: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.ftp));
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.ftps));
                                break;
                            }
                            case 6: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.dav));
                                break;
                            }
                            case 7: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.davs));
                                break;
                            }
                            case 8: 
                            case 9: {
                                this.current.setProtocol(this.protocols.forScheme(Scheme.s3));
                            }
                        }
                        this.current.setPort(-1);
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Unknown protocol:" + e.getMessage()));
                    }
                    try {
                        this.current.setPort(Integer.parseInt(attrs.getValue("port")));
                        break;
                    }
                    catch (NumberFormatException e) {
                        log.warn((Object)("Invalid Port:" + e.getMessage()));
                    }
                }
            }
        }

        @Override
        public void endElement(String name, String elementText) {
            switch (name) {
                case "site": {
                    CrossFtpBookmarkCollection.this.add(this.current);
                }
            }
        }
    }
}

