/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.RandomStringService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.cryptomator.CryptoPathCache;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoDeleteFeature;
import ch.cyberduck.core.cryptomator.random.RandomNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.PathPriorityComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoBulkFeature<R>
implements Bulk<R> {
    private final RandomStringService random = new UUIDRandomStringService();
    private final Session<?> session;
    private final Bulk<R> delegate;
    private final CryptoVault cryptomator;

    public CryptoBulkFeature(Session<?> session, Bulk<R> delegate, Delete delete, CryptoVault cryptomator) {
        this.session = session;
        this.delegate = delegate.withDelete((Delete)new CryptoDeleteFeature(session, delete, cryptomator));
        this.cryptomator = cryptomator;
    }

    public R pre(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        HashMap<TransferItem, TransferStatus> encrypted = new HashMap<TransferItem, TransferStatus>(files.size());
        ArrayList<Map.Entry<TransferItem, TransferStatus>> sorted = new ArrayList<Map.Entry<TransferItem, TransferStatus>>(files.entrySet());
        sorted.sort(new Comparator<Map.Entry<TransferItem, TransferStatus>>(){

            @Override
            public int compare(Map.Entry<TransferItem, TransferStatus> o1, Map.Entry<TransferItem, TransferStatus> o2) {
                return new PathPriorityComparator().compare(o1.getKey().remote, o2.getKey().remote);
            }
        });
        block3: for (Map.Entry<TransferItem, TransferStatus> entry : sorted) {
            Path file = entry.getKey().remote;
            Local local = entry.getKey().local;
            TransferStatus status = entry.getValue();
            if (null == status.getHeader()) {
                Cryptor cryptor = this.cryptomator.getCryptor();
                FileHeader header = cryptor.fileHeaderCryptor().create();
                status.setHeader(cryptor.fileHeaderCryptor().encryptHeader(header));
            }
            if (null == status.getNonces()) {
                status.setNonces((NonceGenerator)new RandomNonceGenerator());
            }
            if (file.isDirectory()) {
                if (!status.isExists()) {
                    switch (type) {
                        case upload: {
                            String directoryId = this.random.random();
                            encrypted.put(new TransferItem(this.cryptomator.encrypt(this.session, file, directoryId, false), local), status);
                            continue block3;
                        }
                    }
                    encrypted.put(new TransferItem(this.cryptomator.encrypt(this.session, file), local), status);
                    continue;
                }
                encrypted.put(new TransferItem(this.cryptomator.encrypt(this.session, file), local), status);
                continue;
            }
            encrypted.put(new TransferItem(this.cryptomator.encrypt(this.session, file), local), status);
        }
        return (R)this.delegate.pre(type, encrypted, callback);
    }

    public Bulk<R> withDelete(Delete delete) {
        this.delegate.withDelete((Delete)new CryptoDeleteFeature(this.session, delete, this.cryptomator));
        return this;
    }

    public Bulk<R> withCache(Cache<Path> cache) {
        this.delegate.withCache((Cache)new CryptoPathCache(cache));
        return this;
    }

    public void post(Transfer.Type type, Map<TransferItem, TransferStatus> files, ConnectionCallback callback) throws BackgroundException {
        HashMap<TransferItem, TransferStatus> encrypted = new HashMap<TransferItem, TransferStatus>(files.size());
        for (Map.Entry<TransferItem, TransferStatus> entry : files.entrySet()) {
            TransferStatus status = entry.getValue();
            encrypted.put(new TransferItem(this.cryptomator.encrypt(this.session, entry.getKey().remote), entry.getKey().local), status);
        }
        this.delegate.post(type, encrypted, callback);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoBulkFeature{");
        sb.append("proxy=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

