/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.googlestorage.GoogleStorageAttributesFinderFeature;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;

public class GoogleStorageMetadataFeature
implements Headers {
    private static final Logger log = Logger.getLogger(GoogleStorageMetadataFeature.class);
    private final GoogleStorageSession session;
    private final PathContainerService containerService = new GoogleStoragePathContainerService();

    public GoogleStorageMetadataFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public Map<String, String> getDefault(Local local) {
        return PreferencesFactory.get().getMap("googlestorage.metadata.default");
    }

    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            try {
                return new GoogleStorageAttributesFinderFeature(this.session).find(file).getMetadata();
            }
            catch (NotfoundException e) {
                if (file.isPlaceholder()) {
                    return Collections.emptyMap();
                }
                throw e;
            }
        }
        return Collections.emptyMap();
    }

    public void setMetadata(Path file, Map<String, String> metadata) throws BackgroundException {
        if (file.isFile() || file.isPlaceholder()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Write metadata %s for file %s", metadata, file));
            }
            try {
                ((Storage)this.session.getClient()).objects().patch(this.containerService.getContainer(file).getName(), this.containerService.getKey(file), new StorageObject().setMetadata(metadata)).execute();
            }
            catch (IOException e) {
                BackgroundException failure = new GoogleStorageExceptionMappingService().map("Failure to write attributes of {0}", e, file);
                if (file.isPlaceholder() && failure instanceof NotfoundException) {
                    return;
                }
                throw failure;
            }
        }
    }
}

