/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googlestorage;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.googlestorage.GoogleStorageExceptionMappingService;
import ch.cyberduck.core.googlestorage.GoogleStoragePathContainerService;
import ch.cyberduck.core.googlestorage.GoogleStorageSession;
import com.google.api.services.storage.Storage;
import java.io.IOException;
import java.util.List;

public class GoogleStorageDeleteFeature
implements Delete {
    private final PathContainerService containerService = new GoogleStoragePathContainerService();
    private final GoogleStorageSession session;

    public GoogleStorageDeleteFeature(GoogleStorageSession session) {
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        try {
            for (Path file : files) {
                callback.delete(file);
                if (this.containerService.isContainer(file)) {
                    ((Storage)this.session.getClient()).buckets().delete(file.getName()).execute();
                    continue;
                }
                ((Storage)this.session.getClient()).objects().delete(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)).execute();
            }
        }
        catch (IOException e) {
            throw new GoogleStorageExceptionMappingService().map(e);
        }
    }

    public boolean isSupported(Path file) {
        return true;
    }

    public boolean isRecursive() {
        return false;
    }
}

