/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.spectralogic.ds3client.models.common.Range;
import com.spectralogic.ds3client.utils.Guard;

final class RangeHelper {
    private RangeHelper() {
    }

    protected static ImmutableCollection<Range> replaceRange(ImmutableCollection<Range> existingRanges, long numBytesTransferred, long intendedNumBytesToTransfer) {
        Preconditions.checkState((numBytesTransferred >= 0L ? 1 : 0) != 0, (Object)"numBytesTransferred must be >= 0.");
        Preconditions.checkState((intendedNumBytesToTransfer > 0L ? 1 : 0) != 0, (Object)"intendedNumBytesToTransfer must be > 0.");
        Preconditions.checkState((intendedNumBytesToTransfer > numBytesTransferred ? 1 : 0) != 0, (Object)"intendedNumBytesToTransfer must be > numBytesTransferred");
        if (Guard.isNullOrEmpty(existingRanges)) {
            return ImmutableList.of((Object)Range.byLength(numBytesTransferred, intendedNumBytesToTransfer - numBytesTransferred));
        }
        ImmutableList.Builder newRangesbuilder = ImmutableList.builder();
        UnmodifiableIterator existingRangesIterator = existingRanges.iterator();
        long previousAccumulatedBytesInRanges = 0L;
        long currentAccumulatedBytesInRanges = ((Range)existingRanges.iterator().next()).getLength();
        while (existingRangesIterator.hasNext()) {
            Range existingRange = (Range)existingRangesIterator.next();
            if (numBytesTransferred < currentAccumulatedBytesInRanges) {
                Range firstNewRange = Range.byPosition(existingRange.getStart() - previousAccumulatedBytesInRanges + numBytesTransferred, existingRange.getEnd());
                newRangesbuilder.add((Object)firstNewRange);
                RangeHelper.addRemainingRanges((UnmodifiableIterator<Range>)existingRangesIterator, (ImmutableList.Builder<Range>)newRangesbuilder);
                break;
            }
            previousAccumulatedBytesInRanges += existingRange.getLength();
            currentAccumulatedBytesInRanges += existingRange.getLength();
        }
        return newRangesbuilder.build();
    }

    private static void addRemainingRanges(UnmodifiableIterator<Range> existingRangesIterator, ImmutableList.Builder<Range> newRangesbuilder) {
        while (existingRangesIterator.hasNext()) {
            newRangesbuilder.add(existingRangesIterator.next());
        }
    }

    protected static long transferSizeForRanges(ImmutableCollection<Range> existingRanges) {
        long result = 0L;
        if (Guard.isNullOrEmpty(existingRanges)) {
            return result;
        }
        for (Range range : existingRanges) {
            result += range.getLength();
        }
        return result;
    }
}

