/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.channelstrategy;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelPreparable;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.ChannelStrategy;
import com.spectralogic.ds3client.helpers.strategy.channelstrategy.SeekableByteChannelDecorator;
import com.spectralogic.ds3client.models.BulkObject;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Map;

public class SequentialChannelStrategy
implements ChannelStrategy {
    private final Object lock = new Object();
    private final SetMultimap<String, Long> blobNameOffsetMap = HashMultimap.create();
    private final Map<String, SeekableByteChannelDecorator> blobNameChannelMap = new HashMap<String, SeekableByteChannelDecorator>();
    private final ChannelStrategy channelStrategyDelegate;
    private final Ds3ClientHelpers.ObjectChannelBuilder objectChannelBuilder;
    private final ChannelPreparable channelPreparer;

    public SequentialChannelStrategy(ChannelStrategy channelStrategy, Ds3ClientHelpers.ObjectChannelBuilder objectChannelBuilder, ChannelPreparable channelPreparer) {
        this.channelStrategyDelegate = channelStrategy;
        this.objectChannelBuilder = objectChannelBuilder;
        this.channelPreparer = channelPreparer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel acquireChannelForBlob(BulkObject blob) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String blobName = blob.getName();
            this.blobNameOffsetMap.put((Object)blobName, (Object)blob.getOffset());
            SeekableByteChannel seekableByteChannel = this.blobNameChannelMap.get(blobName);
            if (seekableByteChannel != null) {
                return seekableByteChannel;
            }
            return this.makeNewChannel(blob);
        }
    }

    private SeekableByteChannel makeNewChannel(BulkObject blob) throws IOException {
        this.channelPreparer.prepareChannel(blob.getName(), this.objectChannelBuilder);
        SeekableByteChannel seekableByteChannel = this.channelStrategyDelegate.acquireChannelForBlob(blob);
        SeekableByteChannelDecorator seekableByteChannelDecorator = new SeekableByteChannelDecorator(seekableByteChannel, blob.getOffset(), blob.getLength());
        this.blobNameChannelMap.put(blob.getName(), seekableByteChannelDecorator);
        return seekableByteChannelDecorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseChannelForBlob(SeekableByteChannel seekableByteChannel, BulkObject blob) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String blobName = blob.getName();
            this.blobNameOffsetMap.remove((Object)blobName, (Object)blob.getOffset());
            if (this.blobNameOffsetMap.get((Object)blobName).size() == 0) {
                this.blobNameChannelMap.remove(blobName);
                this.channelStrategyDelegate.releaseChannelForBlob(((SeekableByteChannelDecorator)seekableByteChannel).wrappedSeekableByteChannel(), blob);
            }
        }
    }
}

