/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetSuspectBlobPoolsSpectraS3Request
extends AbstractPaginationRequest {
    private String blobId;
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private String poolId;

    public GetSuspectBlobPoolsSpectraS3Request withBlobId(UUID blobId) {
        this.blobId = blobId.toString();
        this.updateQueryParam("blob_id", blobId);
        return this;
    }

    public GetSuspectBlobPoolsSpectraS3Request withBlobId(String blobId) {
        this.blobId = blobId;
        this.updateQueryParam("blob_id", blobId);
        return this;
    }

    public GetSuspectBlobPoolsSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetSuspectBlobPoolsSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetSuspectBlobPoolsSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetSuspectBlobPoolsSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetSuspectBlobPoolsSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetSuspectBlobPoolsSpectraS3Request withPoolId(UUID poolId) {
        this.poolId = poolId.toString();
        this.updateQueryParam("pool_id", poolId);
        return this;
    }

    public GetSuspectBlobPoolsSpectraS3Request withPoolId(String poolId) {
        this.poolId = poolId;
        this.updateQueryParam("pool_id", poolId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/suspect_blob_pool";
    }

    public String getBlobId() {
        return this.blobId;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public String getPoolId() {
        return this.poolId;
    }
}

