/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.WriteOptimization;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetStorageDomainsSpectraS3Request
extends AbstractPaginationRequest {
    private String autoEjectUponCron;
    private boolean autoEjectUponJobCancellation;
    private boolean autoEjectUponJobCompletion;
    private boolean autoEjectUponMediaFull;
    private boolean lastPage;
    private boolean mediaEjectionAllowed;
    private String name;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private boolean secureMediaAllocation;
    private WriteOptimization writeOptimization;

    public GetStorageDomainsSpectraS3Request withAutoEjectUponCron(String autoEjectUponCron) {
        this.autoEjectUponCron = autoEjectUponCron;
        this.updateQueryParam("auto_eject_upon_cron", autoEjectUponCron);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withAutoEjectUponJobCancellation(boolean autoEjectUponJobCancellation) {
        this.autoEjectUponJobCancellation = autoEjectUponJobCancellation;
        this.updateQueryParam("auto_eject_upon_job_cancellation", autoEjectUponJobCancellation);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withAutoEjectUponJobCompletion(boolean autoEjectUponJobCompletion) {
        this.autoEjectUponJobCompletion = autoEjectUponJobCompletion;
        this.updateQueryParam("auto_eject_upon_job_completion", autoEjectUponJobCompletion);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withAutoEjectUponMediaFull(boolean autoEjectUponMediaFull) {
        this.autoEjectUponMediaFull = autoEjectUponMediaFull;
        this.updateQueryParam("auto_eject_upon_media_full", autoEjectUponMediaFull);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetStorageDomainsSpectraS3Request withMediaEjectionAllowed(boolean mediaEjectionAllowed) {
        this.mediaEjectionAllowed = mediaEjectionAllowed;
        this.updateQueryParam("media_ejection_allowed", mediaEjectionAllowed);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withSecureMediaAllocation(boolean secureMediaAllocation) {
        this.secureMediaAllocation = secureMediaAllocation;
        this.updateQueryParam("secure_media_allocation", secureMediaAllocation);
        return this;
    }

    public GetStorageDomainsSpectraS3Request withWriteOptimization(WriteOptimization writeOptimization) {
        this.writeOptimization = writeOptimization;
        this.updateQueryParam("write_optimization", writeOptimization);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/storage_domain";
    }

    public String getAutoEjectUponCron() {
        return this.autoEjectUponCron;
    }

    public boolean getAutoEjectUponJobCancellation() {
        return this.autoEjectUponJobCancellation;
    }

    public boolean getAutoEjectUponJobCompletion() {
        return this.autoEjectUponJobCompletion;
    }

    public boolean getAutoEjectUponMediaFull() {
        return this.autoEjectUponMediaFull;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public boolean getMediaEjectionAllowed() {
        return this.mediaEjectionAllowed;
    }

    public String getName() {
        return this.name;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public boolean getSecureMediaAllocation() {
        return this.secureMediaAllocation;
    }

    public WriteOptimization getWriteOptimization() {
        return this.writeOptimization;
    }
}

